/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.network;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.network.localization.Messages;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Network
extends Plugin
implements ChangeListener,
ActionListener,
PropertyChangeListener {
    private static final int MESSAGE_CONFIGURATION = 2;
    private IBAPFinder api;
    private IBAPFinder.IDevice selectedDevice;
    private JTextField textFieldIP;
    private JTextField textFieldSubnet;
    private JTextField textFieldBoSeIP;
    private JTextField textFieldGateway;
    private JTextField textFieldHostname;
    private JCheckBox checkBoxDHCP;
    private JPanel panelBoSeIP;
    private JPanel panelDHCP;
    private JPanel panelIP;
    private JPanel panelSubnet;
    private JPanel panelGateway;
    private JPanel panelHostname;
    private JPanel panelSettings;
    private JPanel panelButtons;
    private JButton buttonCommit;
    private JScrollPane scrollPane;

    @Override
    public void initialize(IBAPFinder api) throws PluginException {
        this.api = api;
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportBorder(null);
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportView(this.getPanelSettings());
        this.scrollPane.setName(Messages.getString("Network.100"));
        api.addComponent(this.scrollPane);
    }

    @Override
    public String getName() {
        return "Network";
    }

    @Override
    public void selectedDeviceChanged(IBAPFinder.IDevice device) {
        if (this.selectedDevice != null) {
            this.selectedDevice.removePropertyChangeListener(this);
        }
        this.selectedDevice = device;
        if (this.selectedDevice != null) {
            this.selectedDevice.addPropertyChangeListener(this);
        }
        if (this.selectedDevice == null || !this.selectedDevice.isOnline() || this.selectedDevice.getId() <= 0L) {
            this.buttonCommit.setEnabled(false);
            this.textFieldIP.setEnabled(false);
            this.textFieldIP.setText("");
            this.textFieldSubnet.setEnabled(false);
            this.textFieldSubnet.setText("");
            this.textFieldBoSeIP.setEnabled(false);
            this.textFieldBoSeIP.setText("");
            this.textFieldGateway.setEnabled(false);
            this.textFieldGateway.setText("");
            this.textFieldHostname.setEnabled(false);
            this.textFieldHostname.setText("");
            this.checkBoxDHCP.setEnabled(false);
        } else {
            this.buttonCommit.setEnabled(this.selectedDevice.isUdp() && this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldHostname.setEnabled(this.selectedDevice.hasFeature(8L) && this.selectedDevice.isUdp());
            this.textFieldHostname.setEditable(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldHostname.setText(this.selectedDevice.getHostname());
            this.checkBoxDHCP.setEnabled(this.selectedDevice.hasFeature(4L) && this.selectedDevice.isUdp());
            this.checkBoxDHCP.setSelected(this.selectedDevice instanceof IBAPFinder.IBAP ? ((IBAPFinder.IBAP)this.selectedDevice).isDhcp() : false);
            if (this.selectedDevice.hasFeature(16384L)) {
                this.textFieldBoSeIP.setEnabled(false);
                this.textFieldBoSeIP.setText(Messages.getString("Network.67"));
            } else {
                this.textFieldBoSeIP.setEnabled(this.selectedDevice.isUdp());
                if (this.selectedDevice instanceof IBAPFinder.IBAP) {
                    this.textFieldBoSeIP.setText(((IBAPFinder.IBAP)this.selectedDevice).getServerIP());
                }
            }
            this.textFieldBoSeIP.setEditable(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldIP.setEnabled(this.selectedDevice.isUdp());
            this.textFieldIP.setEditable(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldIP.setText(this.selectedDevice.getIp());
            this.textFieldSubnet.setEnabled(this.selectedDevice.isUdp());
            this.textFieldSubnet.setEditable(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldSubnet.setText(this.selectedDevice.getSubnetmask());
            this.textFieldGateway.setEnabled(this.selectedDevice.isUdp());
            this.textFieldGateway.setEditable(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.textFieldGateway.setText(this.selectedDevice.getGateway());
            this.panelDHCP.setVisible(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.panelBoSeIP.setVisible(this.selectedDevice instanceof IBAPFinder.IBAP);
            this.panelButtons.setVisible(this.selectedDevice instanceof IBAPFinder.IBAP);
        }
    }

    @Override
    public PluginVersion getVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public PluginVersion neededAPIVersion() {
        return new PluginVersion(1, 2, 0, 0);
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new BoxLayout(this.panelSettings, 1));
            this.panelSettings.add(this.getPanelBoSeIP());
            this.panelSettings.add(this.getPanelDHCP());
            this.panelSettings.add(this.getPanelIP());
            this.panelSettings.add(this.getPanelSubnet());
            this.panelSettings.add(this.getPanelGateway());
            this.panelSettings.add(this.getPanelHostname());
            this.panelSettings.add(Box.createVerticalGlue());
            this.panelSettings.add(this.getPanelButtons());
            this.panelSettings.setPreferredSize(new Dimension(180, this.panelSettings.getPreferredSize().height));
        }
        return this.panelSettings;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel();
            this.panelButtons.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new EtchedBorder(1, null, null)));
            this.panelButtons.setLayout(new BoxLayout(this.panelButtons, 0));
            this.panelButtons.add(Box.createHorizontalGlue());
            this.panelButtons.add(this.getButtonCommit());
        }
        return this.panelButtons;
    }

    private JPanel getPanelBoSeIP() {
        if (this.panelBoSeIP == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.gridx = 0;
            this.panelBoSeIP = new JPanel();
            this.panelBoSeIP.setLayout(new GridBagLayout());
            this.panelBoSeIP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.74"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelBoSeIP.add((Component)this.getTextFieldBoSeIP(), gridBagConstraints10);
            this.panelBoSeIP.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelBoSeIP.getPreferredSize().height));
        }
        return this.panelBoSeIP;
    }

    private JTextField getTextFieldBoSeIP() {
        if (this.textFieldBoSeIP == null) {
            this.textFieldBoSeIP = new JTextField();
            this.textFieldBoSeIP.setEnabled(false);
        }
        return this.textFieldBoSeIP;
    }

    private JCheckBox getCheckBoxDHCP() {
        if (this.checkBoxDHCP == null) {
            this.checkBoxDHCP = new JCheckBox(Messages.getString("Network.76"));
            this.checkBoxDHCP.setFont(new Font("Tahoma", 0, 11));
            this.checkBoxDHCP.setEnabled(false);
            this.checkBoxDHCP.addChangeListener(this);
        }
        return this.checkBoxDHCP;
    }

    private JPanel getPanelDHCP() {
        if (this.panelDHCP == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 0;
            this.panelDHCP = new JPanel();
            this.panelDHCP.setLayout(new GridBagLayout());
            this.panelDHCP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.78"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelDHCP.add((Component)this.getCheckBoxDHCP(), gridBagConstraints11);
            this.panelDHCP.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelDHCP.getPreferredSize().height));
        }
        return this.panelDHCP;
    }

    private JTextField getTextFieldIP() {
        if (this.textFieldIP == null) {
            this.textFieldIP = new JTextField();
            this.textFieldIP.setEnabled(false);
        }
        return this.textFieldIP;
    }

    private JPanel getPanelIP() {
        if (this.panelIP == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridx = 0;
            this.panelIP = new JPanel();
            this.panelIP.setLayout(new GridBagLayout());
            this.panelIP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.80"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelIP.add((Component)this.getTextFieldIP(), gridBagConstraints12);
            this.panelIP.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelIP.getPreferredSize().height));
        }
        return this.panelIP;
    }

    private JTextField getTextFieldSubnet() {
        if (this.textFieldSubnet == null) {
            this.textFieldSubnet = new JTextField();
            this.textFieldSubnet.setEnabled(false);
        }
        return this.textFieldSubnet;
    }

    private JPanel getPanelSubnet() {
        if (this.panelSubnet == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridx = 0;
            this.panelSubnet = new JPanel();
            this.panelSubnet.setLayout(new GridBagLayout());
            this.panelSubnet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.82"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelSubnet.add((Component)this.getTextFieldSubnet(), gridBagConstraints13);
            this.panelSubnet.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelSubnet.getPreferredSize().height));
        }
        return this.panelSubnet;
    }

    private JTextField getTextFieldGateway() {
        if (this.textFieldGateway == null) {
            this.textFieldGateway = new JTextField();
            this.textFieldGateway.setEnabled(false);
        }
        return this.textFieldGateway;
    }

    private JPanel getPanelGateway() {
        if (this.panelGateway == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.gridx = 0;
            this.panelGateway = new JPanel();
            this.panelGateway.setLayout(new GridBagLayout());
            this.panelGateway.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.84"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelGateway.add((Component)this.getTextFieldGateway(), gridBagConstraints14);
            this.panelGateway.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelGateway.getPreferredSize().height));
        }
        return this.panelGateway;
    }

    private JTextField getTextFieldHostname() {
        if (this.textFieldHostname == null) {
            this.textFieldHostname = new JTextField();
            this.textFieldHostname.setText(Messages.getString("Network.86"));
            this.textFieldHostname.setEnabled(false);
        }
        return this.textFieldHostname;
    }

    private JPanel getPanelHostname() {
        if (this.panelHostname == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.gridx = 0;
            this.panelHostname = new JPanel();
            this.panelHostname.setLayout(new GridBagLayout());
            this.panelHostname.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("Network.87"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelHostname.add((Component)this.getTextFieldHostname(), gridBagConstraints15);
            this.panelHostname.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.panelHostname.getPreferredSize().height));
        }
        return this.panelHostname;
    }

    private JButton getButtonCommit() {
        if (this.buttonCommit == null) {
            this.buttonCommit = new JButton();
            this.buttonCommit.setEnabled(false);
            this.buttonCommit.setPreferredSize(new Dimension(100, 25));
            this.buttonCommit.setFont(new Font("Tahoma", 0, 11));
            this.buttonCommit.setText(Messages.getString("Network.90"));
            this.buttonCommit.setActionCommand("submit");
            this.buttonCommit.addActionListener(this);
        }
        return this.buttonCommit;
    }

    private boolean send(IBAPFinder.IDevice device, boolean dhcp, String boseIP, String bapIP, String subnetmask, String gateway, String hostname) {
        RandomArrayStream randomArrayStream = new RandomArrayStream();
        IBAPFinder.IMessage result = null;
        try {
            randomArrayStream.writeBoolean(false);
            randomArrayStream.writeBoolean(dhcp);
            randomArrayStream.writeInt(boseIP.length());
            randomArrayStream.writeString(boseIP);
            randomArrayStream.writeInt(bapIP.length());
            randomArrayStream.writeString(bapIP);
            randomArrayStream.writeInt(subnetmask.length());
            randomArrayStream.writeString(subnetmask);
            randomArrayStream.writeInt(gateway.length());
            randomArrayStream.writeString(gateway);
            randomArrayStream.writeInt(hostname.length());
            randomArrayStream.writeString(hostname);
            result = this.api.broadcastToConfigPort(device, 2, randomArrayStream);
        }
        catch (Exception exception) {
            result = null;
        }
        randomArrayStream.close();
        return result != null && result.getMessageType() != 3;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("submit")) {
            String hostname;
            String gateway;
            String subnetmask;
            String bapIP;
            String boseIP;
            if (!this.checkValues()) {
                JOptionPane.showMessageDialog(Tools.findWindow(this.buttonCommit), Messages.getString("Network.40"));
                return;
            }
            boolean dhcp = this.checkBoxDHCP.isSelected();
            boolean result = this.send(this.selectedDevice, dhcp, boseIP = this.textFieldBoSeIP.getText(), bapIP = this.textFieldIP.getText(), subnetmask = this.textFieldSubnet.getText(), gateway = this.textFieldGateway.getText(), hostname = this.textFieldHostname.getText());
            if (result) {
                JOptionPane.showMessageDialog(Tools.findWindow(this.buttonCommit), Messages.getString("Network.42"));
                this.api.removeDevice(this.selectedDevice.getMac());
            } else {
                JOptionPane.showMessageDialog(Tools.findWindow(this.buttonCommit), Messages.getString("Network.41"));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.checkBoxDHCP && this.checkBoxDHCP.isEnabled()) {
            if (this.checkBoxDHCP.isSelected()) {
                this.textFieldIP.setEnabled(false);
                this.textFieldSubnet.setEnabled(false);
                this.textFieldGateway.setEnabled(false);
            } else {
                this.textFieldIP.setEnabled(true);
                this.textFieldSubnet.setEnabled(true);
                this.textFieldGateway.setEnabled(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkValues() {
        String pattern = "([0-9.]+)";
        String patternP = "([0-9.:]+)";
        if (!this.selectedDevice.hasFeature(1L)) {
            if (!this.selectedDevice.hasFeature(16384L) && (!Pattern.matches(pattern, this.textFieldBoSeIP.getText()) || Network.getAnzahlPunkte(this.textFieldBoSeIP.getText()) != 3) || !Pattern.matches(pattern, this.textFieldIP.getText()) || Network.getAnzahlPunkte(this.textFieldIP.getText()) != 3 || !Pattern.matches(pattern, this.textFieldSubnet.getText()) || Network.getAnzahlPunkte(this.textFieldSubnet.getText()) != 3 || (!Pattern.matches(pattern, this.textFieldGateway.getText()) || Network.getAnzahlPunkte(this.textFieldGateway.getText()) != 3) && this.textFieldGateway.getText().length() != 0) return false;
            if (!this.selectedDevice.hasFeature(8L)) return true;
            if (this.textFieldHostname.getText().length() >= 11) return false;
            return true;
        }
        if (!Pattern.matches(patternP, this.textFieldBoSeIP.getText()) || Network.getAnzahlPunkte(this.textFieldBoSeIP.getText()) != 3 || this.textFieldHostname.getText().length() >= 30) return false;
        if (this.checkBoxDHCP.isSelected()) return true;
        if (!Pattern.matches(pattern, this.textFieldIP.getText()) || Network.getAnzahlPunkte(this.textFieldIP.getText()) != 3 || !Pattern.matches(pattern, this.textFieldSubnet.getText()) || Network.getAnzahlPunkte(this.textFieldSubnet.getText()) != 3 || (!Pattern.matches(pattern, this.textFieldGateway.getText()) || Network.getAnzahlPunkte(this.textFieldGateway.getText()) != 3) && this.textFieldGateway.getText().length() != 0) return false;
        return true;
    }

    private static int getAnzahlPunkte(String text) {
        int textLength = text.length();
        int index = 0;
        int pointCounter = 0;
        while (index < textLength) {
            if (text.substring(index, index + 1).equals(".")) {
                ++pointCounter;
            }
            ++index;
        }
        return pointCounter;
    }

    public boolean saveConfig(IBAPFinder.IBAP bap, IBAPFinder.IBAP bapData) {
        return this.send(bap, bapData.isDhcp(), bapData.getServerIP(), bapData.getIp(), bapData.getSubnetmask(), bapData.getGateway(), bapData.getHostname());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

