/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;

public abstract class Plugin {
    private String imagePath;

    public Plugin() {
        String className = this.getClass().getName();
        String path = className.substring(0, className.lastIndexOf("." + this.getClass().getSimpleName()));
        this.imagePath = String.valueOf(path.replace('.', File.separatorChar)) + File.separator + "images" + File.separatorChar;
    }

    public BufferedImage loadImage(String name) {
        BufferedImage image;
        block16: {
            image = null;
            InputStream inputStream = null;
            name = String.valueOf(this.imagePath) + name;
            try {
                try {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream(name.replace('\\', '/'));
                    if (inputStream == null) {
                        throw new Exception();
                    }
                    image = ImageIO.read(inputStream);
                }
                catch (Exception e) {
                    try {
                        inputStream = new FileInputStream(new File(name));
                        image = ImageIO.read(inputStream);
                    }
                    catch (Exception exception) {
                        System.err.println("BAPFinder.loadImage() --> Error while loading image: " + e.getMessage());
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {}
                        return null;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public <T> Method getMethod(String methodName, Class<T> returnType, Object ... params) {
        Class<?> clazz = this.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        Method method = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName) && m.getReturnType() == returnType) {
                if (params != null && params.length != 0) {
                    Class<?>[] parameters = m.getParameterTypes();
                    if (parameters.length == params.length) {
                        int i = 0;
                        while (i < params.length) {
                            if (!parameters[i].isInstance(params[i])) {
                                // empty if block
                            }
                            ++i;
                        }
                    }
                } else {
                    method = m;
                    break;
                }
            }
            ++n2;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public <T> boolean hasMethod(String methodName, Class<T> returnType, Object ... params) {
        return this.getMethod(methodName, returnType, params) != null;
    }

    public <T> T call(String methodName, Class<T> returnType, Object ... params) throws PluginException {
        Method method = this.getMethod(methodName, returnType, params);
        if (method == null) {
            throw new PluginException(String.format("Method %s not found", methodName));
        }
        Object result = null;
        try {
            result = method.invoke((Object)this, params);
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        return (T)result;
    }

    public abstract void initialize(IBAPFinder var1) throws PluginException;

    public abstract String getName();

    public abstract void selectedDeviceChanged(IBAPFinder.IDevice var1);

    public abstract PluginVersion getVersion();

    public abstract PluginVersion neededAPIVersion();
}

