/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public class JImage
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Image image = null;
    private boolean autoSize = false;
    private boolean center = false;

    public JImage() {
        this.setPreferredSize(new Dimension(32, 32));
        this.setSize(32, 32);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.center) {
                g2.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth(null) / 2, this.getHeight() / 2 - this.image.getHeight(null) / 2, null);
            } else {
                g2.drawImage(this.image, 0, 0, null);
            }
        }
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoResize) {
        this.autoSize = autoResize;
        if (this.autoSize && this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
            this.setSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
            this.validate();
            this.repaint();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
            this.validate();
            this.repaint();
        }
    }

    public void setCenter(boolean center) {
        this.center = center;
        this.validate();
        this.repaint();
    }

    public boolean isCenter() {
        return this.center;
    }
}

