/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.BAPFinder;
import de.bsc.bapfinder.components.JWizardHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class LanguageSelection
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton buttonSave = null;
    private JButton buttonCancel = null;
    private JWizardHeader wizardHeader = null;
    private JPanel panelSettings = null;
    private JComboBox comboBoxLanguages = null;
    private List<LanguageLabel> languages = new ArrayList<LanguageLabel>();
    private JPanel panelButtons = null;
    private JPanel panelLanguages = null;

    public LanguageSelection(Window owner) {
        super(owner);
        this.setSize(340, 170);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Sprachauswahl");
        this.setMinimumSize(new Dimension(433, 0));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
        this.setResizable(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPanelSettings(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPanelButtons(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setTextHeader1("Sprachauswahl");
            this.wizardHeader.setTextHeader2("W\u00e4hlen Sie hier die Programmsprache aus");
            this.wizardHeader.setImage(BAPFinder.loadImage("flag.png"));
        }
        return this.wizardHeader;
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 0;
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new GridBagLayout());
            this.panelSettings.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelSettings.add((Component)this.getPanelLanguages(), gridBagConstraints4);
        }
        return this.panelSettings;
    }

    private JComboBox getComboBoxLanguages() {
        if (this.comboBoxLanguages == null) {
            this.comboBoxLanguages = new JComboBox();
            this.comboBoxLanguages.setRenderer(new CellRenderer());
            int i = 0;
            while (i < this.languages.size()) {
                this.comboBoxLanguages.addItem(this.languages.get(i));
                ++i;
            }
            this.comboBoxLanguages.setActionCommand("select");
            this.comboBoxLanguages.addActionListener(this);
        }
        return this.comboBoxLanguages;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("speichern") && !e.getActionCommand().equals("select") && e.getActionCommand().equals("abbruch")) {
            this.dispose();
        }
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(5, 0, 5, 5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 13;
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new GridBagLayout());
            this.panelButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelButtons.add((Component)this.getButtonSave(), gridBagConstraints6);
            this.panelButtons.add((Component)this.getButtonCancel(), gridBagConstraints7);
        }
        return this.panelButtons;
    }

    private JButton getButtonSave() {
        if (this.buttonSave == null) {
            this.buttonSave = new JButton("Speichern");
            this.buttonSave.setPreferredSize(new Dimension(100, 24));
            this.buttonSave.setActionCommand("speichern");
            this.buttonSave.addActionListener(this);
        }
        return this.buttonSave;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton("Abbruch");
            this.buttonCancel.setPreferredSize(new Dimension(100, 24));
            this.buttonCancel.setActionCommand("abbruch");
            this.buttonCancel.addActionListener(this);
        }
        return this.buttonCancel;
    }

    private JPanel getPanelLanguages() {
        if (this.panelLanguages == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridx = 0;
            this.panelLanguages = new JPanel();
            this.panelLanguages.setLayout(new GridBagLayout());
            this.panelLanguages.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Verf\u00fcgbare Sprachen", 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelLanguages.add((Component)this.getComboBoxLanguages(), gridBagConstraints5);
        }
        return this.panelLanguages;
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LanguageLabel) {
                JLabel label = (JLabel)value;
                label.setOpaque(true);
                label.setForeground(component.getForeground());
                label.setBackground(component.getBackground());
                return label;
            }
            return component;
        }
    }

    private class LanguageLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private String path;

        public LanguageLabel(String text) {
            super(text);
            this.path = null;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

