/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.Device;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BoSeServer
extends Device
implements IBAPFinder.IBoSeServer {
    private PluginVersion pluginVersion;

    private BoSeServer() {
    }

    public BoSeServer(byte[] data, int port) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int messageType = dataInputStream.readInt();
        if (messageType != 1) {
            throw new Exception("No answer to configuration request received");
        }
        this.setIp(Tools.readString(dataInputStream));
        this.setPort(port);
        this.setSubnetmask(Tools.readString(dataInputStream));
        this.setGateway(Tools.readString(dataInputStream));
        this.setHostname(Tools.readString(dataInputStream));
        this.setMac(Tools.readString(dataInputStream));
        this.setId(dataInputStream.readLong());
        this.setFeatures(dataInputStream.readLong());
        this.setVersion(dataInputStream.readLong());
        if (this.hasFeature(4096L)) {
            this.setCommands(dataInputStream.readLong());
        }
        this.setUdp(true);
        this.setOnline(true);
        this.setLastMessageTime(System.currentTimeMillis());
    }

    @Override
    public void setVersion(long version) {
        super.setVersion(version);
        this.pluginVersion = new PluginVersion(version);
    }

    @Override
    protected void update(Device device) {
    }

    @Override
    public BoSeServer clone() {
        BoSeServer boSeServer = new BoSeServer();
        boSeServer.ip = this.ip;
        boSeServer.port = this.port;
        boSeServer.subnetmask = this.subnetmask;
        boSeServer.gateway = this.gateway;
        boSeServer.hostname = this.hostname;
        boSeServer.id = this.id;
        boSeServer.mac = this.mac;
        boSeServer.version = this.version;
        boSeServer.features = this.features;
        boSeServer.commands = this.commands;
        boSeServer.udp = this.udp;
        return boSeServer;
    }

    @Override
    public String getVersionString() {
        if (this.pluginVersion == null) {
            return "00.00.00 Build 0000";
        }
        return this.pluginVersion.getVersionString();
    }
}

