/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.BAP;
import de.bsc.bapfinder.BoSeServer;
import de.bsc.bapfinder.Device;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.LanguageSelection;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.localization.Messages;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.tools.Message;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BAPFinder
extends JFrame
implements IBAPFinder,
ActionListener,
ListSelectionListener,
ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    static final int MESSAGE_REQUEST_ANSWER = 5;
    static final int REQUEST_CONFIGURATION = 1;
    private static final PluginVersion apiVersion = new PluginVersion(1, 2, 0, 0);
    private static BufferedImage imageBAP;
    private static BufferedImage imageBoSe;
    private static String imagePath;
    private static Properties properties;
    private Thread broadcastThread;
    private Thread serverThreadUDP;
    private Thread serverThreadTCP;
    private boolean terminated;
    private JList listSelect;
    private IBAPFinder.IDevice selectedDevice;
    private List<IBAPFinder.IDeviceListener> listeners;
    private List<Plugin> plugins;
    private JWizardHeader wizardHeader;
    private JScrollPane paneSelect;
    private JPanel jContentPane;
    private JPanel buttonPanel;
    private DefaultListModel listModel;
    private JSplitPane jSplitPane;
    private JMenuBar menuBar = null;
    private JMenu menuFile;
    private JTabbedPane tabbedPane;
    private static final int portBAP = 2006;
    private static final int portServer = 32006;

    public BAPFinder() {
        imagePath = String.valueOf(this.getClass().getPackage().getName().replace('.', File.separatorChar)) + File.separator + "images" + File.separatorChar;
        imageBAP = BAPFinder.loadImage("bapkl.png");
        imageBoSe = BAPFinder.loadImage("serverkl.png");
        this.listeners = new ArrayList<IBAPFinder.IDeviceListener>();
        this.plugins = new ArrayList<Plugin>();
        this.initialize();
        this.loadPlugins();
        this.initPlugins();
        this.terminated = false;
        this.broadcastThread = new Thread(this.getBroadcastThread());
        this.broadcastThread.start();
        this.serverThreadUDP = new Thread(this.getServerThreadUDP());
        this.serverThreadUDP.start();
        this.serverThreadTCP = new Thread(this.getServerThreadTCP());
        this.serverThreadTCP.start();
    }

    private void initPlugins() {
        for (Plugin plugin : this.plugins) {
            try {
                plugin.initialize(this);
                System.out.println("Plugin \"" + plugin.getName() + "\" initialized. Plugin version: " + plugin.getVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPlugins() {
        ArrayList classes = new ArrayList();
        try {
            classes.addAll(Tools.getClasses("de.bsc.bapfinder.plugins"));
            classes.addAll(Tools.getClassesFolder("plugins", "de.bsc.bapfinder.plugins"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (Class clazz : classes) {
            try {
                Class<Plugin> pluginClass = clazz.asSubclass(Plugin.class);
                Constructor<Plugin> constructor = pluginClass.getConstructor(new Class[0]);
                Plugin plugin = constructor.newInstance(new Object[0]);
                long neededAPIVersion = plugin.neededAPIVersion().getVersionWithoutBuild();
                if (neededAPIVersion > apiVersion.getVersionWithoutBuild()) continue;
                this.addPlugin(plugin);
            }
            catch (Exception exception) {}
        }
    }

    private void addPlugin(Plugin plugin) {
        boolean found = false;
        int i = 0;
        while (i < this.plugins.size()) {
            Plugin storedPlugin = this.plugins.get(i);
            if (storedPlugin.getName().equals(plugin.getName())) {
                long versionGivenPlugin;
                found = true;
                long versionStoredPlugin = storedPlugin.getVersion().getVersionWithoutBuild();
                if (versionStoredPlugin != (versionGivenPlugin = plugin.getVersion().getVersionWithoutBuild())) {
                    System.err.println("Plugin \"" + plugin.getName() + "\" has a version conflict! Version stored: " + versionStoredPlugin + ", version new: " + versionGivenPlugin);
                } else {
                    System.err.println("Plugin \"" + plugin.getName() + "\" already added. The given plugin will be discarded.");
                }
                if (versionStoredPlugin < versionGivenPlugin) {
                    System.err.println("Stored plugin \"" + plugin.getName() + "\" is older and will be replaced with the new version.");
                    this.plugins.remove(i);
                    this.plugins.add(i, plugin);
                    break;
                }
                if (versionStoredPlugin <= versionGivenPlugin) break;
                System.err.println("Stored plugin \"" + plugin.getName() + "\" is newer. The given plugin will be discarded.");
                break;
            }
            ++i;
        }
        if (!found) {
            this.plugins.add(plugin);
        }
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("BAPFinder.16"));
        this.setIconImage(BAPFinder.loadImage("bapkl.png"));
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BAPFinder.this.terminate();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                super.windowClosing(e);
            }
        });
    }

    private Runnable getBroadcastThread() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
                    byte[] buffer1 = new String("BAPREQUEST").getBytes();
                    DatagramPacket datagramPacket1 = new DatagramPacket(buffer1, buffer1.length);
                    byte[] byArray = new byte[24];
                    byArray[0] = 2;
                    byArray[1] = 3;
                    byArray[2] = 4;
                    byArray[3] = 5;
                    byArray[15] = 3;
                    byArray[19] = 4;
                    byArray[23] = 1;
                    byte[] buffer2 = byArray;
                    DatagramPacket datagramPacket2 = new DatagramPacket(buffer2, buffer2.length);
                    while (!BAPFinder.this.terminated) {
                        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                        try {
                            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                            while (ifaces.hasMoreElements()) {
                                NetworkInterface networkInterface = ifaces.nextElement();
                                if (networkInterface.isLoopback() || !networkInterface.isUp() || networkInterface.isVirtual() || networkInterface.isPointToPoint()) continue;
                                interfaces.add(networkInterface);
                            }
                        }
                        catch (Exception exception) {}
                        if (interfaces.size() == 0) {
                            Thread.sleep(500L);
                            continue;
                        }
                        for (NetworkInterface selectedInterface : interfaces) {
                            Enumeration<InetAddress> addresses = selectedInterface.getInetAddresses();
                            if (selectedInterface.isLoopback() || selectedInterface.isVirtual() || selectedInterface.isPointToPoint()) continue;
                            while (addresses.hasMoreElements()) {
                                InetAddress adapterAddress = addresses.nextElement();
                                if (adapterAddress instanceof Inet6Address) continue;
                                datagramPacket1.setPort(2006);
                                datagramPacket2.setPort(2006);
                                DatagramSocket datagramSocket = new DatagramSocket(new InetSocketAddress(adapterAddress, 0));
                                datagramSocket.connect(inetAddress, 2006);
                                datagramSocket.send(datagramPacket1);
                                datagramSocket.send(datagramPacket2);
                                datagramSocket.close();
                                datagramPacket1.setPort(32006);
                                datagramPacket2.setPort(32006);
                                datagramSocket = new DatagramSocket(new InetSocketAddress(adapterAddress, 0));
                                datagramSocket.connect(inetAddress, 32006);
                                datagramSocket.send(datagramPacket1);
                                datagramSocket.send(datagramPacket2);
                                datagramSocket.close();
                            }
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BAPFinder.this.terminate();
                }
            }
        };
    }

    private void terminate() {
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDevice(IBAPFinder.IDevice device) {
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            int i = 0;
            while (i < this.listModel.size()) {
                IBAPFinder.IDevice tmpDevice = (IBAPFinder.IDevice)this.listModel.get(i);
                if (tmpDevice.getMac().equals(device.getMac())) {
                    tmpDevice.update(device);
                    return;
                }
                ++i;
            }
            this.listModel.addElement(device);
        }
    }

    private Runnable getServerThreadUDP() {
        return new Runnable(){

            @Override
            public void run() {
                DatagramSocket datagramSocket = null;
                byte[] buffer = new byte[1024];
                try {
                    datagramSocket = new DatagramSocket(2006);
                    datagramSocket.setSoTimeout(500);
                }
                catch (SocketException socketException) {
                    System.exit(1);
                }
                while (!BAPFinder.this.terminated) {
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                        datagramSocket.receive(datagramPacket);
                        byte[] receivedBytes = new byte[datagramPacket.getLength()];
                        System.arraycopy(datagramPacket.getData(), 0, receivedBytes, 0, datagramPacket.getLength());
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(receivedBytes);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        try {
                            try {
                                Device device;
                                int sync = dataInputStream.readInt();
                                if (sync != 101124105 && sync != 269554195) {
                                    throw new Exception("No Device Message");
                                }
                                int messageType = dataInputStream.readInt();
                                if (messageType != 5) {
                                    throw new Exception("Only configurations are allowed");
                                }
                                int length = dataInputStream.readInt();
                                byte[] data = new byte[length];
                                dataInputStream.read(data);
                                try {
                                    dataInputStream.close();
                                }
                                catch (Exception exception) {}
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Exception exception) {}
                                byteArrayInputStream = new ByteArrayInputStream(data);
                                dataInputStream = new DataInputStream(byteArrayInputStream);
                                if (sync == 101124105) {
                                    device = new BAP(data, 2006);
                                } else if (sync == 269554195) {
                                    device = new BoSeServer(data, 32006);
                                } else {
                                    device = null;
                                    throw new Exception("No Device Message");
                                }
                                try {
                                    EventQueue.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            BAPFinder.this.addDevice(device);
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                BAPFinder.this.fireDeviceReceived(device);
                            }
                            catch (Exception exception) {
                                try {
                                    dataInputStream.close();
                                }
                                catch (Exception exception2) {}
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Exception exception3) {}
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                dataInputStream.close();
                            }
                            catch (Exception exception) {}
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        try {
                            dataInputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception4) {}
                    }
                }
                try {
                    datagramSocket.close();
                }
                catch (Exception exception) {}
            }
        };
    }

    private Runnable getServerThreadTCP() {
        return new Runnable(){

            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(2006, 1000);
                    serverSocket.setSoTimeout(500);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    BAPFinder.this.terminate();
                }
                Socket socket = null;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                while (!BAPFinder.this.terminated) {
                    try {
                        int character;
                        socket = serverSocket.accept();
                        inputStream = socket.getInputStream();
                        outputStream = socket.getOutputStream();
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((character = inputStream.read()) != -1) {
                            stringBuffer.append((char)character);
                        }
                        if (stringBuffer.indexOf("BAPANSWER") == -1) {
                            System.err.println("Received wrong answer. Received String: " + stringBuffer);
                            throw new Exception();
                        }
                        stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
                        final BAP bap = new BAP(stringBuffer.toString(), socket.getInetAddress().getHostAddress());
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    BAPFinder.this.addDevice(bap);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        BAPFinder.this.fireDeviceReceived(bap);
                        outputStream.write(new String("OK").getBytes());
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        socket.close();
                    }
                    catch (Exception exception) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception2) {}
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception3) {}
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception4) {}
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception5) {}
                    }
                }
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {}
            }
        };
    }

    private void fireDeviceReceived(IBAPFinder.IDevice device) {
        for (IBAPFinder.IDeviceListener listener : this.listeners) {
            listener.deviceReceived(device);
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.buttonPanel;
    }

    @Override
    public void addButton(JButton button) {
        Component[] components = this.buttonPanel.getComponents();
        int i = 0;
        while (i < components.length) {
            JButton tmpButton = (JButton)components[i];
            GridBagLayout layout = (GridBagLayout)this.buttonPanel.getLayout();
            GridBagConstraints constraints = layout.getConstraints(tmpButton);
            ++constraints.gridx;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 5, 5);
            layout.setConstraints(tmpButton, constraints);
            ++i;
        }
        GridBagConstraints constraintsButton = new GridBagConstraints();
        constraintsButton.gridx = 0;
        constraintsButton.insets = new Insets(5, 5, 5, 5);
        constraintsButton.weightx = 1.0;
        constraintsButton.anchor = 13;
        constraintsButton.gridy = 0;
        this.buttonPanel.add((Component)button, constraintsButton);
        this.pack();
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(215);
            this.jSplitPane.setBorder(BorderFactory.createEtchedBorder(1));
            this.jSplitPane.setLeftComponent(this.getPaneSelect());
            this.jSplitPane.setRightComponent(this.getTabbedPane());
        }
        return this.jSplitPane;
    }

    private JMenuBar getMenu() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.setBorder(BorderFactory.createEtchedBorder(1));
            this.menuBar.add(this.getFileMenu());
        }
        return this.menuBar;
    }

    private JMenu getFileMenu() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu("Datei");
            JMenuItem menuItem = new JMenuItem("Sprache");
            menuItem.setActionCommand("language");
            menuItem.addActionListener(this);
            this.menuFile.add(menuItem);
        }
        return this.menuFile;
    }

    public static void main(String[] args) throws Throwable {
        block19: {
            System.out.println(System.currentTimeMillis());
            properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream("./finder.ini");
                    properties.load(fileInputStream);
                }
                catch (Exception exception) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        String language = properties.getProperty("language");
        System.out.println(language);
        if (language != null && !language.equals("default")) {
            String[] variants = language.split("_");
            System.out.println(variants.length);
            Locale locale = null;
            if (variants.length == 1) {
                locale = new Locale(variants[0]);
            }
            if (variants.length == 2) {
                locale = new Locale(variants[0], variants[1].toUpperCase());
            } else if (variants.length > 2) {
                locale = new Locale(variants[0], variants[1].toUpperCase(), variants[2]);
            }
            System.out.println(locale);
            if (locale != null) {
                Locale.setDefault(locale);
                JComponent.setDefaultLocale(locale);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BAPFinder finder = new BAPFinder();
                finder.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("language")) {
            new LanguageSelection((Window)this).setVisible(true);
        }
    }

    public static String recodeString(DataInputStream dataInputStream, int length) {
        if (length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            try {
                stringBuffer.append(dataInputStream.readChar());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedDevice = this.listSelect.getSelectedIndex() == -1 ? null : (IBAPFinder.IDevice)this.listSelect.getSelectedValue();
        for (Plugin plugin : this.plugins) {
            plugin.selectedDeviceChanged(this.selectedDevice);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setTextHeader1(Messages.getString("BAPFinder.68"));
            this.wizardHeader.setTextHeader2(Messages.getString("BAPFinder.69"));
            this.wizardHeader.setImage(BAPFinder.loadImage("bap.png"));
        }
        return this.wizardHeader;
    }

    private JList getListSelect() {
        if (this.listSelect == null) {
            this.listModel = new DefaultListModel();
            this.listSelect = new JList();
            this.listSelect.setFont(new Font("Tahoma", 0, 11));
            this.listSelect.setCellRenderer(new CellRenderer());
            this.listSelect.setSelectionMode(0);
            this.listSelect.setModel(this.listModel);
            this.listSelect.addListSelectionListener(this);
        }
        return this.listSelect;
    }

    private JScrollPane getPaneSelect() {
        if (this.paneSelect == null) {
            this.paneSelect = new JScrollPane();
            this.paneSelect.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.72"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.paneSelect.setBackground(this.getBackground());
            this.paneSelect.setViewportView(this.getListSelect());
        }
        return this.paneSelect;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints constraintsMenu = new GridBagConstraints();
            constraintsMenu.gridx = 0;
            constraintsMenu.gridy = 1;
            constraintsMenu.fill = 2;
            GridBagConstraints constraintsJSplitPane = new GridBagConstraints();
            constraintsJSplitPane.fill = 1;
            constraintsJSplitPane.gridy = 2;
            constraintsJSplitPane.weightx = 1.0;
            constraintsJSplitPane.weighty = 1.0;
            constraintsJSplitPane.gridx = 0;
            GridBagConstraints constraintsButtonPanel = new GridBagConstraints();
            constraintsButtonPanel.gridx = 0;
            constraintsButtonPanel.fill = 2;
            constraintsButtonPanel.gridy = 3;
            GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
            constraintsWizardHeader.gridx = 0;
            constraintsWizardHeader.gridy = 0;
            constraintsWizardHeader.fill = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), constraintsWizardHeader);
            this.jContentPane.add((Component)this.getJSplitPane(), constraintsJSplitPane);
            this.jContentPane.add((Component)this.getButtonPanel(), constraintsButtonPanel);
        }
        return this.jContentPane;
    }

    public static String getHexString(byte[] bs) {
        StringBuffer ret = new StringBuffer(bs.length);
        int i = 0;
        while (i < bs.length) {
            String hex = Integer.toHexString(256 + (bs[i] & 0xFF)).substring(1);
            ret.append(String.valueOf(hex.length() < 2 ? "0" : "") + hex);
            ++i;
        }
        return ret.toString();
    }

    @Override
    public IBAPFinder.IMessage sendToConfigPort(IBAPFinder.IDevice device, int messageType, RandomArrayStream stream) {
        return Tools.sendToConfigPort(device, messageType, stream);
    }

    @Override
    public IBAPFinder.IMessage sendToConfigPort(IBAPFinder.IDevice device, int messageType, RandomArrayStream stream, boolean needAnswer, int timeout) {
        return Tools.sendToConfigPort(device, messageType, stream, needAnswer, timeout);
    }

    @Override
    public Locale getLanguage() {
        return new Locale("de");
    }

    public static BufferedImage loadImage(String name) {
        name = String.valueOf(imagePath) + name;
        BufferedImage image = null;
        try {
            String resourceName = name.replace(File.separatorChar, '/');
            image = ImageIO.read(new Object().getClass().getResourceAsStream("/" + resourceName));
        }
        catch (Exception e) {
            try {
                image = ImageIO.read(new File(name));
            }
            catch (Exception exception) {
                System.err.println("BAPFinder.loadImage() --> Error while loading image: " + e.getMessage());
                return null;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDevice(String mac) {
        Object[] devices;
        DefaultListModel defaultListModel = this.listModel;
        synchronized (defaultListModel) {
            devices = this.listModel.toArray();
        }
        IBAPFinder.IDevice selectedDevice = null;
        Object[] objectArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IBAPFinder.IDevice device = (IBAPFinder.IDevice)object;
            if (device.getMac().equals(mac)) {
                selectedDevice = device;
                break;
            }
            ++n2;
        }
        if (selectedDevice != null) {
            DefaultListModel defaultListModel2 = this.listModel;
            synchronized (defaultListModel2) {
                this.listModel.removeElement(selectedDevice);
            }
            this.selectedDevice = null;
        }
    }

    @Override
    public void addBAPListener(IBAPFinder.IDeviceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeBAPListener(IBAPFinder.IDeviceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Frame getWindow() {
        return this;
    }

    @Override
    public IBAPFinder.IDevice getSelectedDevice() {
        return this.selectedDevice;
    }

    @Override
    public void addToContextMenu(JMenuItem menuItem) {
    }

    @Override
    public PluginVersion getAPIVersion() {
        return apiVersion;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane(3);
            this.tabbedPane.setFont(new Font("Tahoma", 0, 11));
            this.tabbedPane.setBorder(new TitledBorder(new EtchedBorder(1, null, null), Messages.getString("BAPFinder.92"), 4, 2, new Font("Tahoma", 0, 11), null));
        }
        return this.tabbedPane;
    }

    @Override
    public void addComponent(Component component) {
        if (component != null) {
            int index;
            component.addPropertyChangeListener(this);
            this.tabbedPane.addTab(component.getName(), component);
            if (component.isEnabled()) {
                this.tabbedPane.setSelectedComponent(component);
            }
            if ((index = this.tabbedPane.indexOfComponent(component)) != -1) {
                this.tabbedPane.setEnabledAt(index, component.isEnabled());
            }
        }
    }

    @Override
    public IBAPFinder.IMessage broadcastToConfigPort(IBAPFinder.IDevice device, int messageType, RandomArrayStream stream) {
        if (device.isUdp()) {
            return Tools.broadcastToConfigPort(device, messageType, stream);
        }
        return new Message(3, 0, null);
    }

    @Override
    public Plugin getPlugin(String name, PluginVersion version) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getName().equals(name) || plugin.getVersion().getVersion() < version.getVersion()) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object object = evt.getSource();
        if (!(object instanceof Component)) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (!propertyName.equals("enabled")) {
            return;
        }
        Component component = (Component)object;
        int index = this.tabbedPane.indexOfComponent(component);
        if (index == -1) {
            return;
        }
        object = evt.getNewValue();
        if (!(object instanceof Boolean)) {
            return;
        }
        Boolean value = (Boolean)object;
        this.tabbedPane.setEnabledAt(index, value);
        if (!value.booleanValue() && this.tabbedPane.getSelectedIndex() == index) {
            this.tabbedPane.setSelectedIndex(-1);
        }
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BufferedImage image = null;
            if (value instanceof IBAPFinder.IBAP) {
                image = imageBAP;
                IBAPFinder.IBAP bap = (IBAPFinder.IBAP)value;
                String version = bap.getVersion() == 0L ? Messages.getString("BAPFinder.25") : String.valueOf(bap.getVersion());
                version = String.valueOf(version) + " - ";
                int count = 0;
                if (bap.hasFeature(1L)) {
                    version = String.valueOf(version) + "<font color=\"#FF0000\">HS</font>";
                    ++count;
                }
                if (bap.hasFeature(2L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = bap.hasFeature(16L) ? String.valueOf(version) + "<font color=\"#00A000\">SA-E</font>" : String.valueOf(version) + "<font color=\"#00A000\">SA</font>";
                    ++count;
                }
                if (bap.hasFeature(64L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#0000A0\">E3</font>";
                    ++count;
                }
                if (bap.hasFeature(512L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#FF8A00\">D</font>";
                    ++count;
                }
                if (bap.hasFeature(4096L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#3A35A2\">C</font>";
                    ++count;
                }
                if (bap.hasFeature(8192L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#EC13C1\">B</font>";
                    ++count;
                }
                value = bap.hasFeature(16384L) ? String.valueOf("<html>" + (bap.isUdp() ? "" : "<STRIKE>") + Messages.getString("BAPFinder.0") + " " + bap.getId() + "<br>" + Messages.getString("BAPFinder.122") + " " + bap.getMac() + "<br>" + Messages.getString("BAPFinder.125") + " " + version + (bap.isUdp() ? "" : "</STRIKE>") + "</html>") : String.valueOf("<html>" + (bap.isUdp() ? "" : "<STRIKE>") + Messages.getString("BAPFinder.129") + " " + bap.getId() + "<br>" + Messages.getString("BAPFinder.122") + " " + bap.getMac() + "<br>" + Messages.getString("BAPFinder.125") + " " + version + (bap.isUdp() ? "" : "</STRIKE>") + "</html>");
            } else if (value instanceof IBAPFinder.IBoSeServer) {
                String id;
                long tmpID;
                String mac;
                long tmpMAC;
                image = imageBoSe;
                IBAPFinder.IBoSeServer boSeServer = (IBAPFinder.IBoSeServer)value;
                String version = boSeServer.getVersion() == 0L ? Messages.getString("BAPFinder.25") : boSeServer.getVersionString();
                version = String.valueOf(version) + " - ";
                int count = 0;
                if (boSeServer.hasFeature(4096L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#3A35A2\">C</font>";
                    ++count;
                }
                if ((tmpMAC = Long.parseLong((mac = boSeServer.getMac()).replace(":", ""), 16)) == (tmpID = boSeServer.getId())) {
                    id = Tools.toHexString(tmpID, true, ":");
                    int length = mac.length();
                    id = id.substring(id.length() - length);
                } else {
                    id = String.valueOf(tmpID);
                }
                value = String.valueOf("<html>" + (boSeServer.isUdp() ? "" : "<STRIKE>") + "IMEI " + id + "<br>" + Messages.getString("BAPFinder.122") + " " + boSeServer.getMac() + "<br>" + Messages.getString("BAPFinder.125") + " " + version + (boSeServer.isUdp() ? "" : "</STRIKE>") + "</html>");
            }
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (component instanceof JLabel) {
                if (image != null) {
                    // empty if block
                }
                ((JLabel)component).setIcon(new ImageIcon(image));
                ((JLabel)component).setBorder(BorderFactory.createEtchedBorder(1));
            }
            return component;
        }
    }
}

