/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.Device;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.localization.Messages;
import de.bsc.bapfinder.tools.Tools;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BAP
extends Device
implements IBAPFinder.IBAP {
    private boolean dhcp = false;
    private boolean ipv6 = false;
    private String serverIP = null;

    private BAP() {
    }

    public BAP(byte[] data, int port) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int messageType = dataInputStream.readInt();
        if (messageType != 1) {
            throw new Exception("No answer to configuration request received");
        }
        this.setIpv6(dataInputStream.readBoolean());
        this.setDhcp(dataInputStream.readBoolean());
        this.setServerIP(Tools.readString(dataInputStream));
        this.setIp(Tools.readString(dataInputStream));
        this.setPort(port);
        this.setSubnetmask(Tools.readString(dataInputStream));
        this.setGateway(Tools.readString(dataInputStream));
        this.setHostname(Tools.readString(dataInputStream));
        this.setMac(Tools.readString(dataInputStream));
        this.setId(dataInputStream.readLong());
        this.setFeatures(dataInputStream.readLong());
        this.setVersion(dataInputStream.readLong());
        if (this.hasFeature(4096L)) {
            this.setCommands(dataInputStream.readLong());
        }
        this.setUdp(true);
        this.setOnline(true);
        this.setLastMessageTime(System.currentTimeMillis());
    }

    public BAP(String string, String ip) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.indexOf("#") == -1) {
            this.setId(Long.parseLong(stringBuffer.toString()));
            this.setMac(Messages.getString("BAPFinder.25"));
            this.setVersion(0L);
        } else {
            int breakpoints = 0;
            int i = 0;
            while (i < stringBuffer.length()) {
                if (stringBuffer.charAt(i) == '#') {
                    ++breakpoints;
                }
                ++i;
            }
            this.setId(Long.parseLong(stringBuffer.substring(0, stringBuffer.indexOf("#"))));
            stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
            switch (breakpoints) {
                case 1: {
                    this.setMac(stringBuffer.toString());
                    this.setVersion(0L);
                    break;
                }
                case 2: {
                    this.setMac(stringBuffer.substring(0, stringBuffer.indexOf("#")));
                    stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
                    long version = Long.parseLong(stringBuffer.toString());
                    if (version > 30000000L) {
                        this.setVersion(version - 10000000L);
                        this.setFeatures(this.getFeatures() | 1L | 4L);
                    } else {
                        this.setVersion(version);
                    }
                    if (this.getVersion() < 20080702L) break;
                    this.setFeatures(this.getFeatures() | 8L);
                }
            }
        }
        this.setIp(ip);
        this.setUdp(false);
        this.setOnline(true);
        this.setLastMessageTime(System.currentTimeMillis());
    }

    @Override
    public boolean isDhcp() {
        return this.dhcp;
    }

    @Override
    public void setDhcp(boolean dhcp) {
        boolean old = this.dhcp;
        if (old != dhcp) {
            this.dhcp = dhcp;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "dhcp", old, dhcp);
            this.firePropertyChange(event);
        }
    }

    @Override
    public boolean isIpv6() {
        return this.ipv6;
    }

    @Override
    public void setIpv6(boolean ipv6) {
        boolean old = this.ipv6;
        if (old != ipv6) {
            this.ipv6 = ipv6;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "ipv6", old, ipv6);
            this.firePropertyChange(event);
        }
    }

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String serverIP) {
        String old;
        String string = old = this.serverIP == null ? "" : this.serverIP;
        if (!old.equals(serverIP)) {
            this.serverIP = serverIP;
            PropertyChangeEvent event = new PropertyChangeEvent(this, "serverIP", old, serverIP);
            this.firePropertyChange(event);
        }
    }

    @Override
    protected void update(Device device) {
        if (!(device instanceof BAP)) {
            return;
        }
        BAP bap = (BAP)device;
        this.setDhcp(bap.isDhcp());
        this.setIpv6(bap.isIpv6());
        this.setServerIP(bap.getServerIP());
    }

    @Override
    public BAP clone() {
        BAP bap = new BAP();
        bap.dhcp = this.dhcp;
        bap.ipv6 = this.ipv6;
        bap.ip = this.ip;
        bap.port = this.port;
        bap.serverIP = this.serverIP;
        bap.subnetmask = this.subnetmask;
        bap.gateway = this.gateway;
        bap.hostname = this.hostname;
        bap.id = this.id;
        bap.mac = this.mac;
        bap.version = this.version;
        bap.features = this.features;
        bap.commands = this.commands;
        bap.udp = this.udp;
        return bap;
    }
}

