/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ImageLoader {
    private static HashMap<String, BufferedImage> imageMap;
    private static boolean useHashMap;

    static {
        useHashMap = true;
        imageMap = new HashMap();
        imageMap.put("null", ImageLoader.getNullImage());
    }

    public static BufferedImage loadImage(String fname) {
        if (fname == null) {
            return null;
        }
        BufferedImage ret = null;
        try {
            ret = ImageIO.read(new File(fname));
        }
        catch (Exception exception) {
            ret = imageMap.get("null");
        }
        return ret;
    }

    public static BufferedImage loadImage(String fname, int width, int height, boolean keepAspectRatio) {
        if (fname == null) {
            return null;
        }
        BufferedImage image = ImageLoader.loadImage(fname);
        return ImageLoader.resizeImage(image, width, height, keepAspectRatio);
    }

    public static BufferedImage loadImageResource(String fname) {
        if (fname == null) {
            return null;
        }
        if (!useHashMap) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(ImageLoader.getResourceStream("Bilder", fname));
            }
            catch (Exception exception) {
                return imageMap.get("null");
            }
            return image;
        }
        return ImageLoader.getImageResourceFromVector(fname);
    }

    public static Image loadImageResource(String fname, int width, int height, boolean keepAspectRatio) {
        if (fname == null) {
            return null;
        }
        BufferedImage image = ImageLoader.loadImageResource(fname);
        return ImageLoader.resizeImage(image, width, height, keepAspectRatio);
    }

    private static BufferedImage getImageResourceFromVector(String fname) {
        if (fname == null) {
            return null;
        }
        BufferedImage ret = imageMap.get(fname);
        if (ret == null) {
            try {
                ret = ImageIO.read(ImageLoader.getResourceStream("Bilder", fname));
            }
            catch (Exception e) {
                e.printStackTrace();
                return imageMap.get("null");
            }
        } else {
            return ret;
        }
        imageMap.put(fname, ret);
        return ret;
    }

    public static BufferedImage resizeImage(BufferedImage image, int width, int height, boolean keepAspectRatio) {
        double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
        double newAspectRatio = (double)width / (double)height;
        if (keepAspectRatio) {
            if (newAspectRatio < aspectRatio) {
                height = (int)((double)width / aspectRatio);
            } else {
                width = (int)((double)height * aspectRatio);
            }
        }
        BufferedImage imageResized = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = imageResized.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return imageResized;
    }

    private static InputStream getResourceStream(String pkname, String fname) {
        String resname = "/" + pkname + "/" + fname;
        return ImageLoader.class.getResourceAsStream(resname);
    }

    public static BufferedImage getNullImage() {
        BufferedImage ret = null;
        try {
            ret = ImageIO.read(ImageLoader.getResourceStream("Bilder", "picnotfound.png"));
        }
        catch (Exception exception) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics g = image.getGraphics();
            g.setColor(Color.BLACK);
            g.setFont(new Font("Tahoma", 0, 11));
            g.drawString("NF", 1, 16);
            g.dispose();
            return image;
        }
        return ret;
    }

    public static boolean isUseHashMap() {
        return useHashMap;
    }

    public static void setUseHashMap(boolean useVector) {
        useHashMap = useVector;
    }
}

