/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public class DBConversion {
    public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
    protected short m_dbNCharSet;
    protected short m_dbCharSet;
    protected short m_charSet;
    private CharacterSet m_databaseCs;
    private CharacterSet m_databaseNCs;
    private CharacterSet m_accessCs;
    private CharacterSet m_asciiCs;
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short AL16UTF16_CHARSET = 2000;

    public DBConversion(short s, short s2, short s3) throws SQLException {
        switch (s2) {
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: 
            case 873: {
                break;
            }
            default: {
                DBConversion.unexpectedCharset(s2);
            }
        }
        this.m_dbCharSet = s;
        this.m_charSet = s2;
        this.m_databaseCs = CharacterSet.make(this.m_dbCharSet);
        this.m_dbNCharSet = s3;
        this.m_databaseNCs = CharacterSet.make(this.m_dbNCharSet);
        this.m_accessCs = s2 == -1 ? this.m_databaseCs : CharacterSet.make(this.m_charSet);
    }

    public short getDbCharSet() {
        return this.m_dbCharSet;
    }

    public short getNCharSet() {
        return this.m_dbNCharSet;
    }

    public boolean IsNCharFixedWith() {
        return this.m_dbNCharSet == 2000;
    }

    public short getAccessCharSet() {
        if (this.m_charSet == -1) {
            return this.m_dbCharSet;
        }
        return this.m_charSet;
    }

    public CharacterSet getDbCharSetObj() {
        return this.m_databaseCs;
    }

    public CharacterSet getAccessCharSetObj() {
        return this.m_accessCs;
    }

    public CharacterSet getAccessNCharSetObj() {
        return this.m_databaseNCs;
    }

    public static boolean isAccessCharSetSupported(short s) {
        boolean bl = false;
        switch (s) {
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static byte[] stringToAccessCharBytes(String string, short s) throws SQLException {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        switch (s) {
            case -5: {
                byArray = DBConversion.stringToUcs2Bytes(string);
                break;
            }
            case 1: 
            case 31: {
                byArray = DBConversion.stringToAsciiBytes(string);
                break;
            }
            case 870: 
            case 871: {
                byArray = DBConversion.stringToUtf8Bytes(string);
                break;
            }
            case 2000: {
                byArray = DBConversion.stringToUcs2Bytes(string);
                break;
            }
            case 873: {
                byArray = DBConversion.stringToAL32UTF8Bytes(string);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(s);
            }
        }
        return byArray;
    }

    public byte[] StringToCharBytes(String string) throws SQLException {
        if (this.m_charSet == -1) {
            return this.m_databaseCs.convertWithReplacement(string);
        }
        return DBConversion.stringToAccessCharBytes(string, this.m_charSet);
    }

    public byte[] StringToNCharBytes(String string) throws SQLException {
        if (this.m_charSet == -1) {
            return this.m_databaseNCs.convertWithReplacement(string);
        }
        return DBConversion.stringToAccessCharBytes(string, this.m_dbNCharSet);
    }

    public String CharBytesToString(byte[] byArray, int n) throws SQLException {
        String string = null;
        switch (this.m_charSet) {
            case -5: {
                string = DBConversion.ucs2BytesToString(byArray, n);
                break;
            }
            case 1: 
            case 31: {
                string = new String(byArray, 0, 0, n);
                break;
            }
            case 870: 
            case 871: {
                string = DBConversion.utf8BytesToString(byArray, n);
                break;
            }
            case 873: {
                string = DBConversion.al32utf8BytesToString(byArray, n);
                break;
            }
            case -1: {
                string = this.m_databaseCs.toStringWithReplacement(byArray, 0, n);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        return string;
    }

    public String NCharBytesToString(byte[] byArray, int n) throws SQLException {
        String string = null;
        if (this.m_charSet == -1) {
            string = this.m_databaseNCs.toStringWithReplacement(byArray, 0, n);
        } else {
            switch (this.m_dbNCharSet) {
                case -5: {
                    string = DBConversion.ucs2BytesToString(byArray, n);
                    break;
                }
                case 1: 
                case 31: {
                    string = new String(byArray, 0, 0, n);
                    break;
                }
                case 870: 
                case 871: {
                    string = DBConversion.utf8BytesToString(byArray, n);
                    break;
                }
                case 2000: {
                    string = DBConversion.ucs2BytesToString(byArray, n);
                    break;
                }
                case 873: {
                    string = DBConversion.al32utf8BytesToString(byArray, n);
                    break;
                }
                case -1: {
                    string = this.m_databaseCs.toStringWithReplacement(byArray, 0, n);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.m_charSet);
                }
            }
        }
        return string;
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, this.m_charSet);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.javaCharsToCHARBytes(cArray, n, byArray, this.m_dbNCharSet);
    }

    private int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray, short s) throws SQLException {
        int n2 = 0;
        switch (s) {
            case -5: {
                n2 = DBConversion.javaCharsToUcs2Bytes(cArray, n, byArray);
                break;
            }
            case 1: 
            case 31: {
                n2 = DBConversion.javaCharsToAsciiBytes(cArray, n, byArray);
                break;
            }
            case 870: 
            case 871: {
                n2 = DBConversion.javaCharsToUtf8Bytes(cArray, n, byArray);
                break;
            }
            case 2000: {
                n2 = DBConversion.javaCharsToUcs2Bytes(cArray, n, byArray);
                break;
            }
            case 873: {
                n2 = DBConversion.javaCharsToAL32UTF8Bytes(cArray, 0, n, byArray, 0);
                break;
            }
            case -1: {
                n2 = this.javaCharsToDbCsBytes(cArray, n, byArray);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        return n2;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.charBytesToJavaChars(byArray, n, cArray, this.m_charSet);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        return this.charBytesToJavaChars(byArray, n, cArray, this.m_dbNCharSet);
    }

    public int charBytesToJavaChars(byte[] byArray, int n, char[] cArray, int n2) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case -5: {
                n3 = DBConversion.ucs2BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 1: 
            case 31: {
                n3 = DBConversion.asciiBytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 870: 
            case 871: {
                n3 = DBConversion.utf8BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 2000: {
                n3 = DBConversion.ucs2BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case 873: {
                n3 = DBConversion.al32utf8BytesToJavaChars(byArray, n, cArray);
                break;
            }
            case -1: {
                n3 = this.dbCsBytesToJavaChars(byArray, n, cArray);
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        return n3;
    }

    public int CHARBytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        return this._CHARBytesToJavaChars(byArray, nArray, cArray, this.m_charSet);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        return this._CHARBytesToJavaChars(byArray, nArray, cArray, this.m_dbNCharSet);
    }

    public int _CHARBytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray, short s) throws SQLException {
        int n = 0;
        switch (s) {
            case -5: {
                n = DBConversion.ucs2BytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = nArray[0] % 2;
                break;
            }
            case 1: 
            case 31: {
                n = DBConversion.asciiBytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = 0;
                break;
            }
            case 870: 
            case 871: {
                n = DBConversion.utf8BytesToJavaChars(byArray, nArray, cArray);
                break;
            }
            case 873: {
                n = DBConversion.al32utf8BytesToJavaChars(byArray, nArray, cArray);
                break;
            }
            case -1: {
                n = this.dbCsBytesToJavaChars(byArray, nArray[0], cArray);
                nArray[0] = 0;
                break;
            }
            default: {
                DBConversion.unexpectedCharset(this.m_charSet);
            }
        }
        return n;
    }

    public byte[] asciiBytesToCHARBytes(byte[] byArray) {
        byte[] byArray2 = null;
        switch (this.m_charSet) {
            case -5: {
                byArray2 = new byte[byArray.length * 2];
                int n = 0;
                int n2 = 0;
                while (n < byArray.length) {
                    byArray2[n2++] = 0;
                    byArray2[n2++] = byArray[n];
                    ++n;
                }
                break;
            }
            case -1: {
                if (this.m_asciiCs == null) {
                    this.m_asciiCs = CharacterSet.make(1);
                }
                try {
                    byArray2 = this.m_databaseCs.convert(this.m_asciiCs, byArray, 0, byArray.length);
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                byArray2 = byArray;
            }
        }
        return byArray2;
    }

    public int javaCharsToDbCsBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        DBConversion.catchCharsLen(cArray, n);
        String string = new String(cArray, 0, n);
        byte[] byArray2 = this.m_databaseCs.convertWithReplacement(string);
        string = null;
        if (byArray2 != null) {
            n2 = byArray2.length;
            DBConversion.catchBytesLen(byArray, n2);
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = byArray2[n3];
                ++n3;
            }
            byArray2 = null;
        }
        return n2;
    }

    public int dbCsBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int n2 = 0;
        DBConversion.catchBytesLen(byArray, n);
        String string = this.m_databaseCs.toStringWithReplacement(byArray, 0, n);
        if (string != null) {
            n2 = string.length();
            DBConversion.catchCharsLen(cArray, n2);
            string.getChars(0, n2, cArray, 0);
            string = null;
        }
        return n2;
    }

    public static byte[] stringToUcs2Bytes(String string) throws SQLException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[2 * n];
        DBConversion.javaCharsToUcs2Bytes(cArray, n, byArray);
        return byArray;
    }

    public static String ucs2BytesToString(byte[] byArray, int n) throws SQLException {
        char[] cArray = new char[n / 2];
        DBConversion.ucs2BytesToJavaChars(byArray, n, cArray);
        return new String(cArray);
    }

    public static int javaCharsToUcs2Bytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        DBConversion.catchCharsLen(cArray, n);
        DBConversion.catchBytesLen(byArray, n * 2);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3++] = (byte)(cArray[n2] >> 8 & 0xFF);
            byArray[n3++] = (byte)(cArray[n2] & 0xFF);
            ++n2;
        }
        return n3;
    }

    public static char ucs2BytesToChar(byte[] byArray, int n) {
        return (char)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static int ucs2BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3;
        int n6 = n2;
        int n7 = n2 + n4;
        while (n6 + 1 < n7) {
            int n8 = byArray[n6] << 8;
            int n9 = n8 | byArray[n6 + 1] & 0xFF;
            if (DBConversion.isHiSurrogate((char)n9)) {
                if ((n6 += 2) + 1 < n7) {
                    char c = (char)((byArray[n6] << 8) + (byArray[n6 + 1] & 0xFF));
                    cArray[n5++] = DBConversion.isLoSurrogate(c) ? n9 : 65533;
                    cArray[n5++] = c;
                } else {
                    cArray[n5++] = 65533;
                }
            } else {
                cArray[n5++] = n9;
            }
            n6 += 2;
        }
        n6 = n5 - n3;
        return n6;
    }

    public static byte[] stringToAsciiBytes(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        return byArray;
    }

    public static int javaCharsToAsciiBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        DBConversion.catchCharsLen(cArray, n);
        DBConversion.catchBytesLen(byArray, n);
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return n;
    }

    public static int asciiBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        DBConversion.catchBytesLen(byArray, n);
        DBConversion.catchCharsLen(cArray, n);
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = DBConversion.byteToChar(byArray[n2]);
            ++n2;
        }
        return n;
    }

    private static char byteToChar(byte by) {
        return (char)(0xFF & by);
    }

    private static byte[] stringToUtf8Bytes(String string) throws SQLException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return DBConversion.javaCharsToUtf8Bytes(cArray);
    }

    private static int javaCharsToUtf8Bytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        DBConversion.catchCharsLen(cArray, n);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if ((c & 0xFF80) == 0) {
                if (n4 >= n2) break;
                byArray[n4++] = (byte)c;
            } else if ((c & 0xF800) == 0) {
                if (n4 + 1 >= n2) break;
                byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            } else {
                if (n4 + 2 >= n2) break;
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            ++n3;
        }
        if (n3 < n) {
            DBError.check_error(39, "javaCharsToUtf8Bytes");
        }
        return n4;
    }

    private static byte[] javaCharsToUtf8Bytes(char[] cArray) {
        int n = cArray.length;
        int n2 = DBConversion.stringUTF8Length(cArray);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if ((c & 0xFF80) == 0) {
                byArray[n4++] = (byte)c;
            } else if ((c & 0xF800) == 0) {
                byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            ++n3;
        }
        return byArray;
    }

    private static String utf8BytesToString(byte[] byArray, int n) throws SQLException {
        char[] cArray = new char[n];
        int n2 = DBConversion.utf8BytesToJavaChars(byArray, n, cArray);
        return new String(cArray, 0, n2);
    }

    public static int utf8BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[]{n};
        return DBConversion.utf8BytesToJavaChars(byArray, nArray, cArray);
    }

    private static int utf8BytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int[] nArray2 = nArray;
        int n4 = nArray2[0];
        nArray2[0] = 0;
        int n5 = n2;
        int n6 = n2 + n4;
        int n7 = n3;
        int n8 = cArray.length;
        block5: while (n5 < n6) {
            byte by = byArray[n5++];
            n = by & 0xF0;
            switch (n / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n7 < n8) {
                        cArray[n7++] = (char)(by & 0xFFFFFFFF);
                        break;
                    }
                    nArray2[0] = n6 - n5 + 2;
                    break block5;
                }
                case 12: 
                case 13: {
                    if (n5 >= n6) {
                        nArray2[0] = 1;
                        break block5;
                    }
                    char c = DBConversion.conv2ByteUTFtoUTF16(by, byArray[n5++]);
                    if (n7 < n8) {
                        cArray[n7++] = c;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 3;
                    break block5;
                }
                case 14: {
                    int n9;
                    char c;
                    if (n5 + 1 >= n6) {
                        nArray2[0] = n6 - n5 + 1;
                        break block5;
                    }
                    if (DBConversion.isHiSurrogate((char)(n9 = DBConversion.conv3ByteUTFtoUTF16(by, byArray[n5++], byArray[n5++])))) {
                        if (n7 > n8 - 2) {
                            nArray2[0] = n6 - n5 + 4;
                            break block5;
                        }
                        if (n5 >= n6) continue block5;
                        by = byArray[n5];
                        if ((byte)(by & 0xF0) != -32) {
                            cArray[n7++] = 65533;
                            break;
                        }
                        if (++n5 + 1 >= n6) {
                            nArray2[0] = n6 - n5 + 1;
                            break block5;
                        }
                        cArray[n7++] = DBConversion.isLoSurrogate(c = DBConversion.conv3ByteUTFtoUTF16(by, byArray[n5++], byArray[n5++])) ? n9 : 65533;
                        cArray[n7++] = c;
                        break;
                    }
                    if (n7 < n8) {
                        cArray[n7++] = n9;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 4;
                    break block5;
                }
                default: {
                    if (n7 < n8) {
                        cArray[n7++] = 65533;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 2;
                    break block5;
                }
            }
        }
        n = n7 - n3;
        return n;
    }

    private static int stringUTF8Length(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            n = c >= '\u0000' && c <= '\u007f' ? ++n : (c >= '\u0080' && c <= '\u07ff' ? (n += 2) : (n += 3));
            ++n3;
        }
        return n;
    }

    private static void failUTF8Conv() throws SQLException {
        DBError.check_error(37, "failUTF8Conv");
    }

    private static int stringAL32Length(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            if (c >= '\u0000' && c <= '\u007f') {
                ++n;
            } else if (c >= '\u0080' && c <= '\u07ff') {
                n += 2;
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c2;
                if (++n3 < n2 && (c2 = cArray[n3]) >= '\udc00' && c2 <= '\udfff') {
                    n += 4;
                }
            } else if (c < '\udc00' || c > '\udfff') {
                n += 3;
            }
            ++n3;
        }
        return n;
    }

    public static int al32utf8BytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[]{n};
        int n2 = DBConversion.al32utf8BytesToJavaChars(byArray, nArray, cArray);
        if (nArray[0] > 0) {
            DBConversion.failAL32UTF8Conv();
        }
        return n2;
    }

    private static int al32utf8BytesToJavaChars(byte[] byArray, int[] nArray, char[] cArray) throws SQLException {
        int n;
        int[] nArray2 = nArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray2[0];
        nArray2[0] = 0;
        int n5 = n2;
        int n6 = n2 + n4;
        int n7 = n3;
        int n8 = cArray.length;
        block6: while (n5 < n6) {
            byte by = byArray[n5++];
            int n9 = by & 0xF0;
            switch (n9 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n7 < n8) {
                        cArray[n7++] = (char)(by & 0xFFFFFFFF);
                        break;
                    }
                    nArray2[0] = n6 - n5 + 2;
                    break block6;
                }
                case 12: 
                case 13: {
                    if (n5 >= n6) {
                        nArray2[0] = 1;
                        break block6;
                    }
                    char c = DBConversion.conv2ByteUTFtoUTF16(by, byArray[n5++]);
                    if (n7 < n8) {
                        cArray[n7++] = c;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 3;
                    break block6;
                }
                case 14: {
                    if (n5 + 1 >= n6) {
                        nArray2[0] = n6 - n5 + 1;
                        break block6;
                    }
                    char c = DBConversion.conv3ByteAL32UTF8toUTF16(by, byArray[n5++], byArray[n5++]);
                    if (n7 < n8) {
                        cArray[n7++] = c;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 4;
                    break block6;
                }
                case 15: {
                    if (n5 + 2 >= n6) {
                        nArray2[0] = n6 - n5 + 1;
                        break block6;
                    }
                    if (n7 > n8 - 2) {
                        nArray2[0] = n6 - n5 + 2;
                        break block6;
                    }
                    if ((n = DBConversion.conv4ByteAL32UTF8toUTF16(by, byArray[n5++], byArray[n5++], byArray[n5++], cArray, n7)) == 1) {
                        ++n7;
                        break;
                    }
                    n7 += 2;
                    break;
                }
                default: {
                    if (n7 < n8) {
                        cArray[n7++] = 65533;
                        break;
                    }
                    nArray2[0] = n6 - n5 + 2;
                    break block6;
                }
            }
        }
        n = n7 - n3;
        return n;
    }

    private static String al32utf8BytesToString(byte[] byArray, int n) throws SQLException {
        char[] cArray = new char[n];
        int n2 = DBConversion.al32utf8BytesToJavaChars(byArray, n, cArray);
        return new String(cArray, 0, n2);
    }

    private static byte[] stringToAL32UTF8Bytes(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[4 * n];
        int n2 = 0;
        try {
            n2 = DBConversion.javaCharsToAL32UTF8Bytes(cArray, 0, n, byArray, 0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private static int javaCharsToAL32UTF8Bytes(char[] cArray, int n, int n2, byte[] byArray, int n3) throws SQLException {
        int n4 = n;
        int n5 = n + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > cArray.length) {
            n5 = cArray.length;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= byArray.length) {
            DBConversion.failAL32UTF8Conv();
        }
        int n6 = n3;
        int n7 = n4;
        while (n7 < n5) {
            char c = cArray[n7];
            if (c >= '\u0000' && c <= '\u007f') {
                byArray[n6++] = (byte)c;
                if (n6 >= byArray.length) {
                    DBConversion.failAL32UTF8Conv();
                }
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c2;
                if (n7 + 1 < n5 && (c2 = cArray[n7 + 1]) >= '\udc00' & c2 <= '\udfff') {
                    int n8 = (c >> 6 & 0xF) + 1;
                    if (n6 + 3 >= byArray.length) {
                        DBConversion.failAL32UTF8Conv();
                    }
                    byArray[n6++] = (byte)(n8 >> 2 & 2 | 0xF0);
                    byArray[n6++] = (byte)((n8 & 3) << 4 | c >> 2 & 0xF | 0x80);
                    byArray[n6++] = (byte)((c & 3) << 4 | c2 >> 6 & 0xF | 0x80);
                    byArray[n6++] = (byte)(c2 & 0x3F | 0x80);
                    ++n7;
                }
            } else if (c > '\u07ff') {
                if (n6 + 2 >= byArray.length) {
                    DBConversion.failAL32UTF8Conv();
                }
                byArray[n6++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n6++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                if (n6 + 1 >= byArray.length) {
                    DBConversion.failAL32UTF8Conv();
                }
                byArray[n6++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n7;
        }
        return n6;
    }

    private static void failAL32UTF8Conv() throws SQLException {
        DBError.check_error(55, "failAL32UTF8Conv");
    }

    public static byte[] BigDecimalToNumberBytes(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        return NUMBER.toBytes(bigDecimal);
    }

    public static BigDecimal NumberBytesToBigDecimal(byte[] byArray, int n) throws SQLException {
        return NUMBER.toBigDecimal(byArray);
    }

    public static byte NumberBytesToByte(byte[] byArray, int n) throws SQLException {
        return NUMBER.toByte(byArray);
    }

    public static byte[] ByteToNumberBytes(byte by) {
        return NUMBER.toBytes(by);
    }

    public static short NumberBytesToShort(byte[] byArray, int n) throws SQLException {
        return NUMBER.toShort(byArray);
    }

    public static byte[] ShortToNumberBytes(short s) {
        return NUMBER.toBytes(s);
    }

    public static int NumberBytesToInt(byte[] byArray, int n) throws SQLException {
        return NUMBER.toInt(byArray);
    }

    public static byte[] IntToNumberBytes(int n) {
        return NUMBER.toBytes(n);
    }

    public static long NumberBytesToLong(byte[] byArray, int n) throws SQLException {
        return NUMBER.toLong(byArray);
    }

    public static byte[] LongToNumberBytes(long l) {
        return NUMBER.toBytes(l);
    }

    public static float NumberBytesToFloat(byte[] byArray, int n) {
        return NUMBER.toFloat(byArray);
    }

    public static byte[] FloatToNumberBytes(float f) {
        return NUMBER.toBytes(f);
    }

    public static double NumberBytesToDouble(byte[] byArray, int n) {
        return NUMBER.toDouble(byArray);
    }

    public static byte[] DoubleToNumberBytes(double d) throws SQLException {
        return NUMBER.toBytes(d);
    }

    public static byte[] BooleanToNumberBytes(boolean bl) {
        return NUMBER.toBytes(bl);
    }

    public static boolean NumberBytesToBoolean(byte[] byArray, int n) throws SQLException {
        return NUMBER.toBoolean(byArray);
    }

    public Date DateBytesToDate(byte[] byArray, int n) {
        return DATE.toDate(byArray);
    }

    public byte[] DateToDateBytes(Date date) {
        return DATE.toBytes(date);
    }

    public Time DateBytesToTime(byte[] byArray, int n) {
        return DATE.toTime(byArray);
    }

    public byte[] TimeToDateBytes(Time time) {
        return DATE.toBytes(time);
    }

    public Timestamp DateBytesToTimestamp(byte[] byArray, int n) {
        return DATE.toTimestamp(byArray);
    }

    public byte[] TimestampToDateBytes(Timestamp timestamp) {
        return DATE.toBytes(timestamp);
    }

    public static boolean isCharSetMultibyte(short s) {
        switch (s) {
            case 1: 
            case 31: {
                return false;
            }
            case -5: 
            case -1: 
            case 870: 
            case 871: 
            case 873: {
                return true;
            }
        }
        return false;
    }

    public static int requestLength(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return n / 2;
            }
            case 5: {
                return n;
            }
            case 4: {
                return n * 2;
            }
            case 2: {
                return n / 2;
            }
            case 3: {
                return n / 4;
            }
        }
        return n;
    }

    public int getMaxCharbyteSize() {
        return this._getMaxCharbyteSize(this.m_charSet);
    }

    public int getMaxNCharbyteSize() {
        return this._getMaxCharbyteSize(this.m_dbNCharSet);
    }

    public int _getMaxCharbyteSize(short s) {
        switch (s) {
            case 1: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 870: 
            case 871: {
                return 3;
            }
            case -5: 
            case 2000: {
                return 2;
            }
            case -1: {
                return 4;
            }
            case 873: {
                return 4;
            }
        }
        return 1;
    }

    public boolean isUcs2CharSet() {
        return this.m_charSet == -5;
    }

    public static int RAWBytesToHexChars(byte[] byArray, int n, char[] cArray) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            cArray[n3++] = (char)RepConversion.nibbleToHex((byte)(byArray[n2] >> 4 & 0xF));
            cArray[n3++] = (char)RepConversion.nibbleToHex((byte)(byArray[n2] & 0xF));
            ++n2;
        }
        return n3;
    }

    public InputStream ConvertStream(InputStream inputStream, int n) {
        return new OracleConversionInputStream(this, inputStream, n);
    }

    public InputStream ConvertStream(InputStream inputStream, int n, int n2) {
        return new OracleConversionInputStream(this, inputStream, n, n2);
    }

    public InputStream ConvertStream(Reader reader, int n, int n2) {
        return new OracleConversionInputStream(this, reader, n, n2);
    }

    public InputStream ConvertStream(Reader reader, int n, int n2, short s) {
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this, reader, n, n2);
        oracleConversionInputStream.setFormOfUse(s);
        return oracleConversionInputStream;
    }

    public Reader ConvertCharacterStream(InputStream inputStream, int n) throws SQLException {
        return new OracleConversionReader(this, inputStream, n);
    }

    public Reader ConvertCharacterStream(InputStream inputStream, int n, short s) throws SQLException {
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this, inputStream, n);
        oracleConversionReader.setFormOfUse(s);
        return oracleConversionReader;
    }

    protected static void unexpectedCharset(short s) throws SQLException {
        DBError.check_error(35, "DBConversion");
    }

    protected static void catchBytesLen(byte[] byArray, int n) throws SQLException {
        if (n > byArray.length) {
            DBError.check_error(39, "catchBytesLen");
        }
    }

    protected static void catchCharsLen(char[] cArray, int n) throws SQLException {
        if (n > cArray.length) {
            DBError.check_error(39, "catchCharsLen");
        }
    }

    public static int getUtfLen(char c) {
        int n = 0;
        n = (c & 0xFF80) == 0 ? 1 : ((c & 0xF800) == 0 ? 2 : 3);
        return n;
    }

    static final boolean isHiSurrogate(char c) {
        return (char)(c & 0xFC00) == '\ud800';
    }

    static final boolean isLoSurrogate(char c) {
        return (char)(c & 0xFC00) == '\udc00';
    }

    static final boolean check80toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128;
    }

    static final boolean check80to8F(byte by) {
        return (by & 0xFFFFFFF0) == -128;
    }

    static final boolean check80to9F(byte by) {
        return (by & 0xFFFFFFE0) == -128;
    }

    static final boolean checkA0toBF(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    static final boolean check90toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128 && (by & 0x30) != 0;
    }

    static final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        if (by < -62 || by > -33 || !DBConversion.check80toBF(by2)) {
            return '\ufffd';
        }
        return (char)((by & 0x1F) << 6 | by2 & 0x3F);
    }

    static final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && DBConversion.checkA0toBF(by2) && DBConversion.check80toBF(by3) || by >= -31 && by <= -17 && DBConversion.check80toBF(by2) && DBConversion.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && DBConversion.checkA0toBF(by2) && DBConversion.check80toBF(by3) || by >= -31 && by <= -20 && DBConversion.check80toBF(by2) && DBConversion.check80toBF(by3) || by == -19 && DBConversion.check80to9F(by2) && DBConversion.check80toBF(by3) || by >= -18 && by <= -17 && DBConversion.check80toBF(by2) && DBConversion.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    static final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n) {
        boolean bl = false;
        if (!(by == -16 && DBConversion.check90toBF(by2) && DBConversion.check80toBF(by3) && DBConversion.check80toBF(by4) || by >= -15 && by <= -13 && DBConversion.check80toBF(by2) && DBConversion.check80toBF(by3) && DBConversion.check80toBF(by4) || by == -12 && DBConversion.check80to8F(by2) && DBConversion.check80toBF(by3) && DBConversion.check80toBF(by4))) {
            cArray[n] = 65533;
            return 1;
        }
        cArray[n] = (char)((((by & 7) << 2 | (by2 >>> 4 & 3) - 1) & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >>> 4 & 3 | 0xD800);
        cArray[n + 1] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
        return 2;
    }
}

