/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.tools.classloader;

import de.bsc.bapfinder.tools.classloader.JarResources;
import de.bsc.bapfinder.tools.classloader.MultiClassLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class JarClassLoader
extends MultiClassLoader {
    private JarResources jarResources;

    public JarClassLoader(String jarName) {
        this.jarResources = new JarResources(jarName);
    }

    public List<String> getClassNames() {
        return this.getClassNames("");
    }

    public List<String> getClassNames(String packageName) {
        String path = packageName.replace('.', '/');
        return this.jarResources.getClassNames(path);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] data = this.jarResources.getResource(name = name.replace('\\', '/'));
        return data == null ? null : new ByteArrayInputStream(data);
    }

    @Override
    protected byte[] loadClassBytes(String className) {
        className = String.valueOf(className.replace('.', '/')) + ".class";
        return this.jarResources.getResource(className);
    }
}

