/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.remote.VNCDialog;
import de.bsc.bapfinder.plugins.remote.localization.Messages;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.swing.JButton;

public class VNCPlugin
extends Plugin
implements ActionListener {
    private static final int vncPort = 5900;
    private JButton buttonVNC;
    IBAPFinder.IDevice device;

    @Override
    public void initialize(IBAPFinder api) throws PluginException {
        if (api == null) {
            throw new PluginException("ResetPlugin: API == null");
        }
        this.buttonVNC = new JButton();
        this.buttonVNC.setPreferredSize(new Dimension(100, 25));
        this.buttonVNC.setEnabled(false);
        this.buttonVNC.setFont(new Font("Tahoma", 0, 11));
        this.buttonVNC.setText(Messages.getString("VNC.0"));
        this.buttonVNC.setActionCommand("vnc");
        this.buttonVNC.addActionListener(this);
        api.addButton(this.buttonVNC);
    }

    public static boolean connectable(String ip, int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(ip, port), 10);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "VNC-Plugin";
    }

    @Override
    public void selectedDeviceChanged(IBAPFinder.IDevice device) {
        this.device = device;
        if (device == null || !device.isOnline() || !device.hasFeature(131072L)) {
            this.buttonVNC.setEnabled(false);
        } else {
            this.buttonVNC.setEnabled(VNCPlugin.connectable(device.getIp(), 5900));
        }
    }

    @Override
    public PluginVersion getVersion() {
        return new PluginVersion(1, 0, 0, 0);
    }

    @Override
    public PluginVersion neededAPIVersion() {
        return new PluginVersion(1, 2, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.device == null) {
            return;
        }
        new VNCDialog(this).setVisible(true);
    }

    void enableParent(boolean enable) {
        Window window = Tools.findWindow(this.buttonVNC);
        window.setEnabled(enable);
    }
}

