/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    private transient int size;
    private final Comparator<? super K> comparator;
    private transient int modCount;
    private transient Node<K, V> root;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient KeySet<K> navigableKeySet;
    private transient NavigableMap<K, V> descendingMap;

    private static <T> Comparable<T> toComparable(T t) {
        return (Comparable)t;
    }

    Iterator<K> keyIterator() {
        return new UnboundedKeyIterator(this);
    }

    Iterator<K> descendingKeyIterator() {
        return new UnboundedDescendingKeyIterator(this);
    }

    public TreeMap() {
        this.comparator = null;
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this(sortedMap.comparator());
        Node<K, V> node = null;
        for (Map.Entry<K, V> entry : sortedMap.entrySet()) {
            node = super.addToLast(node, entry.getKey(), entry.getValue());
        }
    }

    private Node<K, V> addToLast(Node<K, V> node, K k, V v) {
        if (node == null) {
            node = this.createNode(k, v);
            this.root = node;
            this.size = 1;
        } else if (node.size == 64) {
            Node<K, V> node2 = this.createNode(k, v);
            this.attachToRight(node, node2);
            this.balance(node2);
            ++this.size;
            node = node2;
        } else {
            this.appendFromRight(node, k, v);
            ++this.size;
        }
        return node;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Object clone() {
        try {
            TreeMap treeMap = (TreeMap)super.clone();
            treeMap.entrySet = null;
            treeMap.navigableKeySet = null;
            treeMap.descendingMap = null;
            if (this.root != null) {
                Node<K, V> node;
                treeMap.root = this.root.clone(null);
                Node<K, V> node2 = TreeMap.minimum(treeMap.root);
                while ((node = TreeMap.successor(node2)) != null) {
                    node.prev = node2;
                    node2.next = node;
                    node2 = node;
                }
            }
            return treeMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private static <K, V> Node<K, V> successor(Node<K, V> node) {
        if (node.right != null) {
            return TreeMap.minimum(node.right);
        }
        Node node2 = node.parent;
        while (node2 != null && node == node2.right) {
            node = node2;
            node2 = node2.parent;
        }
        return node2;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object object) {
        Comparable<Object> comparable = this.comparator == null ? TreeMap.toComparable(object) : null;
        Object object2 = object;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, object2, KArray[n]);
            if (n2 < 0) {
                node = node.left;
                continue;
            }
            if (n2 == 0) {
                return true;
            }
            int n3 = node.rightIndex;
            if (n != n3) {
                n2 = this.cmp(comparable, object2, KArray[n3]);
            }
            if (n2 > 0) {
                node = node.right;
                continue;
            }
            if (n2 == 0) {
                return true;
            }
            int n4 = n + 1;
            int n5 = 0;
            int n6 = n3 - 1;
            while (n4 <= n6) {
                n5 = n4 + n6 >> 1;
                n2 = this.cmp(comparable, object2, KArray[n5]);
                if (n2 > 0) {
                    n4 = n5 + 1;
                    continue;
                }
                if (n2 == 0) {
                    return true;
                }
                n6 = n5 - 1;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.root == null) {
            return false;
        }
        Node<K, V> node = TreeMap.minimum(this.root);
        if (object != null) {
            while (node != null) {
                int n = node.rightIndex;
                V[] VArray = node.values;
                for (int i = node.leftIndex; i <= n; ++i) {
                    if (!object.equals(VArray[i])) continue;
                    return true;
                }
                node = node.next;
            }
        } else {
            while (node != null) {
                int n = node.rightIndex;
                V[] VArray = node.values;
                for (int i = node.leftIndex; i <= n; ++i) {
                    if (VArray[i] != null) continue;
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object k = entry.getKey();
                        Object v = TreeMap.this.get(k);
                        Object v2 = entry.getValue();
                        return v == null ? v2 == null && TreeMap.this.containsKey(k) : v.equals(v2);
                    }
                    return false;
                }

                @Override
                public boolean remove(Object object) {
                    if (this.contains(object)) {
                        Map.Entry entry = (Map.Entry)object;
                        Object k = entry.getKey();
                        TreeMap.this.remove(k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new UnboundedEntryIterator(TreeMap.this);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public K firstKey() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.minimum(this.root);
            return node.keys[node.leftIndex];
        }
        throw new NoSuchElementException();
    }

    @Override
    public V get(Object object) {
        Comparable<Object> comparable = this.comparator == null ? TreeMap.toComparable(object) : null;
        Object object2 = object;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, object2, KArray[n]);
            if (n2 < 0) {
                node = node.left;
                continue;
            }
            if (n2 == 0) {
                return node.values[n];
            }
            int n3 = node.rightIndex;
            if (n != n3) {
                n2 = this.cmp(comparable, object2, KArray[n3]);
            }
            if (n2 > 0) {
                node = node.right;
                continue;
            }
            if (n2 == 0) {
                return node.values[n3];
            }
            int n4 = n + 1;
            int n5 = 0;
            int n6 = n3 - 1;
            while (n4 <= n6) {
                n5 = n4 + n6 >> 1;
                n2 = this.cmp(comparable, object2, KArray[n5]);
                if (n2 > 0) {
                    n4 = n5 + 1;
                    continue;
                }
                if (n2 == 0) {
                    return node.values[n5];
                }
                n6 = n5 - 1;
            }
            return null;
        }
        return null;
    }

    final Map.Entry<K, V> getEntry(Object object) {
        Comparable<Object> comparable = this.comparator == null ? TreeMap.toComparable(object) : null;
        Object object2 = object;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, object2, KArray[n]);
            if (n2 < 0) {
                node = node.left;
                continue;
            }
            if (n2 == 0) {
                return new Entry(node, n);
            }
            int n3 = node.rightIndex;
            if (n != n3) {
                n2 = this.cmp(comparable, object2, KArray[n3]);
            }
            if (n2 > 0) {
                node = node.right;
                continue;
            }
            if (n2 == 0) {
                return new Entry(node, n3);
            }
            int n4 = n + 1;
            int n5 = 0;
            int n6 = n3 - 1;
            while (n4 <= n6) {
                n5 = n4 + n6 >> 1;
                n2 = this.cmp(comparable, object2, KArray[n5]);
                if (n2 > 0) {
                    n4 = n5 + 1;
                    continue;
                }
                if (n2 == 0) {
                    return new Entry(node, n5);
                }
                n6 = n5 - 1;
            }
            return null;
        }
        return null;
    }

    private int cmp(Comparable<K> comparable, K k, K k2) {
        return comparable != null ? comparable.compareTo(k2) : this.comparator.compare(k, k2);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        NavigableMap<K, V> navigableMap = this.headMap(k, false);
        return navigableMap;
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        AscendingSubMap ascendingSubMap = new AscendingSubMap(this, true, null, true, false, k, bl);
        return ascendingSubMap;
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public K lastKey() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.maximum(this.root);
            return node.keys[node.rightIndex];
        }
        throw new NoSuchElementException();
    }

    private static <K, V> Node<K, V> minimum(Node<K, V> node) {
        if (node == null) {
            return null;
        }
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    private static <K, V> Node<K, V> maximum(Node<K, V> node) {
        if (node == null) {
            return null;
        }
        while (node.right != null) {
            node = node.right;
        }
        return node;
    }

    @Override
    public V put(K k, V v) {
        int n;
        int n2;
        int n3;
        Object object;
        if (this.root == null) {
            this.root = this.createNode(k, v);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparable<K> comparable = this.comparator == null ? TreeMap.toComparable(k) : null;
        K k2 = k;
        Node<K, V> node = this.root;
        Node<K, V> node2 = null;
        int n4 = 0;
        while (node != null) {
            node2 = node;
            object = node.keys;
            n3 = node.leftIndex;
            n4 = this.cmp(comparable, k2, object[n3]);
            if (n4 < 0) {
                node = node.left;
                continue;
            }
            if (n4 == 0) {
                Object v2 = node.values[n3];
                node.values[n3] = v;
                return v2;
            }
            n2 = node.rightIndex;
            if (n3 != n2) {
                n4 = this.cmp(comparable, k2, object[n2]);
            }
            if (n4 > 0) {
                node = node.right;
                continue;
            }
            if (n4 == 0) {
                Object v3 = node.values[n2];
                node.values[n2] = v;
                return v3;
            }
            n = n3 + 1;
            int n5 = 0;
            int n6 = n2 - 1;
            while (n <= n6) {
                n5 = n + n6 >> 1;
                n4 = this.cmp(comparable, k2, object[n5]);
                if (n4 > 0) {
                    n = n5 + 1;
                    continue;
                }
                if (n4 == 0) {
                    Object v4 = node.values[n5];
                    node.values[n5] = v;
                    return v4;
                }
                n6 = n5 - 1;
            }
            n4 = n;
            break;
        }
        ++this.size;
        ++this.modCount;
        if (node == null) {
            if (node2 == null) {
                this.root = this.createNode(k, v);
            } else if (node2.size < 64) {
                if (n4 < 0) {
                    this.appendFromLeft(node2, k, v);
                } else {
                    this.appendFromRight(node2, k, v);
                }
            } else {
                object = this.createNode(k, v);
                if (n4 < 0) {
                    this.attachToLeft(node2, (Node<K, V>)object);
                } else {
                    this.attachToRight(node2, (Node<K, V>)object);
                }
                this.balance((Node<K, V>)object);
            }
        } else if (node.size < 64) {
            int n7 = node.leftIndex;
            n3 = node.rightIndex;
            if (n7 == 0 || n3 != 63 && n3 - n4 <= n4 - n7) {
                n2 = n3 + 1;
                System.arraycopy(node.keys, n4, node.keys, n4 + 1, n2 - n4);
                System.arraycopy(node.values, n4, node.values, n4 + 1, n2 - n4);
                node.rightIndex = n2;
                node.keys[n4] = k;
                node.values[n4] = v;
            } else {
                n2 = n7 - 1;
                System.arraycopy(node.keys, n7, node.keys, n2, n4 - n7);
                System.arraycopy(node.values, n7, node.values, n2, n4 - n7);
                node.leftIndex = n2;
                node.keys[n4 - 1] = k;
                node.values[n4 - 1] = v;
            }
            ++node.size;
        } else {
            Object v5;
            Object k3;
            object = node.prev;
            Node node3 = node.next;
            n = 0;
            Node<K, V> node4 = null;
            if (object == null) {
                if (node3 != null && node3.size < 64) {
                    n2 = 0;
                } else {
                    n2 = 1;
                    n = 1;
                    node4 = node;
                }
            } else if (node3 == null) {
                if (object.size < 64) {
                    n2 = 1;
                } else {
                    n2 = 0;
                    n = 0;
                    node4 = node;
                }
            } else if (object.size < 64) {
                n2 = node3.size < 64 ? (object.size < node3.size ? 1 : 0) : 1;
            } else if (node3.size < 64) {
                n2 = 0;
            } else if (node.right == null) {
                node4 = node;
                n = 0;
                n2 = 0;
            } else {
                node4 = node3;
                n = 1;
                n2 = 0;
            }
            if (n2 != 0) {
                k3 = node.keys[0];
                v5 = node.values[0];
                int n8 = n4 - 1;
                System.arraycopy(node.keys, 1, node.keys, 0, n8);
                System.arraycopy(node.values, 1, node.values, 0, n8);
                node.keys[n8] = k;
                node.values[n8] = v;
            } else {
                k3 = node.keys[63];
                v5 = node.values[63];
                System.arraycopy(node.keys, n4, node.keys, n4 + 1, 63 - n4);
                System.arraycopy(node.values, n4, node.values, n4 + 1, 63 - n4);
                node.keys[n4] = k;
                node.values[n4] = v;
            }
            if (node4 == null) {
                if (n2 != 0) {
                    this.appendFromRight((Node<K, V>)object, k3, v5);
                } else {
                    this.appendFromLeft(node3, k3, v5);
                }
            } else {
                Node node5 = this.createNode(k3, v5);
                if (n != 0) {
                    this.attachToLeft(node4, node5);
                } else {
                    this.attachToRight(node4, node5);
                }
                this.balance(node5);
            }
        }
        return null;
    }

    private void appendFromLeft(Node<K, V> node, K k, V v) {
        if (node.leftIndex == 0) {
            int n = node.rightIndex + 1;
            System.arraycopy(node.keys, 0, node.keys, 1, n);
            System.arraycopy(node.values, 0, node.values, 1, n);
            node.rightIndex = n;
        } else {
            --node.leftIndex;
        }
        ++node.size;
        node.keys[node.leftIndex] = k;
        node.values[node.leftIndex] = v;
    }

    private void attachToLeft(Node<K, V> node, Node<K, V> node2) {
        Node node3;
        node2.parent = node;
        node.left = node2;
        node2.prev = node3 = node.prev;
        node2.next = node;
        if (node3 != null) {
            node3.next = node2;
        }
        node.prev = node2;
    }

    private void appendFromRight(Node<K, V> node, K k, V v) {
        if (node.rightIndex == 63) {
            int n = node.leftIndex;
            int n2 = n - 1;
            System.arraycopy(node.keys, n, node.keys, n2, 64 - n);
            System.arraycopy(node.values, n, node.values, n2, 64 - n);
            node.leftIndex = n2;
        } else {
            ++node.rightIndex;
        }
        ++node.size;
        node.keys[node.rightIndex] = k;
        node.values[node.rightIndex] = v;
    }

    private void attachToRight(Node<K, V> node, Node<K, V> node2) {
        Node node3;
        node2.parent = node;
        node.right = node2;
        node2.prev = node;
        node2.next = node3 = node.next;
        if (node3 != null) {
            node3.prev = node2;
        }
        node.next = node2;
    }

    private Node<K, V> createNode(K k, V v) {
        Node node = new Node();
        node.keys[0] = k;
        node.values[0] = v;
        node.leftIndex = 0;
        node.rightIndex = 0;
        node.size = 1;
        return node;
    }

    private void balance(Node<K, V> node) {
        node.color = true;
        while (node != this.root && node.parent.color) {
            Node node2;
            if (node.parent == node.parent.parent.left) {
                node2 = node.parent.parent.right;
                if (node2 != null && node2.color) {
                    node.parent.color = false;
                    node2.color = false;
                    node.parent.parent.color = true;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.leftRotate(node);
                }
                node.parent.color = false;
                node.parent.parent.color = true;
                this.rightRotate(node.parent.parent);
                continue;
            }
            node2 = node.parent.parent.left;
            if (node2 != null && node2.color) {
                node.parent.color = false;
                node2.color = false;
                node.parent.parent.color = true;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rightRotate(node);
            }
            node.parent.color = false;
            node.parent.parent.color = true;
            this.leftRotate(node.parent.parent);
        }
        this.root.color = false;
    }

    private void rightRotate(Node<K, V> node) {
        Node node2 = node.left;
        node.left = node2.right;
        if (node2.right != null) {
            node2.right.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent == null) {
            this.root = node2;
        } else if (node == node.parent.right) {
            node.parent.right = node2;
        } else {
            node.parent.left = node2;
        }
        node2.right = node;
        node.parent = node2;
    }

    private void leftRotate(Node<K, V> node) {
        Node node2 = node.right;
        node.right = node2.left;
        if (node2.left != null) {
            node2.left.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent == null) {
            this.root = node2;
        } else if (node == node.parent.left) {
            node.parent.left = node2;
        } else {
            node.parent.right = node2;
        }
        node2.left = node;
        node.parent = node2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n = map.size();
        if (this.size == 0 && n != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && comparator.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    @Override
    public V remove(Object object) {
        if (this.size == 0) {
            return null;
        }
        Comparable<Object> comparable = this.comparator == null ? TreeMap.toComparable(object) : null;
        Object object2 = object;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, object2, KArray[n]);
            if (n2 < 0) {
                node = node.left;
                continue;
            }
            if (n2 == 0) {
                Object v = node.values[n];
                this.removeLeftmost(node);
                return v;
            }
            int n3 = node.rightIndex;
            if (n != n3) {
                n2 = this.cmp(comparable, object2, KArray[n3]);
            }
            if (n2 > 0) {
                node = node.right;
                continue;
            }
            if (n2 == 0) {
                Object v = node.values[n3];
                this.removeRightmost(node);
                return v;
            }
            int n4 = n + 1;
            int n5 = 0;
            int n6 = n3 - 1;
            while (n4 <= n6) {
                n5 = n4 + n6 >> 1;
                n2 = this.cmp(comparable, object2, KArray[n5]);
                if (n2 > 0) {
                    n4 = n5 + 1;
                    continue;
                }
                if (n2 == 0) {
                    Object v = node.values[n5];
                    this.removeMiddleElement(node, n5);
                    return v;
                }
                n6 = n5 - 1;
            }
            return null;
        }
        return null;
    }

    private void removeLeftmost(Node<K, V> node) {
        int n = node.leftIndex;
        if (node.size == 1) {
            this.deleteNode(node);
        } else if (node.prev != null && 63 - node.prev.rightIndex > node.size) {
            Node node2 = node.prev;
            int n2 = node.rightIndex - n;
            System.arraycopy(node.keys, n + 1, node2.keys, node2.rightIndex + 1, n2);
            System.arraycopy(node.values, n + 1, node2.values, node2.rightIndex + 1, n2);
            node2.rightIndex += n2;
            node2.size += n2;
            this.deleteNode(node);
        } else if (node.next != null && node.next.leftIndex > node.size) {
            int n3;
            Node node3 = node.next;
            int n4 = node.rightIndex - n;
            node3.leftIndex = n3 = node3.leftIndex - n4;
            System.arraycopy(node.keys, n + 1, node3.keys, n3, n4);
            System.arraycopy(node.values, n + 1, node3.values, n3, n4);
            node3.size += n4;
            this.deleteNode(node);
        } else {
            node.keys[n] = null;
            node.values[n] = null;
            ++node.leftIndex;
            --node.size;
            Node node4 = node.prev;
            if (node4 != null && node4.size == 1) {
                ++node.size;
                --node.leftIndex;
                node.keys[node.leftIndex] = node4.keys[node4.leftIndex];
                node.values[node.leftIndex] = node4.values[node4.leftIndex];
                this.deleteNode(node4);
            }
        }
        ++this.modCount;
        --this.size;
    }

    private void removeRightmost(Node<K, V> node) {
        int n = node.rightIndex;
        if (node.size == 1) {
            this.deleteNode(node);
        } else if (node.prev != null && 63 - node.prev.rightIndex > node.size) {
            Node node2 = node.prev;
            int n2 = node.leftIndex;
            int n3 = n - n2;
            System.arraycopy(node.keys, n2, node2.keys, node2.rightIndex + 1, n3);
            System.arraycopy(node.values, n2, node2.values, node2.rightIndex + 1, n3);
            node2.rightIndex += n3;
            node2.size += n3;
            this.deleteNode(node);
        } else if (node.next != null && node.next.leftIndex > node.size) {
            int n4;
            Node node3 = node.next;
            int n5 = node.leftIndex;
            int n6 = n - n5;
            node3.leftIndex = n4 = node3.leftIndex - n6;
            System.arraycopy(node.keys, n5, node3.keys, n4, n6);
            System.arraycopy(node.values, n5, node3.values, n4, n6);
            node3.size += n6;
            this.deleteNode(node);
        } else {
            node.keys[n] = null;
            node.values[n] = null;
            --node.rightIndex;
            --node.size;
            Node node4 = node.next;
            if (node4 != null && node4.size == 1) {
                ++node.size;
                ++node.rightIndex;
                node.keys[node.rightIndex] = node4.keys[node4.leftIndex];
                node.values[node.rightIndex] = node4.values[node4.leftIndex];
                this.deleteNode(node4);
            }
        }
        ++this.modCount;
        --this.size;
    }

    private void removeMiddleElement(Node<K, V> node, int n) {
        if (node.prev != null && 63 - node.prev.rightIndex > node.size) {
            Node node2 = node.prev;
            int n2 = node.leftIndex;
            int n3 = n - n2;
            System.arraycopy(node.keys, n2, node2.keys, node2.rightIndex + 1, n3);
            System.arraycopy(node.values, n2, node2.values, node2.rightIndex + 1, n3);
            node2.rightIndex += n3;
            n3 = node.rightIndex - n;
            System.arraycopy(node.keys, n + 1, node2.keys, node2.rightIndex + 1, n3);
            System.arraycopy(node.values, n + 1, node2.values, node2.rightIndex + 1, n3);
            node2.rightIndex += n3;
            node2.size += node.size - 1;
            this.deleteNode(node);
        } else if (node.next != null && node.next.leftIndex > node.size) {
            int n4;
            Node node3 = node.next;
            int n5 = node.leftIndex;
            node3.leftIndex = n4 = node3.leftIndex - node.size + 1;
            int n6 = n - n5;
            System.arraycopy(node.keys, n5, node3.keys, n4, n6);
            System.arraycopy(node.values, n5, node3.values, n4, n6);
            n4 += n6;
            n6 = node.rightIndex - n;
            System.arraycopy(node.keys, n + 1, node3.keys, n4, n6);
            System.arraycopy(node.values, n + 1, node3.values, n4, n6);
            node3.size += node.size - 1;
            this.deleteNode(node);
        } else {
            int n7 = node.rightIndex - n;
            int n8 = node.leftIndex;
            int n9 = n - n8;
            if (n7 <= n9) {
                System.arraycopy(node.keys, n + 1, node.keys, n, n7);
                System.arraycopy(node.values, n + 1, node.values, n, n7);
                Node node4 = node.next;
                if (node4 != null && node4.size == 1) {
                    node.keys[node.rightIndex] = node4.keys[node4.leftIndex];
                    node.values[node.rightIndex] = node4.values[node4.leftIndex];
                    this.deleteNode(node4);
                } else {
                    node.keys[node.rightIndex] = null;
                    node.values[node.rightIndex] = null;
                    --node.rightIndex;
                    --node.size;
                }
            } else {
                System.arraycopy(node.keys, n8, node.keys, n8 + 1, n9);
                System.arraycopy(node.values, n8, node.values, n8 + 1, n9);
                Node node5 = node.prev;
                if (node5 != null && node5.size == 1) {
                    node.keys[n8] = node5.keys[node5.leftIndex];
                    node.values[n8] = node5.values[node5.leftIndex];
                    this.deleteNode(node5);
                } else {
                    node.keys[n8] = null;
                    node.values[n8] = null;
                    ++node.leftIndex;
                    --node.size;
                }
            }
        }
        ++this.modCount;
        --this.size;
    }

    private void removeFromIterator(Node<K, V> node, int n) {
        int n2;
        if (node.size == 1) {
            this.deleteNode(node);
        } else if (n == (n2 = node.leftIndex++)) {
            Node node2 = node.prev;
            if (node2 != null && node2.size == 1) {
                node.keys[n2] = node2.keys[node2.leftIndex];
                node.values[n2] = node2.values[node2.leftIndex];
                this.deleteNode(node2);
            } else {
                node.keys[n2] = null;
                node.values[n2] = null;
                ++node.leftIndex;
                --node.size;
            }
        } else if (n == node.rightIndex) {
            node.keys[n] = null;
            node.values[n] = null;
            --node.rightIndex;
            --node.size;
        } else {
            int n3 = node.rightIndex - n;
            int n4 = n - n2;
            if (n3 <= n4) {
                System.arraycopy(node.keys, n + 1, node.keys, n, n3);
                System.arraycopy(node.values, n + 1, node.values, n, n3);
                node.keys[node.rightIndex] = null;
                node.values[node.rightIndex] = null;
                --node.rightIndex;
                --node.size;
            } else {
                System.arraycopy(node.keys, n2, node.keys, n2 + 1, n4);
                System.arraycopy(node.values, n2, node.values, n2 + 1, n4);
                node.keys[n2] = null;
                node.values[n2] = null;
                --node.size;
            }
        }
        ++this.modCount;
        --this.size;
    }

    private void deleteNode(Node<K, V> node) {
        if (node.right == null) {
            if (node.left != null) {
                this.attachToParent(node, node.left);
            } else {
                this.attachNullToParent(node);
            }
            this.fixNextChain(node);
        } else if (node.left == null) {
            this.attachToParent(node, node.right);
            this.fixNextChain(node);
        } else {
            Node node2 = node.next;
            this.fixNextChain(node);
            if (node2.right == null) {
                this.attachNullToParent(node2);
            } else {
                this.attachToParent(node2, node2.right);
            }
            node2.left = node.left;
            if (node.left != null) {
                node.left.parent = node2;
            }
            node2.right = node.right;
            if (node.right != null) {
                node.right.parent = node2;
            }
            this.attachToParentNoFixup(node, node2);
            node2.color = node.color;
        }
    }

    private void attachToParentNoFixup(Node<K, V> node, Node<K, V> node2) {
        Node node3;
        node2.parent = node3 = node.parent;
        if (node3 == null) {
            this.root = node2;
        } else if (node == node3.left) {
            node3.left = node2;
        } else {
            node3.right = node2;
        }
    }

    private void attachToParent(Node<K, V> node, Node<K, V> node2) {
        this.attachToParentNoFixup(node, node2);
        if (!node.color) {
            this.fixup(node2);
        }
    }

    private void attachNullToParent(Node<K, V> node) {
        Node node2 = node.parent;
        if (node2 == null) {
            this.root = null;
        } else {
            if (node == node2.left) {
                node2.left = null;
            } else {
                node2.right = null;
            }
            if (!node.color) {
                this.fixup(node2);
            }
        }
    }

    private void fixNextChain(Node<K, V> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
    }

    private void fixup(Node<K, V> node) {
        while (node != this.root && !node.color) {
            Node node2;
            if (node == node.parent.left) {
                node2 = node.parent.right;
                if (node2 == null) {
                    node = node.parent;
                    continue;
                }
                if (node2.color) {
                    node2.color = false;
                    node.parent.color = true;
                    this.leftRotate(node.parent);
                    node2 = node.parent.right;
                    if (node2 == null) {
                        node = node.parent;
                        continue;
                    }
                }
                if (!(node2.left != null && node2.left.color || node2.right != null && node2.right.color)) {
                    node2.color = true;
                    node = node.parent;
                    continue;
                }
                if (node2.right == null || !node2.right.color) {
                    node2.left.color = false;
                    node2.color = true;
                    this.rightRotate(node2);
                    node2 = node.parent.right;
                }
                node2.color = node.parent.color;
                node.parent.color = false;
                node2.right.color = false;
                this.leftRotate(node.parent);
                node = this.root;
                continue;
            }
            node2 = node.parent.left;
            if (node2 == null) {
                node = node.parent;
                continue;
            }
            if (node2.color) {
                node2.color = false;
                node.parent.color = true;
                this.rightRotate(node.parent);
                node2 = node.parent.left;
                if (node2 == null) {
                    node = node.parent;
                    continue;
                }
            }
            if (!(node2.left != null && node2.left.color || node2.right != null && node2.right.color)) {
                node2.color = true;
                node = node.parent;
                continue;
            }
            if (node2.left == null || !node2.left.color) {
                node2.right.color = false;
                node2.color = true;
                this.leftRotate(node2);
                node2 = node.parent.left;
            }
            node2.color = node.parent.color;
            node.parent.color = false;
            node2.left.color = false;
            this.rightRotate(node.parent);
            node = this.root;
        }
        node.color = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        NavigableMap<K, V> navigableMap = this.subMap(k, true, k2, false);
        return navigableMap;
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        AscendingSubMap ascendingSubMap = new AscendingSubMap(this, false, k, bl, false, k2, bl2);
        return ascendingSubMap;
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        NavigableMap<K, V> navigableMap = this.tailMap(k, true);
        return navigableMap;
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        AscendingSubMap ascendingSubMap = new AscendingSubMap(this, false, k, bl, true, null, true);
        return ascendingSubMap;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new UnboundedValueIterator(TreeMap.this);
                }
            };
        }
        return this.values;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry<K, V> entry = this.getFirstEntry();
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getFirstEntry() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.minimum(this.root);
            return new Entry(node, node.leftIndex);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry<K, V> entry = this.getLastEntry();
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getLastEntry() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.maximum(this.root);
            return new Entry(node, node.rightIndex);
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> entry = this.getFirstEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.remove(entry.getKey());
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> entry = this.getLastEntry();
        Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
        if (entry != null) {
            this.remove(entry.getKey());
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        Map.Entry<K, V> entry = this.getLowerEntry(k);
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getLowerEntry(K k) {
        Comparable<K> comparable = this.comparator == null ? TreeMap.toComparable(k) : null;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.rightIndex;
            int n2 = this.cmp(comparable, k, KArray[n]);
            if (n2 > 0) {
                if (node.right != null) {
                    node = node.right;
                    continue;
                }
                return new Entry(node, n);
            }
            int n3 = node.leftIndex;
            n2 = this.cmp(comparable, k, KArray[n3]);
            if (n2 > 0) {
                for (int i = n; i >= n3; --i) {
                    n2 = this.cmp(comparable, k, KArray[i]);
                    if (n2 <= 0) continue;
                    return new Entry(node, i);
                }
                continue;
            }
            if (node.left != null) {
                node = node.left;
                continue;
            }
            Node node2 = node.parent;
            Node<K, V> node3 = node;
            while (node2 != null && node3 == node2.left) {
                node3 = node2;
                node2 = node2.parent;
            }
            node = node2;
            if (node == null) continue;
            KArray = node.keys;
            n3 = node.leftIndex;
            for (int i = n = node.rightIndex; i >= n3; --i) {
                n2 = this.cmp(comparable, k, KArray[i]);
                if (n2 <= 0) continue;
                return new Entry(node, i);
            }
        }
        return null;
    }

    @Override
    public K lowerKey(K k) {
        Map.Entry<K, V> entry = this.getLowerEntry(k);
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        Map.Entry<K, V> entry = this.getFloorEntry(k);
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getFloorEntry(K k) {
        Comparable<K> comparable = this.comparator == null ? TreeMap.toComparable(k) : null;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.rightIndex;
            int n2 = this.cmp(comparable, k, KArray[n]);
            if (n2 > 0) {
                if (node.right != null) {
                    node = node.right;
                    continue;
                }
                return new Entry(node, n);
            }
            if (n2 < 0) {
                int n3 = node.leftIndex;
                n2 = this.cmp(comparable, k, KArray[n3]);
                if (n2 > 0) {
                    for (int i = n; i >= n3; --i) {
                        n2 = this.cmp(comparable, k, KArray[i]);
                        if (n2 < 0) continue;
                        return new Entry(node, i);
                    }
                    continue;
                }
                if (n2 < 0) {
                    if (node.left != null) {
                        node = node.left;
                        continue;
                    }
                    Node node2 = node.parent;
                    Node<K, V> node3 = node;
                    while (node2 != null && node3 == node2.left) {
                        node3 = node2;
                        node2 = node2.parent;
                    }
                    node = node2;
                    if (node == null) continue;
                    KArray = node.keys;
                    n3 = node.leftIndex;
                    for (int i = n = node.rightIndex; i >= n3; --i) {
                        n2 = this.cmp(comparable, k, KArray[i]);
                        if (n2 < 0) continue;
                        return new Entry(node, i);
                    }
                    continue;
                }
                return new Entry(node, n3);
            }
            return new Entry(node, n);
        }
        return null;
    }

    @Override
    public K floorKey(K k) {
        Map.Entry<K, V> entry = this.getFloorEntry(k);
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        Map.Entry<K, V> entry = this.getCeilingEntry(k);
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getCeilingEntry(K k) {
        Comparable<K> comparable = this.comparator == null ? TreeMap.toComparable(k) : null;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, k, KArray[n]);
            if (n2 < 0) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                return new Entry(node, n);
            }
            if (n2 > 0) {
                int n3 = node.rightIndex;
                n2 = this.cmp(comparable, k, KArray[n3]);
                if (n2 < 0) {
                    for (int i = n; i <= n3; ++i) {
                        n2 = this.cmp(comparable, k, KArray[i]);
                        if (n2 > 0) continue;
                        return new Entry(node, i);
                    }
                    continue;
                }
                if (n2 > 0) {
                    if (node.right != null) {
                        node = node.right;
                        continue;
                    }
                    Node node2 = node.parent;
                    Node<K, V> node3 = node;
                    while (node2 != null && node3 == node2.right) {
                        node3 = node2;
                        node2 = node2.parent;
                    }
                    node = node2;
                    if (node == null) continue;
                    n = node.leftIndex;
                    n3 = node.rightIndex;
                    KArray = node.keys;
                    for (int i = n; i <= n3; ++i) {
                        n2 = this.cmp(comparable, k, KArray[i]);
                        if (n2 > 0) continue;
                        return new Entry(node, i);
                    }
                    continue;
                }
                return new Entry(node, n3);
            }
            return new Entry(node, n);
        }
        return null;
    }

    @Override
    public K ceilingKey(K k) {
        Map.Entry<K, V> entry = this.getCeilingEntry(k);
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        Map.Entry<K, V> entry = this.getHigherEntry(k);
        return TreeMap.exportEntry(entry);
    }

    final Map.Entry<K, V> getHigherEntry(K k) {
        Comparable<K> comparable = this.comparator == null ? TreeMap.toComparable(k) : null;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] KArray = node.keys;
            int n = node.leftIndex;
            int n2 = this.cmp(comparable, k, KArray[n]);
            if (n2 < 0) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                return new Entry(node, n);
            }
            int n3 = node.rightIndex;
            n2 = this.cmp(comparable, k, KArray[n3]);
            if (n2 < 0) {
                for (int i = n; i <= n3; ++i) {
                    n2 = this.cmp(comparable, k, KArray[i]);
                    if (n2 >= 0) continue;
                    return new Entry(node, i);
                }
                continue;
            }
            if (node.right != null) {
                node = node.right;
                continue;
            }
            Node node2 = node.parent;
            Node<K, V> node3 = node;
            while (node2 != null && node3 == node2.right) {
                node3 = node2;
                node2 = node2.parent;
            }
            node = node2;
            if (node == null) continue;
            KArray = node.keys;
            n = node.leftIndex;
            n3 = node.rightIndex;
            for (int i = n; i <= n3; ++i) {
                n2 = this.cmp(comparable, k, KArray[i]);
                if (n2 >= 0) continue;
                return new Entry(node, i);
            }
        }
        return null;
    }

    @Override
    public K higherKey(K k) {
        Map.Entry<K, V> entry = this.getHigherEntry(k);
        return TreeMap.keyOrNull(entry);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> keySet = this.navigableKeySet;
        return keySet != null ? keySet : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> navigableMap = this.descendingMap;
        return navigableMap != null ? navigableMap : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        NavigableSet<K> navigableSet = this.descendingMap().navigableKeySet();
        return navigableSet;
    }

    static <K, V> Map.Entry<K, V> exportEntry(Map.Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    static <K, V> K keyOrNull(Map.Entry<K, V> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    static <K> K key(Map.Entry<K, ?> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    static final boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        if (this.size > 0) {
            Node<K, V> node = TreeMap.minimum(this.root);
            while (node != null) {
                int n = node.rightIndex;
                for (int i = node.leftIndex; i <= n; ++i) {
                    objectOutputStream.writeObject(node.keys[i]);
                    objectOutputStream.writeObject(node.values[i]);
                }
                node = node.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        Node<Object, V> node = null;
        for (int i = 0; i < n; ++i) {
            V v2;
            Object object;
            if (iterator != null) {
                if (v == null) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    object = entry.getKey();
                    v2 = entry.getValue();
                } else {
                    object = iterator.next();
                    v2 = v;
                }
            } else {
                object = objectInputStream.readObject();
                v2 = v != null ? v : objectInputStream.readObject();
            }
            node = this.addToLast(node, object, v2);
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> navigableMap) {
            this.m = navigableMap;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public boolean remove(Object object) {
            int n = this.size();
            this.m.remove(object);
            return this.size() != n;
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return new KeySet<E>(this.m.subMap(e, bl, e2, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return new KeySet<E>(this.m.headMap(e, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return new KeySet<E>(this.m.tailMap(e, bl));
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return this.subSet(e, true, e2, false);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return this.headSet(e, false);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return this.tailSet(e, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
            this.reverseComparator = Collections.reverseOrder(((TreeMap)treeMap).comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, k2, bl2, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap ascendingSubMap = this.descendingMapView;
            return ascendingSubMap != null ? ascendingSubMap : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            int n;
            int n2;
            Node node;
            if (this.toEnd) {
                node = TreeMap.maximum(this.m.root);
                n2 = node == null ? 0 : node.rightIndex;
            } else {
                this.setLastKey();
                node = this.lastKeyNode;
                n2 = this.lastKeyIndex;
            }
            int n3 = n = node == null ? 0 : n2 - node.leftIndex;
            if (this.fromStart) {
                return new UnboundedDescendingKeyIterator(this.m, node, n);
            }
            this.setFirstKey();
            Node node2 = this.firstKeyNode;
            if (node2 == null) {
                node = null;
            }
            int n4 = this.firstKeyIndex;
            int n5 = node2 == null ? 0 : n4 - node2.leftIndex;
            BoundedDescendingKeyIterator boundedDescendingKeyIterator = new BoundedDescendingKeyIterator(node2, n5, this.m, node, n);
            return boundedDescendingKeyIterator;
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            int n;
            Node node;
            if (this.fromStart) {
                node = TreeMap.minimum(this.m.root);
                n = node != null ? node.leftIndex : 0;
            } else {
                this.setFirstKey();
                node = this.firstKeyNode;
                n = this.firstKeyIndex;
            }
            if (this.toEnd) {
                return new UnboundedKeyIterator(this.m, node, node == null ? 0 : node.rightIndex - n);
            }
            this.setLastKey();
            Node node2 = this.lastKeyNode;
            int n2 = this.lastKeyIndex;
            return new BoundedKeyIterator(node, node == null ? 0 : node.rightIndex - n, this.m, node2, node2 == null ? 0 : node2.rightIndex - n2);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : (this.entrySetView = new DescendingEntrySetView());
        }

        @Override
        Map.Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        Map.Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        Map.Entry<K, V> subCeiling(K k) {
            return this.absFloor(k);
        }

        @Override
        Map.Entry<K, V> subHigher(K k) {
            return this.absLower(k);
        }

        @Override
        Map.Entry<K, V> subFloor(K k) {
            return this.absCeiling(k);
        }

        @Override
        Map.Entry<K, V> subLower(K k) {
            return this.absHigher(k);
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                int n;
                int n2;
                Node node;
                if (DescendingSubMap.this.toEnd) {
                    node = TreeMap.maximum(DescendingSubMap.this.m.root);
                    n2 = node == null ? 0 : node.rightIndex;
                } else {
                    DescendingSubMap.this.setLastKey();
                    node = DescendingSubMap.this.lastKeyNode;
                    n2 = DescendingSubMap.this.lastKeyIndex;
                }
                int n3 = n = node == null ? 0 : n2 - node.leftIndex;
                if (DescendingSubMap.this.fromStart) {
                    return new UnboundedDescendingEntryIterator(DescendingSubMap.this.m, node, n);
                }
                DescendingSubMap.this.setFirstKey();
                Node node2 = DescendingSubMap.this.firstKeyNode;
                if (node2 == null) {
                    node = null;
                }
                int n4 = DescendingSubMap.this.firstKeyIndex;
                int n5 = node2 == null ? 0 : n4 - node2.leftIndex;
                BoundedDescendingEntryIterator boundedDescendingEntryIterator = new BoundedDescendingEntryIterator(node2, n5, DescendingSubMap.this.m, node, n);
                return boundedDescendingEntryIterator;
            }
        }
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            super(treeMap, bl, k, bl2, bl3, k2, bl4);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, k, bl, false, k2, bl2);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k, bl);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.inRange(k, bl)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, k, bl, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap descendingSubMap = this.descendingMapView;
            return descendingSubMap != null ? descendingSubMap : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            int n;
            Node node;
            if (this.fromStart) {
                node = TreeMap.minimum(this.m.root);
                n = node != null ? node.leftIndex : 0;
            } else {
                this.setFirstKey();
                node = this.firstKeyNode;
                n = this.firstKeyIndex;
            }
            if (this.toEnd) {
                return new UnboundedKeyIterator(this.m, node, node == null ? 0 : node.rightIndex - n);
            }
            this.setLastKey();
            Node node2 = this.lastKeyNode;
            int n2 = this.lastKeyIndex;
            return new BoundedKeyIterator(node, node == null ? 0 : node.rightIndex - n, this.m, node2, node2 == null ? 0 : node2.rightIndex - n2);
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            int n;
            int n2;
            Node node;
            if (this.toEnd) {
                node = TreeMap.maximum(this.m.root);
                n2 = node == null ? 0 : node.rightIndex;
            } else {
                this.setLastKey();
                node = this.lastKeyNode;
                n2 = this.lastKeyIndex;
            }
            int n3 = n = node == null ? 0 : n2 - node.leftIndex;
            if (this.fromStart) {
                return new UnboundedDescendingKeyIterator(this.m, node, n);
            }
            this.setFirstKey();
            Node node2 = this.firstKeyNode;
            if (node2 == null) {
                node = null;
            }
            int n4 = this.firstKeyIndex;
            int n5 = node2 == null ? 0 : n4 - node2.leftIndex;
            BoundedDescendingKeyIterator boundedDescendingKeyIterator = new BoundedDescendingKeyIterator(node2, n5, this.m, node, n);
            return boundedDescendingKeyIterator;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : (this.entrySetView = new AscendingEntrySetView());
        }

        @Override
        Map.Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        Map.Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        Map.Entry<K, V> subCeiling(K k) {
            return this.absCeiling(k);
        }

        @Override
        Map.Entry<K, V> subHigher(K k) {
            return this.absHigher(k);
        }

        @Override
        Map.Entry<K, V> subFloor(K k) {
            return this.absFloor(k);
        }

        @Override
        Map.Entry<K, V> subLower(K k) {
            return this.absLower(k);
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                int n;
                Node node;
                if (AscendingSubMap.this.fromStart) {
                    node = TreeMap.minimum(AscendingSubMap.this.m.root);
                    n = node != null ? node.leftIndex : 0;
                } else {
                    AscendingSubMap.this.setFirstKey();
                    node = AscendingSubMap.this.firstKeyNode;
                    n = AscendingSubMap.this.firstKeyIndex;
                }
                if (AscendingSubMap.this.toEnd) {
                    return new UnboundedEntryIterator(AscendingSubMap.this.m, node, node == null ? 0 : node.rightIndex - n);
                }
                AscendingSubMap.this.setLastKey();
                Node node2 = AscendingSubMap.this.lastKeyNode;
                int n2 = AscendingSubMap.this.lastKeyIndex;
                return new BoundedEntryIterator(node, node == null ? 0 : node.rightIndex - n, AscendingSubMap.this.m, node2, node2 == null ? 0 : node2.rightIndex - n2);
            }
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient int loKeyModCount;
        transient int hiKeyModCount;
        transient Node<K, V> firstKeyNode;
        transient Node<K, V> lastKeyNode;
        transient int firstKeyIndex;
        transient int lastKeyIndex;
        transient NavigableMap<K, V> descendingMapView = null;
        transient EntrySetView entrySetView = null;
        transient KeySet<K> navigableKeySetView = null;

        NavigableSubMap(TreeMap<K, V> treeMap, boolean bl, K k, boolean bl2, boolean bl3, K k2, boolean bl4) {
            if (!bl && !bl3) {
                if (treeMap.compare(k, k2) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!bl) {
                    treeMap.compare(k, k);
                }
                if (!bl3) {
                    treeMap.compare(k2, k2);
                }
            }
            this.m = treeMap;
            this.fromStart = bl;
            this.lo = k;
            this.loInclusive = bl2;
            this.toEnd = bl3;
            this.hi = k2;
            this.hiInclusive = bl4;
            this.hiKeyModCount = -1;
            this.loKeyModCount = -1;
        }

        final boolean tooLow(Object object) {
            int n;
            return !this.fromStart && ((n = this.m.compare(object, this.lo)) < 0 || n == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object object) {
            int n;
            return !this.toEnd && ((n = this.m.compare(object, this.hi)) > 0 || n == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object object) {
            return !this.tooLow(object) && !this.tooHigh(object);
        }

        final boolean inClosedRange(Object object) {
            return !(!this.fromStart && this.m.compare(object, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, object) < 0);
        }

        final boolean inRange(Object object, boolean bl) {
            return bl ? this.inRange(object) : this.inClosedRange(object);
        }

        final Map.Entry<K, V> absLowest() {
            Map.Entry<K, V> entry = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return entry == null || this.tooHigh(entry.getKey()) ? null : entry;
        }

        final Map.Entry<K, V> absHighest() {
            Map.Entry<K, V> entry = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return entry == null || this.tooLow(entry.getKey()) ? null : entry;
        }

        final Map.Entry<K, V> absCeiling(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Map.Entry<K, V> entry = this.m.getCeilingEntry(k);
            return entry == null || this.tooHigh(entry.getKey()) ? null : entry;
        }

        final Map.Entry<K, V> absHigher(K k) {
            if (this.tooLow(k)) {
                return this.absLowest();
            }
            Map.Entry<K, V> entry = this.m.getHigherEntry(k);
            return entry == null || this.tooHigh(entry.getKey()) ? null : entry;
        }

        final Map.Entry<K, V> absFloor(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Map.Entry<K, V> entry = this.m.getFloorEntry(k);
            return entry == null || this.tooLow(entry.getKey()) ? null : entry;
        }

        final Map.Entry<K, V> absLower(K k) {
            if (this.tooHigh(k)) {
                return this.absHighest();
            }
            Map.Entry<K, V> entry = this.m.getLowerEntry(k);
            return entry == null || this.tooLow(entry.getKey()) ? null : entry;
        }

        abstract Map.Entry<K, V> subLowest();

        abstract Map.Entry<K, V> subHighest();

        abstract Map.Entry<K, V> subCeiling(K var1);

        abstract Map.Entry<K, V> subHigher(K var1);

        abstract Map.Entry<K, V> subFloor(K var1);

        abstract Map.Entry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.size() == 0;
        }

        @Override
        public int size() {
            int n;
            Node<K, V> node;
            int n2;
            Node<K, V> node2;
            if (this.fromStart && this.toEnd) {
                return this.m.size();
            }
            if (this.fromStart) {
                node2 = TreeMap.minimum(((TreeMap)this.m).root);
                n2 = node2 == null ? 0 : node2.leftIndex;
            } else {
                this.setFirstKey();
                node2 = this.firstKeyNode;
                n2 = this.firstKeyIndex;
            }
            if (node2 == null) {
                return 0;
            }
            if (this.toEnd) {
                node = TreeMap.maximum(((TreeMap)this.m).root);
                n = node == null ? 0 : node.rightIndex;
            } else {
                this.setLastKey();
                node = this.lastKeyNode;
                n = this.lastKeyIndex;
            }
            if (node == null) {
                return 0;
            }
            if (node2 == node) {
                return n - n2 + 1;
            }
            int n3 = 0;
            while (node2 != node) {
                n3 += node2.rightIndex - n2 + 1;
                node2 = node2.next;
                n2 = node2.leftIndex;
            }
            return n3 + n - n2 + 1;
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.inRange(object) && this.m.containsKey(object);
        }

        @Override
        public final V put(K k, V v) {
            if (!this.inRange(k)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(k, v);
        }

        @Override
        public final V get(Object object) {
            return !this.inRange(object) ? null : (V)this.m.get(object);
        }

        @Override
        public final V remove(Object object) {
            return !this.inRange(object) ? null : (V)this.m.remove(object);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K k) {
            return TreeMap.exportEntry(this.subCeiling(k));
        }

        @Override
        public final K ceilingKey(K k) {
            return TreeMap.keyOrNull(this.subCeiling(k));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K k) {
            return TreeMap.exportEntry(this.subHigher(k));
        }

        @Override
        public final K higherKey(K k) {
            return TreeMap.keyOrNull(this.subHigher(k));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K k) {
            return TreeMap.exportEntry(this.subFloor(k));
        }

        @Override
        public final K floorKey(K k) {
            return TreeMap.keyOrNull(this.subFloor(k));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K k) {
            return TreeMap.exportEntry(this.subLower(k));
        }

        @Override
        public final K lowerKey(K k) {
            return TreeMap.keyOrNull(this.subLower(k));
        }

        @Override
        public final K firstKey() {
            return TreeMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return TreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return TreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return TreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> entry = this.subLowest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                V v = this.m.remove(entry.getKey());
            }
            return entry2;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> entry = this.subHighest();
            Map.Entry<K, V> entry2 = TreeMap.exportEntry(entry);
            if (entry != null) {
                V v = this.m.remove(entry.getKey());
            }
            return entry2;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> keySet = this.navigableKeySetView;
            return keySet != null ? keySet : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        protected void setFirstKey() {
            if (this.loKeyModCount == ((TreeMap)this.m).modCount) {
                return;
            }
            if (this.loInclusive) {
                this.setFirstKeyInclusive();
            } else {
                this.setFirstKeyNonInclusive();
            }
            this.loKeyModCount = ((TreeMap)this.m).modCount;
        }

        private void setFirstKeyNonInclusive() {
            Comparable comparable = ((TreeMap)this.m).comparator == null ? TreeMap.toComparable(this.lo) : null;
            K k = this.lo;
            Node node = ((TreeMap)this.m).root;
            Node node2 = null;
            int n = -1;
            block0: while (node != null) {
                K[] KArray = node.keys;
                int n2 = node.leftIndex;
                int n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n2]);
                if (n3 < 0) {
                    node2 = node;
                    n = n2;
                    node = node.left;
                    continue;
                }
                int n4 = node.rightIndex;
                if (n2 != n4) {
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n4]);
                }
                if (n3 >= 0) {
                    node = node.right;
                    continue;
                }
                node2 = node;
                n = n4;
                int n5 = n2 + 1;
                int n6 = 0;
                int n7 = n4 - 1;
                while (n5 <= n7) {
                    n6 = n5 + n7 >> 1;
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n6]);
                    if (n3 > 0) {
                        n5 = n6 + 1;
                        continue;
                    }
                    if (n3 == 0) {
                        node2 = node;
                        n = n6 + 1;
                        break block0;
                    }
                    node2 = node;
                    n = n6;
                    n7 = n6 - 1;
                }
                break block0;
            }
            if (node2 != null && !this.checkUpperBound(node2.keys[n])) {
                node2 = null;
            }
            this.firstKeyNode = node2;
            this.firstKeyIndex = n;
        }

        private void setFirstKeyInclusive() {
            Comparable comparable = ((TreeMap)this.m).comparator == null ? TreeMap.toComparable(this.lo) : null;
            K k = this.lo;
            Node node = ((TreeMap)this.m).root;
            Node node2 = null;
            int n = -1;
            block0: while (node != null) {
                K[] KArray = node.keys;
                int n2 = node.leftIndex;
                int n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n2]);
                if (n3 < 0) {
                    node2 = node;
                    n = n2;
                    node = node.left;
                    continue;
                }
                if (n3 == 0) {
                    node2 = node;
                    n = n2;
                    break;
                }
                int n4 = node.rightIndex;
                if (n2 != n4) {
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n4]);
                }
                if (n3 > 0) {
                    node = node.right;
                    continue;
                }
                if (n3 == 0) {
                    node2 = node;
                    n = n4;
                    break;
                }
                node2 = node;
                n = n4;
                int n5 = n2 + 1;
                int n6 = 0;
                int n7 = n4 - 1;
                while (n5 <= n7) {
                    n6 = n5 + n7 >> 1;
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n6]);
                    if (n3 > 0) {
                        n5 = n6 + 1;
                        continue;
                    }
                    if (n3 == 0) {
                        node2 = node;
                        n = n6;
                        break block0;
                    }
                    node2 = node;
                    n = n6;
                    n7 = n6 - 1;
                }
                break block0;
            }
            if (node2 != null && !this.checkUpperBound(node2.keys[n])) {
                node2 = null;
            }
            this.firstKeyNode = node2;
            this.firstKeyIndex = n;
        }

        protected void setLastKey() {
            if (this.hiKeyModCount == ((TreeMap)this.m).modCount) {
                return;
            }
            if (this.hiInclusive) {
                this.setLastKeyInclusive();
            } else {
                this.setLastKeyNonInclusive();
            }
            this.hiKeyModCount = ((TreeMap)this.m).modCount;
        }

        private void setLastKeyInclusive() {
            Comparable comparable = ((TreeMap)this.m).comparator == null ? TreeMap.toComparable(this.hi) : null;
            K k = this.hi;
            Node node = ((TreeMap)this.m).root;
            Node node2 = null;
            int n = -1;
            block0: while (node != null) {
                K[] KArray = node.keys;
                int n2 = node.leftIndex;
                int n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n2]);
                if (n3 < 0) {
                    node = node.left;
                    continue;
                }
                if (n3 == 0) {
                    node2 = node;
                    n = n2;
                    break;
                }
                int n4 = node.rightIndex;
                if (n2 != n4) {
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n4]);
                }
                if (n3 > 0) {
                    node2 = node;
                    n = n4;
                    node = node.right;
                    continue;
                }
                if (n3 == 0) {
                    node2 = node;
                    n = n4;
                    break;
                }
                node2 = node;
                n = n2;
                int n5 = n2 + 1;
                int n6 = 0;
                int n7 = n4 - 1;
                while (n5 <= n7) {
                    n6 = n5 + n7 >> 1;
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n6]);
                    if (n3 > 0) {
                        node2 = node;
                        n = n6;
                        n5 = n6 + 1;
                        continue;
                    }
                    if (n3 == 0) {
                        node2 = node;
                        n = n6;
                        break block0;
                    }
                    n7 = n6 - 1;
                }
                break block0;
            }
            if (node2 != null && !this.checkLowerBound(node2.keys[n])) {
                node2 = null;
            }
            this.lastKeyNode = node2;
            this.lastKeyIndex = n;
        }

        private void setLastKeyNonInclusive() {
            Comparable comparable = ((TreeMap)this.m).comparator == null ? TreeMap.toComparable(this.hi) : null;
            K k = this.hi;
            Node node = ((TreeMap)this.m).root;
            Node node2 = null;
            int n = -1;
            block0: while (node != null) {
                K[] KArray = node.keys;
                int n2 = node.leftIndex;
                int n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n2]);
                if (n3 <= 0) {
                    node = node.left;
                    continue;
                }
                int n4 = node.rightIndex;
                if (n2 != n4) {
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n4]);
                }
                if (n3 > 0) {
                    node2 = node;
                    n = n4;
                    node = node.right;
                    continue;
                }
                if (n3 == 0) {
                    if (node.leftIndex == node.rightIndex) {
                        node2 = node.prev;
                        if (node2 == null) break;
                        n = node2.rightIndex - 1;
                        break;
                    }
                    node2 = node;
                    n = n4 - 1;
                    break;
                }
                node2 = node;
                n = n2;
                int n5 = n2 + 1;
                int n6 = 0;
                int n7 = n4 - 1;
                while (n5 <= n7) {
                    n6 = n5 + n7 >> 1;
                    n3 = ((TreeMap)this.m).cmp(comparable, k, KArray[n6]);
                    if (n3 > 0) {
                        node2 = node;
                        n = n6;
                        n5 = n6 + 1;
                        continue;
                    }
                    if (n3 == 0) {
                        node2 = node;
                        n = n6 - 1;
                        break block0;
                    }
                    n7 = n6 - 1;
                }
                break block0;
            }
            if (node2 != null && !this.checkLowerBound(node2.keys[n])) {
                node2 = null;
            }
            this.lastKeyNode = node2;
            this.lastKeyIndex = n;
        }

        private boolean checkLowerBound(K k) {
            if (!this.fromStart) {
                Comparator comparator = ((TreeMap)this.m).comparator;
                if (comparator != null) {
                    if (this.loInclusive) {
                        return comparator.compare(k, this.lo) >= 0;
                    }
                    return comparator.compare(k, this.lo) > 0;
                }
                if (this.loInclusive) {
                    return TreeMap.toComparable(k).compareTo(this.lo) >= 0;
                }
                return TreeMap.toComparable(k).compareTo(this.lo) > 0;
            }
            return true;
        }

        private boolean checkUpperBound(K k) {
            if (!this.toEnd) {
                Comparator comparator = ((TreeMap)this.m).comparator;
                if (comparator != null) {
                    if (this.hiInclusive) {
                        return comparator.compare(k, this.hi) <= 0;
                    }
                    return comparator.compare(k, this.hi) < 0;
                }
                if (this.hiInclusive) {
                    return TreeMap.toComparable(k).compareTo(this.hi) <= 0;
                }
                return TreeMap.toComparable(k).compareTo(this.hi) < 0;
            }
            return true;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.loKeyModCount = -1;
            this.hiKeyModCount = -1;
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int esvSize = -1;
            private transient int esvSizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.esvSize == -1 || this.esvSizeModCount != NavigableSubMap.this.m.modCount) {
                    this.esvSizeModCount = NavigableSubMap.this.m.modCount;
                    this.esvSize = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.esvSize;
                        iterator.next();
                    }
                }
                return this.esvSize;
            }

            @Override
            public boolean isEmpty() {
                Map.Entry entry = NavigableSubMap.this.absLowest();
                return entry == null || NavigableSubMap.this.tooHigh(entry.getKey());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!NavigableSubMap.this.inRange(k)) {
                    return false;
                }
                Map.Entry entry2 = NavigableSubMap.this.m.getEntry(k);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!NavigableSubMap.this.inRange(k)) {
                    return false;
                }
                Map.Entry entry2 = NavigableSubMap.this.m.getEntry(k);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    Object v = NavigableSubMap.this.m.remove(entry2.getKey());
                    return true;
                }
                return false;
            }
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;

        private SubMap() {
        }

        private Object readResolve() {
            return new AscendingSubMap(TreeMap.this, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new InternalError();
        }

        @Override
        public K lastKey() {
            throw new InternalError();
        }

        @Override
        public K firstKey() {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            throw new InternalError();
        }

        @Override
        public Comparator<? super K> comparator() {
            throw new InternalError();
        }
    }

    static class BoundedDescendingValueIterator<K, V>
    extends BoundedDescendingMapIterator<K, V>
    implements Iterator<V> {
        public BoundedDescendingValueIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(treeMap, node, n, node2, n2);
        }

        @Override
        public V next() {
            this.makeBoundedPrev();
            return this.lastNode.values[this.lastNode.leftIndex + this.lastOffset];
        }
    }

    static class BoundedDescendingEntryIterator<K, V>
    extends BoundedDescendingMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        public BoundedDescendingEntryIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(treeMap, node, n, node2, n2);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeBoundedPrev();
            int n = this.lastNode.leftIndex + this.lastOffset;
            TreeMap treeMap = this.backingMap;
            treeMap.getClass();
            Entry entry = treeMap.new Entry(this.lastNode, n);
            return TreeMap.exportEntry(entry);
        }
    }

    static class BoundedDescendingKeyIterator<K, V>
    extends BoundedDescendingMapIterator<K, V>
    implements Iterator<K> {
        public BoundedDescendingKeyIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(treeMap, node, n, node2, n2);
        }

        @Override
        public K next() {
            this.makeBoundedPrev();
            return this.lastNode.keys[this.lastNode.leftIndex + this.lastOffset];
        }
    }

    static class BoundedDescendingMapIterator<K, V>
    extends DescendingMapIterator<K, V> {
        final Node<K, V> finalNode;
        final int finalOffset;

        BoundedDescendingMapIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n, Node<K, V> node2, int n2) {
            super(treeMap, node2, n2);
            this.finalNode = node;
            this.finalOffset = n;
        }

        final void makeBoundedPrev() {
            this.makePrev();
            if (this.lastNode == this.finalNode && this.lastOffset == this.finalOffset) {
                this.node = null;
            }
        }
    }

    static class UnboundedDescendingEntryIterator<K, V>
    extends DescendingMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        UnboundedDescendingEntryIterator(TreeMap<K, V> treeMap) {
            super(treeMap, TreeMap.maximum(((TreeMap)treeMap).root));
        }

        UnboundedDescendingEntryIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makePrev();
            int n = this.lastNode.leftIndex + this.lastOffset;
            TreeMap treeMap = this.backingMap;
            treeMap.getClass();
            Entry entry = treeMap.new Entry(this.lastNode, n);
            return TreeMap.exportEntry(entry);
        }
    }

    static class UnboundedDescendingKeyIterator<K, V>
    extends DescendingMapIterator<K, V>
    implements Iterator<K> {
        UnboundedDescendingKeyIterator(TreeMap<K, V> treeMap) {
            super(treeMap, TreeMap.maximum(((TreeMap)treeMap).root));
        }

        UnboundedDescendingKeyIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        @Override
        public K next() {
            this.makePrev();
            return this.lastNode.keys[this.lastNode.leftIndex + this.lastOffset];
        }
    }

    static class DescendingMapIterator<K, V>
    extends AbstractMapIterator<K, V> {
        DescendingMapIterator(TreeMap<K, V> treeMap, Node<K, V> node) {
            super(treeMap, node);
        }

        DescendingMapIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        final void makePrev() {
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != 0) {
                --this.offset;
            } else {
                this.node = this.node.prev;
                if (this.node != null) {
                    this.offset = this.node.rightIndex - this.node.leftIndex;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void remove() {
            if (this.expectedModCount != this.backingMap.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            int n = this.lastNode.leftIndex + this.lastOffset;
            this.backingMap.removeFromIterator(this.lastNode, n);
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    static class BoundedValueIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<V> {
        public BoundedValueIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(node, n, treeMap, node2, n2);
        }

        @Override
        public V next() {
            this.makeBoundedNext();
            return this.lastNode.values[this.lastNode.rightIndex - this.lastOffset];
        }
    }

    static class BoundedKeyIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<K> {
        public BoundedKeyIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(node, n, treeMap, node2, n2);
        }

        @Override
        public K next() {
            this.makeBoundedNext();
            return this.lastNode.keys[this.lastNode.rightIndex - this.lastOffset];
        }
    }

    static class BoundedEntryIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        public BoundedEntryIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(node, n, treeMap, node2, n2);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeBoundedNext();
            int n = this.lastNode.rightIndex - this.lastOffset;
            TreeMap treeMap = this.backingMap;
            treeMap.getClass();
            Entry entry = treeMap.new Entry(this.lastNode, n);
            return TreeMap.exportEntry(entry);
        }
    }

    static class BoundedMapIterator<K, V>
    extends AbstractMapIterator<K, V> {
        final Node<K, V> finalNode;
        final int finalOffset;

        BoundedMapIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2, int n2) {
            super(treeMap, node2 == null ? null : node, n);
            this.finalNode = node2;
            this.finalOffset = n2;
        }

        BoundedMapIterator(Node<K, V> node, TreeMap<K, V> treeMap, Node<K, V> node2, int n) {
            this(node, node != null ? node.rightIndex - node.leftIndex : 0, treeMap, node2, n);
        }

        BoundedMapIterator(Node<K, V> node, int n, TreeMap<K, V> treeMap, Node<K, V> node2) {
            this(node, n, treeMap, node2, node2.rightIndex - node2.leftIndex);
        }

        void makeBoundedNext() {
            this.makeNext();
            if (this.lastNode == this.finalNode && this.lastOffset == this.finalOffset) {
                this.node = null;
            }
        }
    }

    static class UnboundedValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        UnboundedValueIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        UnboundedValueIterator(TreeMap<K, V> treeMap) {
            super(treeMap);
        }

        @Override
        public V next() {
            this.makeNext();
            return this.lastNode.values[this.lastNode.rightIndex - this.lastOffset];
        }
    }

    static class UnboundedKeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        UnboundedKeyIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        UnboundedKeyIterator(TreeMap<K, V> treeMap) {
            super(treeMap);
        }

        @Override
        public K next() {
            this.makeNext();
            return this.lastNode.keys[this.lastNode.rightIndex - this.lastOffset];
        }
    }

    static class UnboundedEntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        UnboundedEntryIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            super(treeMap, node, n);
        }

        UnboundedEntryIterator(TreeMap<K, V> treeMap) {
            super(treeMap);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            int n = this.lastNode.rightIndex - this.lastOffset;
            TreeMap treeMap = this.backingMap;
            treeMap.getClass();
            Entry entry = treeMap.new Entry(this.lastNode, n);
            return TreeMap.exportEntry(entry);
        }
    }

    static class AbstractMapIterator<K, V> {
        final TreeMap<K, V> backingMap;
        int expectedModCount;
        Node<K, V> node;
        Node<K, V> lastNode;
        int offset;
        int lastOffset;

        AbstractMapIterator(TreeMap<K, V> treeMap, Node<K, V> node, int n) {
            this.backingMap = treeMap;
            this.expectedModCount = ((TreeMap)treeMap).modCount;
            this.node = node;
            this.offset = n;
        }

        AbstractMapIterator(TreeMap<K, V> treeMap, Node<K, V> node) {
            this(treeMap, node, node != null ? node.rightIndex - node.leftIndex : 0);
        }

        AbstractMapIterator(TreeMap<K, V> treeMap) {
            this(treeMap, TreeMap.minimum(((TreeMap)treeMap).root));
        }

        public boolean hasNext() {
            return this.node != null;
        }

        final void makeNext() {
            if (this.expectedModCount != ((TreeMap)this.backingMap).modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != 0) {
                --this.offset;
            } else {
                this.node = this.node.next;
                if (this.node != null) {
                    this.offset = this.node.rightIndex - this.node.leftIndex;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            if (this.expectedModCount != ((TreeMap)this.backingMap).modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            int n = this.lastNode.rightIndex - this.lastOffset;
            ((TreeMap)this.backingMap).removeFromIterator(this.lastNode, n);
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    static class Node<K, V>
    implements Cloneable {
        static final int NODE_SIZE = 64;
        Node<K, V> prev;
        Node<K, V> next;
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        V[] values;
        K[] keys = new Object[64];
        int leftIndex = 0;
        int rightIndex = -1;
        int size = 0;
        boolean color;

        public Node() {
            this.values = new Object[64];
        }

        Node<K, V> clone(Node<K, V> node) throws CloneNotSupportedException {
            Node node2 = (Node)super.clone();
            node2.keys = new Object[64];
            node2.values = new Object[64];
            System.arraycopy(this.keys, 0, node2.keys, 0, this.keys.length);
            System.arraycopy(this.values, 0, node2.values, 0, this.values.length);
            node2.leftIndex = this.leftIndex;
            node2.rightIndex = this.rightIndex;
            node2.parent = node;
            if (this.left != null) {
                node2.left = this.left.clone(node2);
            }
            if (this.right != null) {
                node2.right = this.right.clone(node2);
            }
            node2.prev = null;
            node2.next = null;
            return node2;
        }
    }

    class Entry
    implements Map.Entry<K, V>,
    Cloneable {
        final int offset;
        final Node<K, V> node;
        final K key;

        Entry(Node<K, V> node, int n) {
            this.node = node;
            this.offset = n;
            this.key = node.keys[n];
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object v = this.getValue();
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (v == null ? entry.getValue() == null : v.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            if (this.node.keys[this.offset] == this.key) {
                return this.node.values[this.offset];
            }
            if (TreeMap.this.containsKey(this.key)) {
                return TreeMap.this.get(this.key);
            }
            throw new IllegalStateException();
        }

        @Override
        public int hashCode() {
            Object v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        @Override
        public V setValue(V v) {
            if (this.node.keys[this.offset] == this.key) {
                Object v2 = this.node.values[this.offset];
                this.node.values[this.offset] = v;
                return v2;
            }
            if (TreeMap.this.containsKey(this.key)) {
                return TreeMap.this.put(this.key, v);
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }
    }
}

