/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class VariableInitializer
extends AstNode {
    private AstNode target;
    private AstNode initializer;

    public void setNodeType(int n) {
        if (n != 122 && n != 154 && n != 153) {
            throw new IllegalArgumentException("invalid node type");
        }
        this.setType(n);
    }

    public VariableInitializer() {
        this.type = 122;
    }

    public VariableInitializer(int n) {
        super(n);
        this.type = 122;
    }

    public VariableInitializer(int n, int n2) {
        super(n, n2);
        this.type = 122;
    }

    public boolean isDestructuring() {
        return !(this.target instanceof Name);
    }

    public AstNode getTarget() {
        return this.target;
    }

    public void setTarget(AstNode astNode) {
        if (astNode == null) {
            throw new IllegalArgumentException("invalid target arg");
        }
        this.target = astNode;
        astNode.setParent(this);
    }

    public AstNode getInitializer() {
        return this.initializer;
    }

    public void setInitializer(AstNode astNode) {
        this.initializer = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.target.toSource(0));
        if (this.initializer != null) {
            stringBuilder.append(" = ");
            stringBuilder.append(this.initializer.toSource(0));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.target.visit(nodeVisitor);
            if (this.initializer != null) {
                this.initializer.visit(nodeVisitor);
            }
        }
    }
}

