/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.panel;

import javax.swing.event.EventListenerList;
import org.jfree.chart.event.OverlayChangeEvent;
import org.jfree.chart.event.OverlayChangeListener;

public class AbstractOverlay {
    private transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.add(OverlayChangeListener.class, listener);
    }

    public void removeChangeListener(OverlayChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.remove(OverlayChangeListener.class, listener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent event = new OverlayChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(OverlayChangeEvent event) {
        Object[] listeners = this.changeListeners.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == OverlayChangeListener.class) {
                ((OverlayChangeListener)listeners[i + 1]).overlayChanged(event);
            }
            i -= 2;
        }
    }
}

