/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.SlidingCategoryDataset;
import org.jfree.ui.RefineryUtilities;

public class SlidingCategoryDatasetDemo2
extends JFrame {
    public SlidingCategoryDatasetDemo2(String title) {
        super(title);
        this.setDefaultCloseOperation(3);
        this.setContentPane(SlidingCategoryDatasetDemo2.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new MyDemoPanel();
    }

    public static void main(String[] args) {
        SlidingCategoryDatasetDemo2 demo = new SlidingCategoryDatasetDemo2("JFreeChart: SlidingCategoryDatasetDemo2.java");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)demo);
        demo.setVisible(true);
    }

    static class MyDemoPanel
    extends JPanel
    implements ChangeListener {
        JScrollBar scroller;
        SlidingCategoryDataset dataset = new SlidingCategoryDataset(MyDemoPanel.createDataset(), 0, 10);

        public MyDemoPanel() {
            super(new BorderLayout());
            JFreeChart chart = MyDemoPanel.createChart(this.dataset);
            ChartPanel cp1 = new ChartPanel(chart);
            cp1.setPreferredSize(new Dimension(400, 400));
            this.scroller = new JScrollBar(0, 0, 10, 0, 50);
            this.add(cp1);
            this.scroller.getModel().addChangeListener(this);
            JPanel scrollPanel = new JPanel(new BorderLayout());
            scrollPanel.add(this.scroller);
            scrollPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            scrollPanel.setBackground(Color.white);
            this.add((Component)scrollPanel, "South");
        }

        private static CategoryDataset createDataset() {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int i = 0;
            while (i < 50) {
                dataset.addValue(Math.random() * 100.0, (Comparable)((Object)"S1"), (Comparable)((Object)("S" + i)));
                ++i;
            }
            return dataset;
        }

        private static JFreeChart createChart(CategoryDataset dataset) {
            JFreeChart chart = ChartFactory.createBarChart("SlidingCategoryDatasetDemo2", "Series", "Value", dataset, PlotOrientation.VERTICAL, false, true, false, true);
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setMaximumCategoryLabelWidthRatio(0.8f);
            domainAxis.setLowerMargin(0.02);
            domainAxis.setUpperMargin(0.02);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setRange(0.0, 100.0);
            BarRenderer renderer = (BarRenderer)plot.getRenderer();
            renderer.setDrawBarOutline(false);
            GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, new Color(0, 0, 64));
            renderer.setSeriesPaint(0, gp0);
            return chart;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.dataset.setFirstCategoryIndex(this.scroller.getValue());
        }
    }
}

