/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    private static final boolean debug = false;
    static Object Sync;
    Vector<CommPortOwnershipListener> ownershipListener;
    private boolean HideOwnerEvents;

    static {
        Sync = new Object();
        try {
            CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            RXTXDriver.initialize();
        }
        catch (Throwable e) {
            System.err.println(e + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        String OS = System.getProperty("os.name");
        if (OS.toLowerCase().indexOf("linux") == -1) {
            // empty if block
        }
        RXTXVersion.loadLibrary("rxtxSerial");
    }

    CommPortIdentifier(String pn, CommPort cp, int pt, CommDriver driver) {
        this.PortName = pn;
        this.commport = cp;
        this.PortType = pt;
        this.next = null;
        this.RXTXDriver = driver;
    }

    public static void addPortName(String s, int type, CommDriver c) {
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(s, null, type, c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AddIdentifierToList(CommPortIdentifier cpi) {
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = cpi;
            } else {
                CommPortIdentifier index = CommPortIndex;
                while (index.next != null) {
                    index = index.next;
                }
                index.next = cpi;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(c)) {
            this.ownershipListener.addElement(c);
        }
    }

    public String getCurrentOwner() {
        return this.Owner;
    }

    public String getName() {
        return this.PortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String s) throws NoSuchPortException {
        CommPortIdentifier index;
        Object object = Sync;
        synchronized (object) {
            index = CommPortIndex;
            while (index != null && !index.PortName.equals(s)) {
                index = index.next;
            }
            if (index == null) {
                CommPortIdentifier.getPortIdentifiers();
                index = CommPortIndex;
                while (index != null && !index.PortName.equals(s)) {
                    index = index.next;
                }
            }
        }
        if (index != null) {
            return index;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort p) throws NoSuchPortException {
        CommPortIdentifier c;
        Object object = Sync;
        synchronized (object) {
            c = CommPortIndex;
            while (c != null && c.commport != p) {
                c = c.next;
            }
        }
        if (c != null) {
            return c;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<CommPortIdentifier> getPortIdentifiers() {
        Object object = Sync;
        synchronized (object) {
            HashMap<String, CommPortIdentifier> oldPorts = new HashMap<String, CommPortIdentifier>();
            CommPortIdentifier p = CommPortIndex;
            while (p != null) {
                oldPorts.put(p.PortName, p);
                p = p.next;
            }
            CommPortIndex = null;
            try {
                CommDriver RXTXDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                RXTXDriver.initialize();
                CommPortIdentifier curPort = CommPortIndex;
                CommPortIdentifier prevPort = null;
                while (curPort != null) {
                    CommPortIdentifier matchingOldPort = (CommPortIdentifier)oldPorts.get(curPort.PortName);
                    if (matchingOldPort != null && matchingOldPort.PortType == curPort.PortType) {
                        matchingOldPort.RXTXDriver = curPort.RXTXDriver;
                        matchingOldPort.next = curPort.next;
                        if (prevPort == null) {
                            CommPortIndex = matchingOldPort;
                        } else {
                            prevPort.next = matchingOldPort;
                        }
                        prevPort = matchingOldPort;
                    } else {
                        prevPort = curPort;
                    }
                    curPort = curPort.next;
                }
            }
            catch (Throwable e) {
                System.err.println(e + " thrown while loading " + "gnu.io.RXTXCommDriver");
                System.err.flush();
            }
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.PortType;
    }

    public synchronized boolean isCurrentlyOwned() {
        return !this.Available;
    }

    public synchronized CommPort open(FileDescriptor f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    private native String native_psmisc_report_owner(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String TheOwner, int i) throws PortInUseException {
        String err_msg;
        block26: {
            CommPort commPort;
            block27: {
                CommPortIdentifier commPortIdentifier;
                boolean isAvailable;
                CommPortIdentifier commPortIdentifier2 = this;
                synchronized (commPortIdentifier2) {
                    isAvailable = this.Available;
                    if (isAvailable) {
                        this.Available = false;
                        this.Owner = TheOwner;
                    }
                }
                if (!isAvailable) {
                    long waitTimeEnd = System.currentTimeMillis() + (long)i;
                    this.fireOwnershipEvent(3);
                    commPortIdentifier = this;
                    synchronized (commPortIdentifier) {
                        long waitTimeCurr;
                        while (!this.Available && (waitTimeCurr = System.currentTimeMillis()) < waitTimeEnd) {
                            try {
                                this.wait(waitTimeEnd - waitTimeCurr);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                        isAvailable = this.Available;
                        if (isAvailable) {
                            this.Available = false;
                            this.Owner = TheOwner;
                        }
                    }
                }
                if (!isAvailable) {
                    throw new PortInUseException(this.getCurrentOwner());
                }
                try {
                    if (this.commport == null) {
                        this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
                    }
                    if (this.commport == null) break block26;
                    this.fireOwnershipEvent(1);
                    commPort = this.commport;
                    if (this.commport != null) break block27;
                    commPortIdentifier = this;
                }
                catch (Throwable throwable) {
                    if (this.commport == null) {
                        commPortIdentifier = this;
                        synchronized (commPortIdentifier) {
                            this.Available = true;
                            this.Owner = null;
                        }
                    }
                    throw throwable;
                }
                synchronized (commPortIdentifier) {
                    this.Available = true;
                    this.Owner = null;
                }
            }
            return commPort;
        }
        try {
            err_msg = this.native_psmisc_report_owner(this.PortName);
        }
        catch (Throwable t) {
            err_msg = "Port " + this.PortName + " already owned... unable to open.";
        }
        throw new PortInUseException(err_msg);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClosePort() {
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            this.Owner = null;
            this.Available = true;
            this.commport = null;
            this.notifyAll();
        }
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        if (this.ownershipListener != null) {
            Enumeration<CommPortOwnershipListener> e = this.ownershipListener.elements();
            while (e.hasMoreElements()) {
                CommPortOwnershipListener c = e.nextElement();
                c.ownershipChange(eventType);
            }
        }
    }
}

