/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.StringHelper;

public class EJB3NamingStrategy
implements NamingStrategy,
Serializable {
    public static final NamingStrategy INSTANCE = new EJB3NamingStrategy();

    public String classToTableName(String className) {
        return StringHelper.unqualify((String)className);
    }

    public String propertyToColumnName(String propertyName) {
        return StringHelper.unqualify((String)propertyName);
    }

    public String tableName(String tableName) {
        return tableName;
    }

    public String columnName(String columnName) {
        return columnName;
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.tableName(ownerEntityTable + "_" + (associatedEntityTable != null ? associatedEntityTable : StringHelper.unqualify((String)propertyName)));
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.columnName(joinedColumn);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = propertyName != null ? StringHelper.unqualify((String)propertyName) : propertyTableName;
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        return this.columnName(String.valueOf(header) + "_" + referencedColumnName);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName);
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return new StringBuffer(ownerEntityTable).append("_").append(associatedEntityTable != null ? associatedEntityTable : StringHelper.unqualify((String)propertyName)).toString();
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return StringHelper.isNotEmpty((String)columnName) ? columnName : String.valueOf(StringHelper.unqualify((String)propertyName)) + "_" + referencedColumn;
    }
}

