/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.reset;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.components.ProgressDialog;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.reset.localization.Messages;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class Reset
extends Plugin
implements ActionListener,
IBAPFinder.IBAPListener {
    public static final int COMMAND_RESET = 1;
    public static final int COMMAND_RESET_FACTORY = 4;
    public static final int MESSAGE_COMMAND = 1;
    private IBAPFinder api;
    private JButton buttonReset;
    private IBAPFinder.IBAP bap;
    private String mac;
    private ProgressDialog<Void, Integer> progressDialog;

    @Override
    public void initialize(IBAPFinder api) throws PluginException {
        if (api == null) {
            throw new PluginException("ResetPlugin: API == null");
        }
        this.api = api;
        this.buttonReset = new JButton();
        this.buttonReset.setPreferredSize(new Dimension(100, 25));
        this.buttonReset.setEnabled(false);
        this.buttonReset.setFont(new Font("Tahoma", 0, 11));
        this.buttonReset.setText(Messages.getString("Reset.1"));
        this.buttonReset.setActionCommand("reset");
        this.buttonReset.addActionListener(this);
        api.addButton(this.buttonReset);
    }

    @Override
    public String getName() {
        return "Reset";
    }

    @Override
    public void selectedBAPChanged(IBAPFinder.IBAP bap) {
        if (bap == null || !bap.isOnline() || !bap.hasCommand(1L) && !bap.hasCommand(4L)) {
            this.buttonReset.setEnabled(false);
        } else {
            this.buttonReset.setEnabled(true);
        }
    }

    @Override
    public PluginVersion getVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public PluginVersion neededAPIVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean factoryReset;
        int result = -1;
        if (this.api.getSelectedBAP().hasCommand(4L)) {
            Object[] options = new String[]{Messages.getString("Reset.0"), Messages.getString("Reset.1")};
            result = JOptionPane.showOptionDialog(this.api.getWindow(), Messages.getString("Reset.2"), Messages.getString("Reset.1"), -1, 3, null, options, options[0]);
            if (result == -1) {
                return;
            }
        } else {
            result = 0;
        }
        if (result == 1) {
            result = JOptionPane.showConfirmDialog(this.api.getWindow(), Messages.getString("Reset.4"), Messages.getString("Reset.1"), 0, 3);
            if (result != 0) return;
            factoryReset = true;
        } else {
            if (!this.api.getSelectedBAP().hasCommand(1L)) {
                return;
            }
            factoryReset = false;
        }
        SwingWorker<Void, Integer> task = new SwingWorker<Void, Integer>(){

            @Override
            protected Void doInBackground() {
                Reset.this.bap = Reset.this.api.getSelectedBAP();
                Reset.this.mac = Reset.this.bap.getMac();
                Reset.this.api.addBAPListener(Reset.this);
                RandomArrayStream stream = new RandomArrayStream();
                try {
                    try {
                        this.firePropertyChange("progressInfo", null, Messages.getString("Reset.7"));
                        this.firePropertyChange("indeterminate", null, true);
                        stream.seek(0);
                        stream.trim();
                        stream.writeInt(factoryReset ? 4 : 1);
                        IBAPFinder.IMessage message = Reset.this.api.sendToConfigPort(Reset.this.bap, 1, stream);
                        if (message.getMessageType() != 2) {
                            throw new PluginException(1);
                        }
                        Reset.this.api.removeBAP(Reset.this.mac);
                        Reset.this.bap = null;
                        long starttime = System.currentTimeMillis();
                        while (Reset.this.bap == null && starttime + 120000L > System.currentTimeMillis()) {
                            Thread.sleep(10L);
                        }
                        if (Reset.this.bap == null) {
                            throw new PluginException(2);
                        }
                    }
                    catch (Exception e) {
                        this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                        Reset.this.processError(e);
                        Reset.this.api.removeBAPListener(Reset.this);
                        return null;
                    }
                }
                finally {
                    Reset.this.api.removeBAPListener(Reset.this);
                }
                this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                Reset.this.processSuccess();
                return null;
            }
        };
        this.progressDialog = new ProgressDialog<Void, Integer>(this.api.getWindow(), Messages.getString("Reset.1"), task, false);
        this.progressDialog.setImage(this.loadImage("reset.png"));
        task.execute();
    }

    private void processSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void processError(final Exception e) {
        e.printStackTrace();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e instanceof PluginException) {
                    PluginException pluginException = (PluginException)e;
                    int errorcode = pluginException.getErrorcode();
                    if (errorcode == 1) {
                        JOptionPane.showMessageDialog(Reset.this.api.getWindow(), Messages.getString("Reset.15"), Messages.getString("Reset.1"), 0);
                    } else if (errorcode == 2) {
                        JOptionPane.showMessageDialog(Reset.this.api.getWindow(), Messages.getString("Reset.17"), Messages.getString("Reset.1"), 0);
                    } else {
                        JOptionPane.showMessageDialog(Reset.this.api.getWindow(), Messages.getString("Reset.19"), Messages.getString("Reset.1"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(Reset.this.api.getWindow(), String.valueOf(Messages.getString("Reset.21")) + Tools.getStackTrace(e), Messages.getString("Reset.1"), 0);
                }
            }
        });
    }

    @Override
    public void bapReceived(IBAPFinder.IBAP bap) {
        if (this.bap != null || !bap.getMac().equals(this.mac)) {
            return;
        }
        this.bap = bap;
    }
}

