/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.components;

import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.localization.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ProgressDialog<T, V>
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 4904913850014784350L;
    private SwingWorker<T, V> task;
    private JProgressBar progressBar;
    private JWizardHeader wizardHeader;
    private int max = 100;

    public ProgressDialog() {
        this(null, null, null, false);
    }

    public ProgressDialog(SwingWorker<T, V> task) {
        this(null, null, task, false);
    }

    public ProgressDialog(Window owner) {
        this(owner, null, null, false);
    }

    public ProgressDialog(Window owner, SwingWorker<T, V> task, boolean cancelable) {
        this(owner, null, task, cancelable);
    }

    public ProgressDialog(Window owner, String title, SwingWorker<T, V> task, boolean cancelable) {
        super(owner);
        this.setUndecorated(true);
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(320, 60));
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setLocationByPlatform(true);
        this.task = task;
        if (task != null) {
            this.task.addPropertyChangeListener(this);
        }
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        this.wizardHeader = new JWizardHeader();
        this.wizardHeader.setTextHeader1(title);
        this.wizardHeader.setTextHeader2(null);
        this.progressBar = new JProgressBar(0, this.max);
        this.progressBar.setStringPainted(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JPanel barPanel = new JPanel();
        barPanel.setBorder(BorderFactory.createEtchedBorder(1));
        barPanel.setLayout(new GridBagLayout());
        barPanel.add((Component)this.progressBar, gridBagConstraints);
        GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
        constraintsWizardHeader.anchor = 11;
        constraintsWizardHeader.gridx = 0;
        constraintsWizardHeader.gridy = 0;
        constraintsWizardHeader.weighty = 0.0;
        constraintsWizardHeader.weightx = 1.0;
        constraintsWizardHeader.fill = 2;
        GridBagConstraints constraintsBarPanel = new GridBagConstraints();
        constraintsBarPanel.anchor = 11;
        constraintsBarPanel.gridx = 0;
        constraintsBarPanel.gridy = 1;
        constraintsBarPanel.weighty = 0.0;
        constraintsBarPanel.weightx = 1.0;
        constraintsBarPanel.fill = 2;
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEtchedBorder(0));
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)this.wizardHeader, constraintsWizardHeader);
        contentPane.add((Component)barPanel, constraintsBarPanel);
        if (cancelable) {
            JButton buttonCancel = new JButton();
            buttonCancel.setText(Messages.getString("ProgressDialog.0"));
            buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressDialog.this.task == null) {
                        return;
                    }
                    ProgressDialog.this.task.cancel(false);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEtchedBorder(1));
            buttonPanel.setLayout(new BorderLayout());
            buttonPanel.add((Component)buttonCancel, "Center");
            GridBagConstraints constraintsButtonPanel = new GridBagConstraints();
            constraintsButtonPanel.anchor = 11;
            constraintsButtonPanel.gridx = 0;
            constraintsButtonPanel.gridy = 2;
            constraintsButtonPanel.weighty = 0.0;
            constraintsButtonPanel.weightx = 1.0;
            constraintsButtonPanel.fill = 2;
            contentPane.add((Component)buttonPanel, constraintsButtonPanel);
        }
        this.setContentPane(contentPane);
        this.pack();
    }

    public void setMax(int max) {
        this.max = max;
        this.progressBar.setMaximum(max);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    public void setInfo(String info) {
        this.wizardHeader.setTextHeader2(info);
    }

    public void setState(int state) {
        if (state <= this.max) {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue(state);
        } else {
            this.progressBar.setIndeterminate(true);
        }
    }

    public void setImage(Image image) {
        this.wizardHeader.setImage(image);
    }

    public void disposeDialog() {
        this.progressBar.setIndeterminate(false);
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property == null) {
            return;
        }
        if (property.equals("state")) {
            SwingWorker.StateValue value = (SwingWorker.StateValue)((Object)evt.getNewValue());
            if (value == SwingWorker.StateValue.STARTED) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressDialog.this.setVisible(true);
                    }
                });
            } else if (value == SwingWorker.StateValue.DONE) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressDialog.this.disposeDialog();
                    }
                });
            }
        } else if (property.equals("progress")) {
            int value = (Integer)evt.getNewValue();
            this.setState(value);
        } else if (property.equals("progressMax")) {
            int value = (Integer)evt.getNewValue();
            this.setMax(value);
        } else if (property.equals("progressInfo")) {
            String info = (String)evt.getNewValue();
            this.setInfo(info);
        } else if (property.equals("indeterminate")) {
            Boolean indeterminate = (Boolean)evt.getNewValue();
            this.setIndeterminate(indeterminate);
        }
    }
}

