/*
 * Decompiled with CFR 0.152.
 */
import com.wibu.cm.CodeMeter;
import com.wibu.cm.CodeMeterAct;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CMReg
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static long hcmse = 0L;
    private static long firmCode = 0x4C4B4CL;
    private static int productCode = 1;
    private static CMReg cmr = null;
    private static boolean registerOK = true;
    private static Vector<File> fileVector = new Vector();
    private static Vector<String> messageVector = new Vector();
    private static boolean foundVM = false;

    public CMReg() {
        super("");
        try {
            if (!CMReg.getINIData()) {
                JOptionPane.showMessageDialog(null, "Error reading config file!\nAborting...", "Configuration ERROR", 0);
                System.exit(0);
            }
            this.initialize();
            this.pack();
            this.setMinimumSize(this.getSize());
        }
        catch (Exception exception) {
            System.exit(0);
        }
    }

    private void initialize() {
        try {
            cmr = this;
            this.setIconImage(ImageLoader.loadImageResource("CmReg.png"));
            this.setTitle("CmReg");
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.add(new JLabel("<HTML><PRE><I><BR><BR>        ... registering license ...        <BR><BR></PRE></I></HTML>"));
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                }
            });
        }
        catch (Exception exception) {
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Throwable {
        block18: {
            try {
                new CMReg();
                if (CMReg.accessCmActForCheck(firmCode, productCode)) {
                    CMReg.releaseCm();
                    cmr.setVisible(false);
                    JOptionPane.showMessageDialog(null, "Existing License found!\nRegistration aborted.", "WARNING", 2);
                    System.exit(0);
                    break block18;
                }
                if (CMReg.accessCmActForRegister()) {
                    CodeMeterAct cmAct = new CodeMeterAct();
                    if (fileVector.size() == 0) {
                        JOptionPane.showMessageDialog(null, "No License found!", "License Error", 0);
                        System.exit(0);
                    } else {
                        try {
                            int i = 0;
                            while (i < fileVector.size()) {
                                File pFile = fileVector.get(i);
                                byte[] wibuCmRaUData = new byte[(int)pFile.length()];
                                FileInputStream in = new FileInputStream(pFile);
                                ((InputStream)in).read(wibuCmRaUData);
                                if (!cmAct.cmActLicenseControl(hcmse, 21L, wibuCmRaUData)) {
                                    registerOK = false;
                                    messageVector.add(new String("\n" + CodeMeter.cmGetLastErrorText()));
                                    if (CodeMeter.cmGetLastErrorCode() == 254) {
                                        foundVM = true;
                                    }
                                } else {
                                    messageVector.add(null);
                                }
                                ((InputStream)in).close();
                                Thread.sleep(3000L);
                                ++i;
                            }
                        }
                        catch (Exception exception) {
                            System.exit(0);
                        }
                    }
                    CMReg.releaseCm();
                    if (registerOK) {
                        System.exit(0);
                    } else {
                        cmr.setVisible(false);
                        String message = "License registration failed!";
                        if (foundVM) {
                            message = String.valueOf(message) + "\nVirtual Machines not supported!";
                        } else {
                            int i = 0;
                            while (i < messageVector.size()) {
                                String eMsg = messageVector.get(i);
                                if (eMsg != null) {
                                    message = String.valueOf(message) + eMsg;
                                }
                                ++i;
                            }
                        }
                        JOptionPane.showMessageDialog(null, message, "License Error", 0);
                        System.exit(0);
                    }
                    break block18;
                }
                cmr.setVisible(false);
                JOptionPane.showMessageDialog(null, "Error accessing CodeMeter!\nPlease check your CodeMeter installation.", "CodeMeter Error", 0);
                System.exit(0);
            }
            catch (Exception exception) {
                System.exit(0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean accessCmActForCheck(long firmCode, long productCode) {
        CodeMeter.CMACCESS cmacc = new CodeMeter.CMACCESS();
        cmacc.ctrl = 65792L;
        cmacc.firmCode = firmCode;
        cmacc.productCode = productCode;
        try {
            int i = 0;
            while (i < 4) {
                Thread.sleep(5000L);
                hcmse = CodeMeter.cmAccess((long)0L, (CodeMeter.CMACCESS)cmacc);
                if (hcmse != 0L) {
                    return true;
                }
                if (CodeMeter.cmGetLastErrorCode() != 126) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
        cmr.setVisible(false);
        String message = "CodeMeter Service not found!\nPlease install CodeMeter.";
        JOptionPane.showMessageDialog(null, message, "Service Error", 0);
        System.exit(0);
        return false;
    }

    private static void releaseCm() {
        try {
            if (hcmse != 0L) {
                CodeMeter.cmRelease((long)hcmse);
                hcmse = 0L;
            }
        }
        catch (Exception exception) {
            System.exit(0);
        }
    }

    public static boolean accessCmActForRegister() {
        try {
            CodeMeter.CMACCESS cmacc = new CodeMeter.CMACCESS();
            cmacc.ctrl = 524288L;
            cmacc.firmCode = 0L;
            hcmse = CodeMeter.cmAccess((long)0L, (CodeMeter.CMACCESS)cmacc);
            return hcmse != 0L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean getINIData() {
        try {
            RandomAccessFile iniFile = new RandomAccessFile("config/CmReg.cfg", "r");
            try {
                firmCode = Long.parseLong(iniFile.readLine());
                productCode = Integer.parseInt(iniFile.readLine());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error reading configuration ile!\nAborting...", "Configuration ERROR", 0);
                System.exit(0);
            }
            String fileName = iniFile.readLine();
            while (fileName != null) {
                File f = new File(fileName);
                if (f != null && f.exists()) {
                    fileVector.add(f);
                }
                fileName = iniFile.readLine();
            }
            iniFile.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

