/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.apple.eio.FileManager;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.association.utility.MacOSXBundleUtil;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.MacOSXShortcutUtil;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.JOptionPane;

public class MacOSXLocalInstallHandler
extends LocalInstallHandler {
    private static final String BUNDLE_PATH_KEY = "macosx.bundlePath";
    private static final String ALIAS_PATH_KEY = "macosx.aliasPath";
    private static final String BUNDLES_FOLDER = "bundles";
    private static final String DEFAULT_DOC_ICON_PATH = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/GenericDocumentIcon.icns";
    private static final int VISIBLE_BUNDLE = 1;
    private static final int HIDDEN_BUNDLE = 2;
    private static final String ACTION_COMMAND = "command";
    private static final int NSApplicationDirectory = 1;
    private static final int NSDesktopDirectory = 12;
    private static final int NSUserDomainMask = 1;
    private static final int NSLocalDomainMask = 2;

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        return localApplicationProperties.isShortcutInstalled() && MacOSXLocalInstallHandler.getBundleFileFromLAP(localApplicationProperties) != null;
    }

    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        return new boolean[]{this.isShortcutExists(localApplicationProperties), false};
    }

    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        File file = MacOSXLocalInstallHandler.getBundleFile(launchDesc);
        AssociationService associationService = new AssociationService(localApplicationProperties);
        List list = associationService.getAssociations();
        File file2 = MacOSXLocalInstallHandler.getBundleFileFromLAP(localApplicationProperties);
        if (file2 != null && this.getBundleType(localApplicationProperties) == 2) {
            this.removeBundle(launchDesc, localApplicationProperties, file2, 2);
        }
        return this.createBundle(launchDesc, localApplicationProperties, file, 1, list);
    }

    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        boolean bl2 = true;
        if (this.isShortcutExists(localApplicationProperties)) {
            AssociationService associationService = new AssociationService(localApplicationProperties);
            List list = associationService.getAssociations();
            File file = new File(localApplicationProperties.get(BUNDLE_PATH_KEY));
            bl2 = this.removeBundle(launchDesc, localApplicationProperties, file, 1);
            if (list.size() > 0) {
                bl2 = this.createBundle(launchDesc, localApplicationProperties, file, 2, list);
            }
        }
        return bl2;
    }

    public boolean isAssociationSupported() {
        return true;
    }

    protected boolean isAssociationFileExtSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = AppUtility.removeDotFromFileExtension((String)string.toLowerCase());
        return !string2.equals("app");
    }

    public String getAssociationOpenCommand(String string) {
        return ACTION_COMMAND;
    }

    public String getAssociationPrintCommand(String string) {
        return ACTION_COMMAND;
    }

    public boolean hasAssociation(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        return associationService.hasAssociation(association);
    }

    public void registerAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        boolean bl;
        boolean bl2;
        Trace.println((String)("Register association=\n" + association), (TraceLevel)TraceLevel.TEMP);
        AssociationService associationService = new AssociationService(localApplicationProperties);
        List list = associationService.getAssociations();
        if (this.hasAssociation(launchDesc, localApplicationProperties, association)) {
            throw new AssociationAlreadyRegisteredException();
        }
        list.add(association);
        File file = MacOSXLocalInstallHandler.getBundleFileFromLAP(localApplicationProperties);
        if (file != null ? !(bl2 = this.createBundle(launchDesc, localApplicationProperties, file, this.getBundleType(localApplicationProperties), list)) : !(bl = this.createBundle(launchDesc, localApplicationProperties, file = MacOSXLocalInstallHandler.getBundleFile(launchDesc), 2, list))) {
            throw new RegisterFailedException();
        }
    }

    public void unregisterAssociationInternal(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        boolean bl;
        boolean bl2;
        Trace.println((String)("Unregister association=\n" + association), (TraceLevel)TraceLevel.TEMP);
        AssociationService associationService = new AssociationService(localApplicationProperties);
        List list = associationService.getAssociations();
        boolean bl3 = false;
        for (int i = 0; i < list.size(); ++i) {
            Association association2 = (Association)list.get(i);
            if (!MacOSXBundleUtil.compareAssociations((Association)association, (Association)association2)) continue;
            bl3 = true;
            list.remove(association2);
            break;
        }
        if (!bl3) {
            throw new AssociationNotRegisteredException();
        }
        File file = MacOSXLocalInstallHandler.getBundleFileFromLAP(localApplicationProperties);
        if (file == null) {
            throw new RegisterFailedException();
        }
        if (this.getBundleType(localApplicationProperties) == 2 && list.size() == 0 ? !(bl2 = this.removeBundle(launchDesc, localApplicationProperties, file, 2)) : !(bl = this.createBundle(launchDesc, localApplicationProperties, file, this.getBundleType(localApplicationProperties), list))) {
            throw new RegisterFailedException();
        }
    }

    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
    }

    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    private static void createAlias(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, File file) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string = informationDesc.getTitle();
        boolean bl = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        String string2 = null;
        if (bl) {
            String string3 = MacOSXBundleUtil.getStandardDirectory((int)12, (int)1);
            string2 = string3 + File.separator + string;
        } else {
            String string4 = MacOSXBundleUtil.getStandardDirectory((int)1, (int)2);
            string2 = string4 + File.separator + string;
        }
        if (!MacOSXBundleUtil.createAlias((String)file.getAbsolutePath(), (String)string2)) {
            Trace.println((String)("Unable to create alias; path == " + string2), (TraceLevel)TraceLevel.TEMP);
        } else {
            localApplicationProperties.put(ALIAS_PATH_KEY, string2);
            MacOSXLocalInstallHandler.save(localApplicationProperties);
        }
    }

    private static void removeAlias(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(ALIAS_PATH_KEY);
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                MacOSXLocalInstallHandler.deleteFiles(file);
            }
            localApplicationProperties.put(ALIAS_PATH_KEY, null);
            MacOSXLocalInstallHandler.save(localApplicationProperties);
        }
    }

    protected boolean removePathShortcut(String string) {
        File file = new File(string);
        MacOSXLocalInstallHandler.deleteFiles(file);
        return true;
    }

    public String getDefaultIconPath() {
        return DEFAULT_DOC_ICON_PATH;
    }

    private boolean createBundle(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, File file, int n, List list) {
        Trace.println((String)("Create bundle=" + file), (TraceLevel)TraceLevel.TEMP);
        if (file.exists()) {
            boolean bl = false;
            try {
                bl = FileManager.moveToTrash((File)file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Trace.ignoredException((Exception)fileNotFoundException);
            }
            if (!bl) {
                Trace.println((String)("Unable to delete existing bundle=" + file), (TraceLevel)TraceLevel.TEMP);
                if (n == 1) {
                    this.showReplaceWarningDialog(file.getName());
                }
                return false;
            }
        }
        try {
            MacOSXShortcutUtil.createBundle(launchDesc, localApplicationProperties, file, list);
            localApplicationProperties.put(BUNDLE_PATH_KEY, file.getAbsolutePath());
            if (n == 1) {
                localApplicationProperties.setShortcutInstalled(true);
            }
            MacOSXLocalInstallHandler.save(localApplicationProperties);
            if (n == 1) {
                MacOSXLocalInstallHandler.createAlias(launchDesc, localApplicationProperties, file);
            }
            return true;
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
            if (n == 1) {
                this.showInstallWarningDialog(launchDesc);
            }
            return false;
        }
    }

    private boolean removeBundle(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, File file, int n) {
        Trace.println((String)("Remove bundle=" + file), (TraceLevel)TraceLevel.TEMP);
        MacOSXLocalInstallHandler.deleteFiles(file);
        MacOSXLocalInstallHandler.removeAlias(localApplicationProperties);
        localApplicationProperties.put(BUNDLE_PATH_KEY, null);
        if (n == 1) {
            localApplicationProperties.setShortcutInstalled(false);
        }
        MacOSXLocalInstallHandler.save(localApplicationProperties);
        return true;
    }

    private void showInstallWarningDialog(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, ResourceManager.getString((String)"install.installFailed", (String)launchDesc.getInformation().getTitle()), ResourceManager.getString((String)"install.installFailedTitle"), 2);
            }
        };
        MacOSXLocalInstallHandler.invokeRunnable(runnable);
    }

    private void showReplaceWarningDialog(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, "failed to remove old shortcut " + string, "warning", 2);
            }
        };
        MacOSXLocalInstallHandler.invokeRunnable(runnable);
    }

    private static void deleteFiles(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                MacOSXLocalInstallHandler.deleteFiles(fileArray[i]);
            }
        }
        file.delete();
    }

    private int getBundleType(LocalApplicationProperties localApplicationProperties) {
        return localApplicationProperties.isShortcutInstalled() ? 1 : 2;
    }

    private static File getBundleFileFromLAP(LocalApplicationProperties localApplicationProperties) {
        File file;
        String string = localApplicationProperties.get(BUNDLE_PATH_KEY);
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File getBundleFile(LaunchDesc launchDesc) {
        File file = ResourceProvider.get().getCacheDir();
        File file2 = new File(file, BUNDLES_FOLDER);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return new File(file2, launchDesc.getInformation().getTitle() + ".app");
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

