/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogTarget;
import org.jfree.util.PrintStreamLogTarget;

public class TimeSeriesDemo
extends ApplicationFrame {
    public TimeSeriesDemo(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        XYPlot plot = chart.getXYPlot();
        ValueAxis valueAxis = plot.getDomainAxis();
        Range range = valueAxis.getDefaultAutoRange();
        System.out.println("range " + range.toString());
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Legal & General Unit Trust Prices", "Date", "Price Per Unit", dataset, true, true, false, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setShapesFilled(true);
            rr.setItemLabelsVisible(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("MMM-yyyy"));
        return chart;
    }

    private XYDataset createDataset() {
        TimeSeries s1 = new TimeSeries((Comparable)((Object)"L&G European Index Trust"), Month.class);
        s1.add((RegularTimePeriod)new Month(2, 2001), 80.0);
        s1.add((RegularTimePeriod)new Month(3, 2001), 112.0);
        s1.add((RegularTimePeriod)new Month(4, 2001), 16.0);
        s1.add((RegularTimePeriod)new Month(5, 2001), 48.0);
        s1.add((RegularTimePeriod)new Month(6, 2001), 80.0);
        s1.add((RegularTimePeriod)new Month(7, 2001), 48.0);
        s1.add((RegularTimePeriod)new Month(8, 2001), 16.0);
        s1.add((RegularTimePeriod)new Month(9, 2001), 80.0);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.setDomainIsPointsInTime(true);
        return dataset;
    }

    public static void main(String[] args) {
        Log.getInstance().addTarget((LogTarget)new PrintStreamLogTarget());
        TimeSeriesDemo demo = new TimeSeriesDemo("Time Series Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

