/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.Dimension;
import java.awt.Window;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class StackedBarChart3DDemo
extends ApplicationFrame {
    public StackedBarChart3DDemo(String title) {
        super(title);
        CategoryDataset dataset = this.createCategoryDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static IntervalCategoryDataset createDataset() {
        TaskSeries s1 = new TaskSeries("Offen");
        TaskSeries s2 = new TaskSeries("Geschlossen");
        TaskSeriesCollection collection = new TaskSeriesCollection();
        Task offen = new Task("offen", new SimpleTimePeriod(StackedBarChart3DDemo.date(1, 3, 2001), StackedBarChart3DDemo.date(3, 3, 2001)));
        Task sub1 = new Task("sub1", new SimpleTimePeriod(StackedBarChart3DDemo.date(3, 3, 2001), StackedBarChart3DDemo.date(5, 3, 2001)));
        Task sub2 = new Task("sub2", new SimpleTimePeriod(StackedBarChart3DDemo.date(5, 3, 2001), StackedBarChart3DDemo.date(8, 3, 2001)));
        offen.addSubtask(sub1);
        offen.addSubtask(sub2);
        System.out.println("offen==> " + offen.getSubtaskCount());
        s1.add(offen);
        collection.add(s1);
        return collection;
    }

    private CategoryDataset createCategoryDataset() {
        DefaultCategoryDataset dataset1 = new DefaultCategoryDataset();
        dataset1.addValue(1.0, (Comparable)((Object)"gekippt"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(4.0, (Comparable)((Object)"offen"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(6.0, (Comparable)((Object)"geschlossen"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(8.0, (Comparable)((Object)"offen"), (Comparable)((Object)"Category 1"));
        dataset1.addValue(9.0, (Comparable)((Object)"geschlossen"), (Comparable)((Object)"Category 1"));
        return dataset1;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedBarChart3D("Stacked Bar Chart 3D Demo", "Category", "Value", dataset, PlotOrientation.HORIZONTAL, true, true, false, true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setItemLabelsVisible(true);
        renderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        renderer.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        return chart;
    }

    public static void main(String[] args) {
        StackedBarChart3DDemo demo = new StackedBarChart3DDemo("Stacked Bar Chart 3D Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }
}

