/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.bierconfig;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.bierconfig.BierConfiguratorDialog;
import de.bsc.bapfinder.plugins.bierconfig.localization.Messages;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class BierConfigurator
extends Plugin
implements ActionListener {
    private JButton buttonConfig;
    IBAPFinder api;

    @Override
    public void initialize(IBAPFinder api) throws PluginException {
        if (api == null) {
            throw new PluginException("BierConfiguratorPlugin: API == null");
        }
        this.api = api;
        this.buttonConfig = new JButton();
        this.buttonConfig.setPreferredSize(new Dimension(120, 25));
        this.buttonConfig.setEnabled(false);
        this.buttonConfig.setFont(new Font("Tahoma", 0, 11));
        this.buttonConfig.setText(Messages.getString("BierConfigurator.2"));
        this.buttonConfig.setActionCommand("config");
        this.buttonConfig.addActionListener(this);
        api.addButton(this.buttonConfig);
    }

    @Override
    public String getName() {
        return "Bier configurator";
    }

    @Override
    public void selectedBAPChanged(IBAPFinder.IBAP bap) {
        if (!(bap != null && bap.hasFeature(16384L) && bap.hasFeature(256L) && bap.isOnline())) {
            this.buttonConfig.setEnabled(false);
        } else {
            this.buttonConfig.setEnabled(true);
        }
    }

    @Override
    public PluginVersion getVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public PluginVersion neededAPIVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new BierConfiguratorDialog(this);
    }
}

