/*
 * Decompiled with CFR 0.152.
 */
package bsc_visualisierung;

import bsc_main.BIERKonfigurator;
import bsc_main.ConnectToBIER;
import bsc_main.NeuesObjekt;
import bsc_main.ObjectVectorClass;
import bsc_main.RoutingObject;
import bsc_visualisierung.TableModel_NeueObjekte;
import bsc_visualisierung.TableModel_RoutingTabelle;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RoutingTableZuweisung
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4274734997572015083L;
    private static Object[][] daten_routing;
    private static String[] ueberschrift_routing;
    private static Object[][] daten_objekte;
    private static String[] ueberschrift_objekte;
    private static JTable table_routing;
    private static JTable table_objekte;
    private static JScrollPane scroll_routing;
    private static JScrollPane scroll_objekte;
    private static TableModel_RoutingTabelle model_routing;
    private static TableModel_NeueObjekte model_objekte;
    private JButton hinzufuegen;
    private JButton entfernen;
    private JButton beenden;
    private static JButton anlernen;
    private static RoutingObject routingObjekt;
    private static NeuesObjekt newObject;
    private static Vector<RoutingObject> routingObjectVector;
    private static Vector<NeuesObjekt> newObjectVector;
    private static int anzahlRoutingObjekte;
    private static int anzahlNeueObjekte;
    private static int tempEintrag;
    private static String anlern_bierid;
    private static String anlern_typ;
    private static Typ[] typ;

    public RoutingTableZuweisung(Frame parent, Rectangle argRect) {
        super(parent, "Zuweisung Objekte zur Routing-Tabelle", true);
        int i;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RoutingTableZuweisung.this.dispose();
                RoutingTableZuweisung.this.setVisible(false);
            }
        });
        this.setLayout(null);
        this.setResizable(false);
        typ = new Typ[]{new Typ("Griff"), new Typ("Schalter"), new Typ("Schalter"), new Typ("Reedkontakt"), new Typ("Sensor")};
        this.hinzufuegen = new JButton("hinzuf\u00fcgen");
        this.entfernen = new JButton("entfernen");
        this.beenden = new JButton("beenden");
        anlernen = new JButton("anlernen");
        this.hinzufuegen.setActionCommand("1");
        this.entfernen.setActionCommand("2");
        anlernen.setActionCommand("3");
        this.beenden.setActionCommand("0");
        this.hinzufuegen.addActionListener(this);
        this.entfernen.addActionListener(this);
        anlernen.addActionListener(this);
        this.beenden.addActionListener(this);
        routingObjectVector = ObjectVectorClass.getRoutingObjekte();
        if (routingObjectVector != null) {
            anzahlRoutingObjekte = routingObjectVector.size();
            daten_routing = new Object[anzahlRoutingObjekte][5];
            ueberschrift_routing = new String[]{"Objekt-ID", "BIER-ID", "Typ", "Anlernen", "TypNr"};
            i = 0;
            while (i < anzahlRoutingObjekte) {
                routingObjekt = routingObjectVector.elementAt(i);
                RoutingTableZuweisung.daten_routing[i][0] = routingObjekt.getObjektID();
                RoutingTableZuweisung.daten_routing[i][1] = routingObjekt.getBierID();
                int objektTyp = Integer.parseInt(routingObjekt.getTyp());
                RoutingTableZuweisung.daten_routing[i][2] = typ[objektTyp];
                RoutingTableZuweisung.daten_routing[i][3] = false;
                RoutingTableZuweisung.daten_routing[i][4] = objektTyp;
                ++i;
            }
        } else {
            daten_routing = null;
            ueberschrift_routing = new String[]{"Keine Routingobjekte vorhanden!"};
        }
        model_routing = new TableModel_RoutingTabelle(daten_routing, ueberschrift_routing);
        table_routing = new JTable(model_routing);
        table_routing.setRowHeight(20);
        table_routing.setDefaultEditor(Boolean.TYPE, new DefaultCellEditor(new JCheckBox()));
        table_routing.setDefaultRenderer(Boolean.TYPE, new DefaultTableCellRenderer());
        scroll_routing = new JScrollPane(table_routing);
        scroll_routing.setVerticalScrollBarPolicy(22);
        scroll_routing.setBounds(5, 5, 380, 200);
        this.add(scroll_routing);
        anlernen.setBounds(5, 210, 120, 20);
        anlernen.setEnabled(false);
        this.add(anlernen);
        newObjectVector = ObjectVectorClass.getNeueObjekte();
        if (newObjectVector != null && newObjectVector.size() > 0) {
            anzahlNeueObjekte = newObjectVector.size();
            daten_objekte = new Object[anzahlNeueObjekte][3];
            ueberschrift_objekte = new String[]{"Objekt-ID", "Typ", "TypNr"};
            i = 0;
            while (i < newObjectVector.size()) {
                newObject = newObjectVector.get(i);
                RoutingTableZuweisung.daten_objekte[i][0] = newObject.getObjektid();
                RoutingTableZuweisung.daten_objekte[i][1] = typ[newObject.getTyp()];
                RoutingTableZuweisung.daten_objekte[i][2] = newObject.getTyp();
                ++i;
            }
        } else {
            daten_objekte = null;
            ueberschrift_objekte = new String[]{"Keine neuen Objekte vorhanden!"};
        }
        model_objekte = new TableModel_NeueObjekte(daten_objekte, ueberschrift_objekte);
        table_objekte = new JTable(model_objekte);
        table_objekte.setRowHeight(20);
        scroll_objekte = new JScrollPane(table_objekte);
        scroll_objekte.setVerticalScrollBarPolicy(22);
        scroll_objekte.setBounds(5, 240, 380, 200);
        this.add(scroll_objekte);
        this.hinzufuegen.setBounds(5, 450, 120, 20);
        this.entfernen.setBounds(130, 450, 120, 20);
        this.beenden.setBounds(255, 450, 120, 20);
        this.add(this.hinzufuegen);
        this.add(this.entfernen);
        this.add(this.beenden);
        int x = (int)argRect.getMaxX();
        int y = (int)argRect.getMinY();
        this.setBounds(x, y, 400, 520);
        this.setResizable(false);
        this.setVisible(true);
    }

    public static void addObjekt_TabelleAktualisierung(boolean argAktualisierungRoutingTabelle) {
        if (argAktualisierungRoutingTabelle) {
            routingObjectVector = ObjectVectorClass.getRoutingObjekte();
            anzahlRoutingObjekte = routingObjectVector.size();
            daten_routing = new Object[anzahlRoutingObjekte][5];
            ueberschrift_routing = new String[]{"Objekt-ID", "BIER-ID", "Typ", "Anlernen", "TypNr"};
            int i = 0;
            while (i < anzahlRoutingObjekte) {
                routingObjekt = routingObjectVector.elementAt(i);
                RoutingTableZuweisung.daten_routing[i][0] = routingObjekt.getObjektID();
                RoutingTableZuweisung.daten_routing[i][1] = routingObjekt.getBierID();
                int objektTyp = Integer.parseInt(routingObjekt.getTyp());
                RoutingTableZuweisung.daten_routing[i][2] = typ[objektTyp];
                RoutingTableZuweisung.daten_routing[i][3] = false;
                RoutingTableZuweisung.daten_routing[i][4] = objektTyp;
                ++i;
            }
            model_routing = new TableModel_RoutingTabelle(daten_routing, ueberschrift_routing);
            table_routing.setModel(model_routing);
        } else {
            newObjectVector = ObjectVectorClass.getNeueObjekte();
            if (newObjectVector != null && newObjectVector.size() > 0) {
                anzahlNeueObjekte = newObjectVector.size();
                daten_objekte = new Object[anzahlNeueObjekte][3];
                ueberschrift_objekte = new String[]{"Objekt-ID", "Typ", "TypNr"};
                int i = 0;
                while (i < newObjectVector.size()) {
                    newObject = newObjectVector.get(i);
                    RoutingTableZuweisung.daten_objekte[i][0] = newObject.getObjektid();
                    RoutingTableZuweisung.daten_objekte[i][1] = newObject.getTyp() != -1 ? typ[newObject.getTyp()] : "";
                    RoutingTableZuweisung.daten_objekte[i][2] = newObject.getTyp();
                    ++i;
                }
            } else {
                daten_objekte = null;
                ueberschrift_objekte = new String[]{"Keine neuen Objekte vorhanden!"};
            }
            model_objekte = new TableModel_NeueObjekte(daten_objekte, ueberschrift_objekte);
            table_objekte.setModel(model_objekte);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int auswahl = Integer.parseInt(arg0.getActionCommand());
        switch (auswahl) {
            case 0: {
                this.setVisible(false);
                break;
            }
            case 1: {
                int objektTyp;
                long objektid;
                int[] hinzufuegendesObjekt = table_objekte.getSelectedRows();
                if (hinzufuegendesObjekt.length <= 0) break;
                int i = 0;
                while (i < hinzufuegendesObjekt.length) {
                    objektid = Long.parseLong("" + model_objekte.getValueAt(hinzufuegendesObjekt[i], 0));
                    objektTyp = Integer.parseInt("" + model_objekte.getValueAt(hinzufuegendesObjekt[i], 2));
                    newObject = ObjectVectorClass.getEinzelnesNeuesObjekte(objektid, objektTyp);
                    int lfdNr = 0;
                    boolean ende = true;
                    anzahlRoutingObjekte = routingObjectVector.size();
                    int x = 0;
                    while (x < anzahlRoutingObjekte) {
                        routingObjekt = routingObjectVector.elementAt(x);
                        if (routingObjekt.getLfdNr() != x) {
                            lfdNr = x;
                            ende = false;
                            break;
                        }
                        ++x;
                    }
                    if (ende) {
                        lfdNr = anzahlRoutingObjekte;
                    }
                    long basisBierid = BIERKonfigurator.getOwnID();
                    long neueBierid = basisBierid + (long)lfdNr;
                    routingObjekt = new RoutingObject(newObject.getObjektid(), "" + neueBierid, "" + newObject.getTyp(), lfdNr);
                    ObjectVectorClass.addRoutingObjekt(routingObjekt);
                    routingObjectVector = ObjectVectorClass.getRoutingObjekte();
                    ++i;
                }
                i = 0;
                while (i < hinzufuegendesObjekt.length) {
                    objektid = Long.parseLong("" + model_objekte.getValueAt(hinzufuegendesObjekt[i], 0));
                    objektTyp = Integer.parseInt("" + model_objekte.getValueAt(hinzufuegendesObjekt[i], 2));
                    ObjectVectorClass.delNeuesObjekt_ueberID(objektid, objektTyp);
                    ++i;
                }
                newObjectVector = ObjectVectorClass.getNeueObjekte();
                anzahlNeueObjekte = newObjectVector.size();
                daten_objekte = new Object[anzahlNeueObjekte][3];
                ueberschrift_objekte = new String[]{"Objekt-ID", "Typ", "TypNr"};
                i = 0;
                while (i < anzahlNeueObjekte) {
                    newObject = newObjectVector.get(i);
                    RoutingTableZuweisung.daten_objekte[i][0] = newObject.getObjektid();
                    RoutingTableZuweisung.daten_objekte[i][1] = typ[newObject.getTyp()];
                    RoutingTableZuweisung.daten_objekte[i][2] = newObject.getTyp();
                    ++i;
                }
                model_objekte = new TableModel_NeueObjekte(daten_objekte, ueberschrift_objekte);
                table_objekte.setModel(model_objekte);
                TableColumnModel tcm = table_routing.getColumnModel();
                int[] groessen = new int[5];
                if (daten_routing != null) {
                    int x = 0;
                    while (x < tcm.getColumnCount() - 1) {
                        TableColumn tableColumn = tcm.getColumn(x);
                        groessen[x] = tableColumn.getWidth();
                        ++x;
                    }
                }
                anzahlRoutingObjekte = routingObjectVector.size();
                daten_routing = new Object[anzahlRoutingObjekte][5];
                ueberschrift_routing = new String[]{"Objekt-ID", "BIER-ID", "Typ", "Anlernen", "TypNr"};
                int i2 = 0;
                while (i2 < anzahlRoutingObjekte) {
                    routingObjekt = routingObjectVector.elementAt(i2);
                    RoutingTableZuweisung.daten_routing[i2][0] = routingObjekt.getObjektID();
                    RoutingTableZuweisung.daten_routing[i2][1] = routingObjekt.getBierID();
                    objektTyp = Integer.parseInt(routingObjekt.getTyp());
                    RoutingTableZuweisung.daten_routing[i2][2] = typ[objektTyp];
                    RoutingTableZuweisung.daten_routing[i2][3] = false;
                    RoutingTableZuweisung.daten_routing[i2][4] = objektTyp;
                    ++i2;
                }
                model_routing = new TableModel_RoutingTabelle(daten_routing, ueberschrift_routing);
                table_routing.setModel(model_routing);
                TableColumnModel tableColumnModel = table_routing.getColumnModel();
                if (daten_routing == null) break;
                int x = 0;
                while (x < tableColumnModel.getColumnCount() - 1) {
                    TableColumn tableColumn = tableColumnModel.getColumn(x);
                    tableColumn.setPreferredWidth(groessen[x]);
                    tableColumn.setWidth(groessen[x]);
                    ++x;
                }
                break;
            }
            case 2: {
                int[] zuentfernendesObjekt = table_routing.getSelectedRows();
                int i = 0;
                while (i < zuentfernendesObjekt.length) {
                    long bierID = Long.parseLong("" + model_routing.getValueAt(zuentfernendesObjekt[i], 1));
                    int objektTyp = Integer.parseInt("" + model_routing.getValueAt(zuentfernendesObjekt[i], 4));
                    routingObjekt = ObjectVectorClass.getRoutingObjekt(bierID, objektTyp);
                    NeuesObjekt objekt = new NeuesObjekt(routingObjekt.getObjektID(), Integer.parseInt(routingObjekt.getTyp()));
                    ObjectVectorClass.delRoutingObjekt(routingObjekt);
                    ObjectVectorClass.addNeuesObjekt(objekt);
                    ++i;
                }
                tempEintrag = 0;
                int tempZaehler = 0;
                int i3 = 0;
                while (i3 < zuentfernendesObjekt.length) {
                    if (tempEintrag < zuentfernendesObjekt[i3]) {
                        model_routing.loescheZeile(zuentfernendesObjekt[i3] - tempZaehler);
                        ++tempZaehler;
                    } else {
                        model_routing.loescheZeile(zuentfernendesObjekt[i3]);
                        ++tempZaehler;
                    }
                    tempEintrag = zuentfernendesObjekt[i3];
                    ++i3;
                }
                newObjectVector = ObjectVectorClass.getNeueObjekte();
                anzahlNeueObjekte = newObjectVector.size();
                daten_objekte = new Object[anzahlNeueObjekte][3];
                ueberschrift_objekte = new String[]{"Objekt-ID", "Typ", "TypNr"};
                i3 = 0;
                while (i3 < anzahlNeueObjekte) {
                    newObject = newObjectVector.get(i3);
                    RoutingTableZuweisung.daten_objekte[i3][0] = newObject.getObjektid();
                    RoutingTableZuweisung.daten_objekte[i3][1] = typ[newObject.getTyp()];
                    RoutingTableZuweisung.daten_objekte[i3][2] = newObject.getTyp();
                    ++i3;
                }
                model_objekte = new TableModel_NeueObjekte(daten_objekte, ueberschrift_objekte);
                table_objekte.setModel(model_objekte);
                routingObjectVector = ObjectVectorClass.getRoutingObjekte();
                anzahlRoutingObjekte = routingObjectVector.size();
                TableColumnModel tcm = table_routing.getColumnModel();
                int[] groessen = new int[5];
                if (daten_routing != null) {
                    int x = 0;
                    while (x < tcm.getColumnCount() - 1) {
                        TableColumn tableColumn = tcm.getColumn(x);
                        groessen[x] = tableColumn.getWidth();
                        ++x;
                    }
                }
                daten_routing = new Object[anzahlRoutingObjekte][5];
                ueberschrift_routing = new String[]{"Objekt-ID", "BIER-ID", "Typ", "Anlernen", "TypNr"};
                int i4 = 0;
                while (i4 < anzahlRoutingObjekte) {
                    routingObjekt = routingObjectVector.elementAt(i4);
                    RoutingTableZuweisung.daten_routing[i4][0] = routingObjekt.getObjektID();
                    RoutingTableZuweisung.daten_routing[i4][1] = routingObjekt.getBierID();
                    int objektTyp = Integer.parseInt(routingObjekt.getTyp());
                    RoutingTableZuweisung.daten_routing[i4][2] = typ[objektTyp];
                    RoutingTableZuweisung.daten_routing[i4][3] = false;
                    RoutingTableZuweisung.daten_routing[i4][4] = objektTyp;
                    ++i4;
                }
                model_routing = new TableModel_RoutingTabelle(daten_routing, ueberschrift_routing);
                table_routing.setModel(model_routing);
                TableColumnModel tableColumnModel = table_routing.getColumnModel();
                if (daten_routing == null) break;
                int x = 0;
                while (x < tableColumnModel.getColumnCount() - 1) {
                    TableColumn tableColumn = tableColumnModel.getColumn(x);
                    tableColumn.setPreferredWidth(groessen[x]);
                    tableColumn.setWidth(groessen[x]);
                    ++x;
                }
                break;
            }
            case 3: {
                ConnectToBIER.learn(this.getAnlern_bierid(), this.getAnlern_typ());
            }
        }
    }

    public static void setVeraenderungAnlernen(String objektID, String bierID, String typ, String typNr, Object argValue, int argRow, int argCol) {
        anlernen.setEnabled(true);
        RoutingTableZuweisung.setAnlern_bierid(bierID);
        RoutingObject tempObjekt = ObjectVectorClass.getRoutingObjekt(Long.parseLong(bierID), Integer.parseInt(typNr));
        RoutingTableZuweisung.setAnlern_typ(tempObjekt.getTyp());
    }

    public static void setAnlern_bierid(String argBierID) {
        anlern_bierid = argBierID;
    }

    public static void setAnlern_typ(String argTyp) {
        anlern_typ = argTyp;
    }

    public int getAnlern_typ() {
        return Integer.parseInt(anlern_typ);
    }

    public long getAnlern_bierid() {
        return Long.parseLong(anlern_bierid);
    }

    public static class Typ {
        String typ;

        public Typ(String argTyp) {
            this.typ = argTyp;
        }

        public String toString() {
            return this.typ;
        }
    }
}

