/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Logger;
import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Version;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.Key;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Starter {
    private Manifest mManifest = null;
    Version mVersion = new Version(6, 50, 100, 500, 2009, 7, 24);
    private Properties mprops = null;
    private boolean mfVerbose = false;
    private static ClassLoader mclServletClassLoader = null;
    private static ClassLoader mclClassLoader = null;
    private static Starter minstance = null;
    private MessageHandler msghandler = null;

    public Starter() throws IllegalAccessException {
        if (null != minstance) {
            throw new IllegalAccessException("com.wibu.xpm.Starter already created!");
        }
        minstance = this;
    }

    public static Starter getInstance() {
        return minstance;
    }

    Manifest getManifest() throws IOException {
        int n;
        URL uRL;
        if (null == this.mManifest && (uRL = this.getClass().getResource("/com/wibu/xpm/Starter.class")).getProtocol() == "jar" && -1 != (n = uRL.toString().indexOf(33))) {
            String string = uRL.toString().substring(0, n + 1);
            string = string + "/META-INF/MANIFEST.MF";
            URL uRL2 = new URL(string);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            this.mManifest = jarURLConnection.getManifest();
        }
        return this.mManifest;
    }

    public void setVerbose(boolean bl, String[] stringArray) {
        this.mfVerbose = bl;
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime");
        if (this.mfVerbose) {
            logger.setLevel(Level.INFO);
            this.printVersionInfo(stringArray);
        } else if (!logger.isLoggable(Level.WARNING)) {
            java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime").setLevel(Level.WARNING);
        } else {
            Level level = logger.getLevel();
            if (level == null) {
                java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime").setLevel(Level.WARNING);
            }
        }
        this.init(logger);
    }

    public String getMainClass() throws Exception {
        Manifest manifest = this.getManifest();
        if (null != manifest) {
            String string = manifest.getMainAttributes().getValue("XpmMain");
            if (null != string && 0 == string.length()) {
                return null;
            }
            return string;
        }
        return null;
    }

    protected void printVersionInfo(String[] stringArray) {
        URL uRL;
        System.out.println();
        System.out.println("Dumping Environment Information");
        System.out.println("===============================");
        System.out.println("LD_LIBRARY_PATH        : " + System.getProperty("java.library.path"));
        System.out.println("CLASSPATH              : " + System.getProperty("java.class.path"));
        try {
            System.out.println("JAVA_TOOL_OPTIONS      : " + System.getenv("JAVA_TOOL_OPTIONS"));
        }
        catch (Error error) {
            // empty catch block
        }
        System.out.println("Java Runtime           : " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        System.out.println("System Information     : " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
        System.out.println("Working Directory      : " + System.getProperty("user.dir"));
        System.out.println("sun.arch.data.model    : " + System.getProperty("sun.arch.data.model"));
        if (null != stringArray) {
            System.out.println("Argument(s)            : " + Integer.toString(stringArray.length - 1));
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println("   (" + Integer.toString(i) + ")                 : " + stringArray[i]);
            }
        }
        if (null != (uRL = this.getClass().getResource("/com/wibu/xpm/ClassLoader.class.wibu"))) {
            System.out.println("ClassLoader.class      : " + uRL.getFile());
        } else {
            System.out.println("ClassLoader.class : null");
        }
        System.out.println("ClassLoader            : " + this.getClass().getClassLoader().toString());
        System.out.print("Security Manager       : ");
        if (null == System.getSecurityManager()) {
            System.out.println("null");
        } else {
            System.out.println(System.getSecurityManager().getClass().toString());
        }
        System.out.println("Starter Version        : " + this.mVersion.toString());
    }

    public String getProperty(String string, String string2) {
        if (null == string2) {
            return this.mprops.getProperty(string);
        }
        return this.mprops.getProperty(string, string2);
    }

    protected void init(java.util.logging.Logger logger) {
        try {
            String string = "com/wibu/xpm/runtime.properties";
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            this.mprops = new Properties();
            if (null != inputStream) {
                this.mprops.load(inputStream);
            } else {
                inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(string);
                if (null != inputStream) {
                    this.mprops.load(inputStream);
                } else {
                    logger.warning("Configuration file '" + string + "' not found.");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected MessageHandler createMessageHandler() throws Exception {
        MessageHandler messageHandler = null;
        String string = null;
        if (null != this.mprops) {
            string = this.mprops.getProperty("MessageHandler", "com.wibu.xpm.SwingMessageHandler");
        }
        if (null == string) {
            messageHandler = new MessageHandler();
        } else {
            Class<?> clazz = Class.forName(string);
            messageHandler = (MessageHandler)clazz.newInstance();
        }
        messageHandler.init(this.mprops);
        return messageHandler;
    }

    public ClassLoader getServletClassLoader() throws Exception {
        if (null == mclServletClassLoader) {
            mclServletClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/ServletClassLoader");
        }
        return mclServletClassLoader;
    }

    public ClassLoader createClassLoader() throws Exception {
        String string = this.mprops.getProperty("ClassLoader", "ClassLoader");
        mclClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/" + string);
        return mclClassLoader;
    }

    public boolean openClassLoader() throws Exception {
        if (!this.startUp()) {
            return false;
        }
        return this.preMain(Thread.currentThread().getContextClassLoader());
    }

    protected boolean preMain(ClassLoader classLoader) throws Exception {
        String string = this.mprops.getProperty("Prefetch");
        if (null != string) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime");
            logger.info("Prefetching classes.");
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/wibu/xpm/prefetch.bin");
            if (null == inputStream) {
                logger.severe("Error loading list of encrypted class files.");
                return false;
            }
            Vector vector = new Vector();
            vector = this.readClassNameList(inputStream);
            Enumeration enumeration = vector.elements();
            int n = 0;
            int n2 = vector.size();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!this.msghandler.prefetchClass(n++, n2, string2)) {
                    return false;
                }
                Class<?> clazz = classLoader.loadClass(string2);
                Runtime.getInstance().watch(clazz);
            }
            Runtime.getInstance().cleanUp();
        }
        return true;
    }

    private Vector readClassNameList(InputStream inputStream) throws Exception {
        String string;
        int n;
        int n2;
        int n3;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        objectInputStream.readObject();
        objectInputStream.readInt();
        int n4 = objectInputStream.readInt();
        byte[] byArray = new byte[n4];
        for (n2 = objectInputStream.read(byArray, 0, n4); n2 < n4; n2 += n3) {
            n3 = objectInputStream.read(byArray, n2, n4 - n2);
            if (n3 != -1) continue;
            Logger.getLogger(true).fatal("Error reading prefetch key.");
            break;
        }
        objectInputStream.readObject();
        n3 = objectInputStream.readInt();
        byte[] byArray2 = new byte[n3];
        for (n2 = objectInputStream.read(byArray2, 0, n3); n2 < n3; n2 += n) {
            n = objectInputStream.read(byArray2, n2, n3 - n2);
            if (n != -1) continue;
            Logger.getLogger(true).fatal("Error reading prefetch data.");
            break;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[16]));
        System.out.println("data.length= " + byArray2.length + " / dataSize=" + n3);
        byte[] byArray3 = cipher.doFinal(byArray2, 0, n3);
        System.out.println("Decrypted " + byArray2.length + "(" + n3 + ") to " + byArray3.length);
        Vector<String> vector = new Vector<String>();
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray3));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while (null != (string = bufferedReader.readLine())) {
            vector.add(string.substring(0, string.lastIndexOf(".class")));
        }
        return vector;
    }

    protected boolean startUp() throws Exception {
        this.msghandler = this.createMessageHandler();
        this.msghandler.messageBoot();
        Runtime runtime = Runtime.getInstance();
        if (null == runtime) {
            runtime = new Runtime(this.msghandler);
            runtime.SetApplicationName(this.mprops.getProperty("ApplicationName"));
        }
        Version version = new Version();
        String string = this.mprops.getProperty("MinXpmBuild", "10");
        runtime.getVersion(version);
        if (this.mfVerbose) {
            System.out.println("Runtime Version        : " + version.toString());
        }
        if (version.msBuild < Integer.parseInt(string)) {
            String string2 = this.mprops.getProperty("MinXpmVersion", "6.20");
            this.msghandler.errorUnspecified("Runtime version too old. Minimum version " + string2 + " Build " + string + " required!");
            return false;
        }
        if (!this.registerVms(runtime, version, this.msghandler)) {
            return false;
        }
        String string3 = this.getProperty("Native Hook", null);
        if (null != string3) {
            runtime.setNativeHook(string3);
        } else {
            runtime.setNativeHook("T");
        }
        return true;
    }

    public ClassLoader createEclipseClassLoader() throws Exception {
        mclClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/EclipseClassLoader");
        return mclClassLoader;
    }

    public ClassLoader getClassLoader() {
        return mclClassLoader;
    }

    protected Object createClassLoader(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        byte[] byArray = null;
        Class clazz = null;
        try {
            inputStream = classLoader.getResourceAsStream(string + ".class.wibu");
            if (null == inputStream) {
                throw new ClassNotFoundException();
            }
            try {
                long l;
                int n = 0;
                int n2 = inputStream.available();
                byArray = new byte[n2];
                do {
                    if ((l = (long)inputStream.read(byArray, n, n2 - n)) != -1L) continue;
                    System.err.println("Error reading classBytes of " + string);
                    return null;
                } while ((n = (int)((long)n + l)) < n2);
            }
            catch (Exception exception) {
                System.err.println("Exception at reading classBytes of " + string);
            }
            if (!this.startUp()) {
                return null;
            }
            clazz = Runtime.getInstance().loadClass(Thread.currentThread().getContextClassLoader(), string, byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ClassNotFoundException();
        }
        if (null == clazz) {
            return null;
        }
        Object t = clazz.newInstance();
        if (null != t && !this.preMain((ClassLoader)t)) {
            return null;
        }
        return t;
    }

    protected boolean readSignature(Runtime runtime, InputStream inputStream) throws IOException {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime");
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        block4: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            byte[] byArray = string2.getBytes();
            switch (runtime.registerVm(string, byArray)) {
                case 0: {
                    logger.info("Registered VM '" + string + "'.");
                    continue block4;
                }
                case 1: {
                    logger.info("Registration of VM '" + string + "' skipped.");
                    continue block4;
                }
            }
            logger.warning("Registration of VM '" + string + "' failed!");
        }
        return true;
    }

    protected boolean registerVms(Runtime runtime, Version version, MessageHandler messageHandler) {
        block10: {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime");
            String string = System.getProperty("java.specification.version");
            String[] stringArray = string.split("\\.");
            if (2 != stringArray.length) {
                logger.severe("Invalid value of 'java.specification.version': '" + string + "'.");
                return false;
            }
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            if (n == 1 && n2 < 6) {
                logger.info("Previous Java version (" + string + ") found - no verification required.");
                return true;
            }
            if (version.msBuild < 50) {
                messageHandler.errorUnspecified("Runtime version too old for Java 6. Minimum version 6.20 Build 50 required!");
                return false;
            }
            try {
                JarEntry jarEntry;
                InputStream inputStream;
                Serializable serializable;
                String string2 = "com/wibu/xpm/vm.properties";
                Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(string2);
                if (null == enumeration) {
                    logger.warning("No JVM signatures found!");
                } else {
                    while (enumeration.hasMoreElements() && null != (serializable = enumeration.nextElement())) {
                        inputStream = ((URL)serializable).openStream();
                        if (null == inputStream) {
                            logger.severe("Error reading JVM signatures from " + ((URL)serializable).toString());
                            return false;
                        }
                        this.readSignature(runtime, inputStream);
                    }
                }
                serializable = new File(System.getProperty("user.home") + File.separator + "WibuVm.jar");
                if (!((File)serializable).isFile()) break block10;
                inputStream = new FileInputStream((File)serializable);
                FileInputStream fileInputStream = new FileInputStream((File)serializable);
                JarInputStream jarInputStream = new JarInputStream(inputStream);
                JarInputStream jarInputStream2 = new JarInputStream(fileInputStream);
                while (null != (jarEntry = jarInputStream.getNextJarEntry())) {
                    jarInputStream2.getNextJarEntry();
                    String string3 = jarEntry.getName();
                    jarInputStream.closeEntry();
                    if (!string3.equals("com/wibu/xpm/vm.properties")) continue;
                    this.readSignature(runtime, jarInputStream2);
                    break;
                }
            }
            catch (IOException iOException) {
                logger.warning("Error reading whitelist file: " + iOException.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }
}

