/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_version < 8160) {
            throw new XAException(-6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start(Xid xid, int n) throws XAException {
        int n2;
        block20: {
            Statement statement;
            block18: {
                n2 = -1;
                statement = null;
                this.disallowLocalTxnMode(-6);
                if (xid == null) {
                    throw new XAException(-5);
                }
                int n3 = n & 0xFF00;
                int n4 = (n &= 0xFFFF00FF) & 0x10000;
                if ((n &= 0xFFFEFFFF) != 0 && n != 0x8000000 && n != 0x200000 && n != 2 || n4 != 0 && (n4 & 0x10000) != 65536) {
                    throw new XAException(-5);
                }
                if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
                    throw new XAException(-5);
                }
                if ((n & 0x8200000) != 0 && ((n3 & 0xFF00) != 0 || (n4 & 0x10000) != 0)) {
                    throw new XAException(-5);
                }
                n |= n3 | n4;
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(xa_start_816);
                    statement.registerOutParameter(1, -2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.setInt(3, this.m_timeout);
                    statement.setInt(4, n);
                    statement.registerOutParameter(5, 2);
                    statement.execute();
                    byte[] byArray2 = statement.getBytes(1);
                    ((OracleXid)xid).setTxContext(byArray2);
                    n2 = statement.getInt(5);
                    break block18;
                }
                statement = this.m_conn.prepareCall(xa_start_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.setInt(5, this.m_timeout);
                statement.setInt(6, n);
                statement.execute();
                n2 = statement.getInt(1);
            }
            Object var10_10 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block20;
                catch (SQLException sQLException) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    n2 = sQLException.getErrorCode();
                    if (n2 == 0) {
                        throw new XAException(-6);
                    }
                    Object var10_11 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n2);
        super.push(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void end(Xid xid, int n) throws XAException {
        int n2;
        block18: {
            n2 = -1;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            if (n != 0x2000000 && n != 0x4000000 && n != 0x20000000 && (n & 2) != 2) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid, n);
            super.pop();
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_end_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.setInt(3, n);
                statement.execute();
                n2 = statement.getInt(1);
            } else {
                statement = this.m_conn.prepareCall(xa_end_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.setInt(5, n);
                statement.execute();
                n2 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var8_8 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block18;
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 == 0) {
                        throw new XAException(-6);
                    }
                    Object var8_9 = null;
                    this.restoreAutoCommitModeForGlobalTransaction();
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.restoreAutoCommitModeForGlobalTransaction();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        this.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void commit(Xid var1_1, boolean var2_2) throws XAException {
        block22: {
            var3_3 = -1;
            var4_4 = 0;
            var6_5 = null;
            if (var1_1 == null) {
                throw new XAException(-5);
            }
            var5_6 = var2_2 != false ? 1 : 0;
            var7_7 = super.suspendStacked(var1_1);
            if (this.m_version == 8160) {
                if (!(var1_1 instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                var6_5 = this.m_conn.prepareCall(OracleXAResource.xa_commit_816);
                var6_5.registerOutParameter(1, 2);
                var8_9 = OracleXAResource.getSerializedBytes(var1_1);
                var6_5.setBytes(2, var8_9);
                var6_5.setInt(3, var5_6);
                var6_5.registerOutParameter(4, 2);
                var6_5.execute();
                var3_3 = var6_5.getInt(1);
                var4_4 = var6_5.getInt(4);
                ((OracleXid)var1_1).setState(var4_4);
                if (var3_3 == 24780) {
                    var9_10 = null;
                    var10_11 = null;
                    try {
                        var11_12 = this.getConnectionProperties();
                        var10_11 = new OracleXADataSource();
                        var10_11.setURL((String)var11_12.get("connection_url"));
                        var10_11.setUser((String)var11_12.get("user"));
                        var10_11.setPassword((String)var11_12.get("password"));
                        var9_10 = var10_11.getXAConnection();
                        var12_13 = var9_10.getXAResource();
                        var12_13.commit(var1_1, var5_6 == 1);
                        var14_14 = null;
                        ** if (var9_10 == null) goto lbl-1000
                    }
                    catch (Throwable var13_16) {
                        var14_15 = null;
                        if (var9_10 != null) {
                            var9_10.close();
                        }
                        throw var13_16;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var9_10.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    var3_3 = 0;
                }
            } else {
                var6_5 = this.m_conn.prepareCall(OracleXAResource.xa_commit_post_816);
                var6_5.registerOutParameter(1, 2);
                var6_5.setInt(2, var1_1.getFormatId());
                var6_5.setBytes(3, var1_1.getGlobalTransactionId());
                var6_5.setBytes(4, var1_1.getBranchQualifier());
                var6_5.setInt(5, var5_6);
                var6_5.execute();
                var3_3 = var6_5.getInt(1);
            }
            super.resumeStacked(var7_7);
            var16_17 = null;
            try {
                if (var6_5 != null) {
                    var6_5.close();
                }
            }
            catch (SQLException var17_20) {
                // empty catch block
            }
            var6_5 = null;
            {
                break block22;
                catch (SQLException var7_8) {
                    var3_3 = var7_8.getErrorCode();
                    if (var3_3 == 0) {
                        throw new XAException(-6);
                    }
                    var16_18 = null;
                    try {
                        if (var6_5 != null) {
                            var6_5.close();
                        }
                    }
                    catch (SQLException var17_21) {
                        // empty catch block
                    }
                    var6_5 = null;
                }
            }
            catch (Throwable var15_23) {
                var16_19 = null;
                try {
                    if (var6_5 != null) {
                        var6_5.close();
                    }
                }
                catch (SQLException var17_22) {
                    // empty catch block
                }
                var6_5 = null;
                throw var15_23;
            }
        }
        this.checkError(var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int prepare(Xid xid) throws XAException {
        int n3;
        int n2;
        block18: {
            n2 = 0;
            int n32 = 0;
            Statement statement = null;
            if (xid == null) {
                throw new XAException(-5);
            }
            Xid xid2 = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                statement = this.m_conn.prepareCall(xa_prepare_816);
                statement.registerOutParameter(1, 2);
                byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                statement.setBytes(2, byArray);
                statement.registerOutParameter(3, 2);
                statement.execute();
                n2 = statement.getInt(1);
                n32 = statement.getInt(3);
                ((OracleXid)xid).setState(n32);
            } else {
                statement = this.m_conn.prepareCall(xa_prepare_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.execute();
                n2 = statement.getInt(1);
            }
            super.resumeStacked(xid2);
            Object var8_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block18;
                catch (SQLException sQLException) {
                    n2 = sQLException.getErrorCode();
                    if (n2 == 0) {
                        throw new XAException(-6);
                    }
                    Object var8_10 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                throw throwable;
            }
        }
        int n4 = n3 = n2 == 0 ? 0 : OracleXAException.errorConvert(n2);
        if (n3 != 0 && n3 != 3) {
            throw new OracleXAException(n2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void forget(Xid xid) throws XAException {
        int n;
        block17: {
            Statement statement;
            block15: {
                n = 0;
                int n2 = 0;
                statement = null;
                if (xid == null) {
                    throw new XAException(-5);
                }
                this.saveTxnMode();
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        throw new XAException(-6);
                    }
                    statement = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                    statement.registerOutParameter(1, 2);
                    byte[] byArray = OracleXAResource.getSerializedBytes(xid);
                    statement.setBytes(2, byArray);
                    statement.registerOutParameter(3, 2);
                    statement.execute();
                    n = statement.getInt(1);
                    n2 = statement.getInt(3);
                    ((OracleXid)xid).setState(n2);
                    break block15;
                }
                statement = this.m_conn.prepareCall(xa_forget_post_816);
                statement.registerOutParameter(1, 2);
                statement.setInt(2, xid.getFormatId());
                statement.setBytes(3, xid.getGlobalTransactionId());
                statement.setBytes(4, xid.getBranchQualifier());
                statement.execute();
                n = statement.getInt(1);
            }
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            this.restoreTxnMode();
            {
                break block17;
                catch (SQLException sQLException) {
                    n = sQLException.getErrorCode();
                    if (n == 0) {
                        throw new XAException(-6);
                    }
                    Object var7_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    statement = null;
                    this.restoreTxnMode();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                statement = null;
                this.restoreTxnMode();
                throw throwable;
            }
        }
        this.checkError(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void rollback(Xid var1_1) throws XAException {
        block22: {
            var2_2 = 0;
            var3_3 = 0;
            var4_4 = null;
            if (var1_1 == null) {
                throw new XAException(-5);
            }
            var5_5 = super.suspendStacked(var1_1);
            if (this.m_version == 8160) {
                if (!(var1_1 instanceof OracleXid)) {
                    throw new XAException(-6);
                }
                var4_4 = this.m_conn.prepareCall(OracleXAResource.xa_rollback_816);
                var4_4.registerOutParameter(1, 2);
                var6_7 = OracleXAResource.getSerializedBytes(var1_1);
                var4_4.setBytes(2, var6_7);
                var4_4.registerOutParameter(3, 2);
                var4_4.execute();
                var2_2 = var4_4.getInt(1);
                var3_3 = var4_4.getInt(3);
                ((OracleXid)var1_1).setState(var3_3);
                if (var2_2 == 24780) {
                    var7_8 = null;
                    var8_9 = null;
                    try {
                        var9_10 = this.getConnectionProperties();
                        var8_9 = new OracleXADataSource();
                        var8_9.setURL((String)var9_10.get("connection_url"));
                        var8_9.setUser((String)var9_10.get("user"));
                        var8_9.setPassword((String)var9_10.get("password"));
                        var7_8 = var8_9.getXAConnection();
                        var10_11 = var7_8.getXAResource();
                        var10_11.rollback(var1_1);
                        var12_12 = null;
                        ** if (var7_8 == null) goto lbl-1000
                    }
                    catch (Throwable var11_14) {
                        var12_13 = null;
                        if (var7_8 != null) {
                            var7_8.close();
                        }
                        throw var11_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var7_8.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    var2_2 = 0;
                }
            } else {
                var4_4 = this.m_conn.prepareCall(OracleXAResource.xa_rollback_post_816);
                var4_4.registerOutParameter(1, 2);
                var4_4.setInt(2, var1_1.getFormatId());
                var4_4.setBytes(3, var1_1.getGlobalTransactionId());
                var4_4.setBytes(4, var1_1.getBranchQualifier());
                var4_4.execute();
                var2_2 = var4_4.getInt(1);
            }
            super.resumeStacked(var5_5);
            var14_15 = null;
            try {
                if (var4_4 != null) {
                    var4_4.close();
                }
            }
            catch (SQLException var15_18) {
                // empty catch block
            }
            var4_4 = null;
            {
                break block22;
                catch (SQLException var5_6) {
                    var2_2 = var5_6.getErrorCode();
                    if (var2_2 == 0) {
                        throw new XAException(-6);
                    }
                    var14_16 = null;
                    try {
                        if (var4_4 != null) {
                            var4_4.close();
                        }
                    }
                    catch (SQLException var15_19) {
                        // empty catch block
                    }
                    var4_4 = null;
                }
            }
            catch (Throwable var13_21) {
                var14_17 = null;
                try {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                }
                catch (SQLException var15_20) {
                    // empty catch block
                }
                var4_4 = null;
                throw var13_21;
            }
        }
        this.checkError(var2_2);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

