/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class RandomArrayStream {
    private static final int BUFFER_SIZE = 16384;
    private int position;
    private int mark;
    private int size;
    private Vector<byte[]> byteArrays = new Vector();
    private int realSize;
    private boolean closed;

    public RandomArrayStream() {
        byte[] data = new byte[16384];
        this.byteArrays.addElement(data);
        this.realSize = 16384;
        this.position = 0;
        this.mark = 0;
        this.closed = false;
    }

    public void writeBoolean(boolean value) throws IOException {
        byte[] byteArray = new byte[]{value ? (byte)1 : 0};
        this.write(byteArray);
    }

    public void writeByte(byte value) throws IOException {
        byte[] byteArray = new byte[]{value};
        this.write(byteArray);
    }

    public void writeShort(short value) throws IOException {
        byte[] byteArray = new byte[]{(byte)(value >> 8), (byte)value};
        this.write(byteArray);
    }

    public void writeInt(int value) throws IOException {
        byte[] byteArray = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        this.write(byteArray);
    }

    public void writeLong(long value) throws IOException {
        byte[] byteArray = new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        this.write(byteArray);
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            string = "";
        }
        int len = string.length();
        int i = 0;
        while (i < len) {
            this.writeChar(string.charAt(i));
            ++i;
        }
    }

    public void writeChar(char value) throws IOException {
        this.writeByte((byte)(value >>> 8 & 0xFF));
        this.writeByte((byte)(value & 0xFF));
    }

    public void write(byte[] data) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (data == null) {
            data = new byte[]{};
        }
        this.validateSize(this.position + data.length);
        int array = this.position / 16384;
        int field = this.position % 16384;
        byte[] currentArray = this.byteArrays.elementAt(array);
        int available = 16384 - field;
        int length = available > data.length ? data.length : available;
        System.arraycopy(data, 0, currentArray, field, length);
        this.position += length;
        int n = this.size = this.position > this.size ? this.position : this.size;
        if (data.length > length) {
            int newSize = data.length - length;
            newSize = newSize == 0 ? 1 : newSize;
            byte[] newData = new byte[newSize];
            System.arraycopy(data, length, newData, 0, newData.length);
            this.write(newData);
        }
    }

    public boolean readBoolean() throws IOException {
        byte[] byteArray = new byte[1];
        this.read(byteArray);
        return byteArray[0] == 1;
    }

    public byte readByte() throws IOException {
        byte[] byteArray = new byte[1];
        this.read(byteArray);
        return byteArray[0];
    }

    public short readShort() throws IOException {
        byte[] byteArray = new byte[2];
        this.read(byteArray);
        return (short)((short)(byteArray[0] & 0xFF) << 8 | (short)(byteArray[1] & 0xFF));
    }

    public int readInt() throws IOException {
        byte[] byteArray = new byte[4];
        this.read(byteArray);
        return (byteArray[0] & 0xFF) << 24 | (byteArray[1] & 0xFF) << 16 | (byteArray[2] & 0xFF) << 8 | byteArray[3] & 0xFF;
    }

    public long readLong() throws IOException {
        byte[] byteArray = new byte[8];
        this.read(byteArray);
        return (long)(byteArray[0] & 0xFF) << 56 | (long)(byteArray[1] & 0xFF) << 48 | (long)(byteArray[2] & 0xFF) << 40 | (long)(byteArray[3] & 0xFF) << 32 | (long)(byteArray[4] & 0xFF) << 24 | (long)(byteArray[5] & 0xFF) << 16 | (long)(byteArray[6] & 0xFF) << 8 | (long)(byteArray[7] & 0xFF);
    }

    public char readChar() throws IOException {
        byte[] byteArray = new byte[2];
        this.read(byteArray);
        return (char)((char)(byteArray[0] & 0xFF) << 8 | (char)(byteArray[1] & 0xFF));
    }

    public String readString(int length) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            stringBuffer.append(this.readChar());
            ++i;
        }
        return stringBuffer.toString();
    }

    public void read(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (data == null) {
            throw new IOException("Data must not be null");
        }
        if (offset + length > data.length) {
            throw new IOException("Array to small");
        }
        if (length + this.position > this.size) {
            throw new IOException("EOD reached");
        }
        int array = this.position / 16384;
        int field = this.position % 16384;
        byte[] currentArray = this.byteArrays.elementAt(array);
        int available = 16384 - field;
        int readLength = available > length ? length : available;
        System.arraycopy(currentArray, field, data, offset, readLength);
        this.position += readLength;
        if (length > available) {
            this.read(data, offset += available, length -= available);
        }
    }

    public void read(byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("Data must not be null");
        }
        this.read(data, 0, data.length);
    }

    public void seek(int position) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.validateSize(position);
        this.position = position;
        this.size = position > this.size ? position : this.size;
    }

    public void close() {
        this.byteArrays.removeAllElements();
        this.byteArrays = null;
        this.position = 0;
        this.mark = 0;
        this.realSize = 0;
        this.size = 0;
        this.closed = true;
    }

    public int size() {
        return this.size;
    }

    public int getPosition() {
        return this.position;
    }

    public int available() {
        return this.size - this.position;
    }

    public void mark() {
        this.mark = this.position;
    }

    public void reset() {
        this.position = this.mark;
    }

    public void trim() {
        int array = this.position / 16384;
        while (this.byteArrays.size() > array) {
            this.byteArrays.removeElementAt(this.byteArrays.size() - 1);
        }
        this.realSize = array * 16384;
        this.size = this.position;
        this.mark = this.mark > this.position ? 0 : this.mark;
    }

    private void validateSize(int neededSize) {
        if (neededSize < this.realSize) {
            return;
        }
        byte[] data = new byte[16384];
        this.byteArrays.addElement(data);
        this.realSize += 16384;
        this.validateSize(neededSize);
    }

    public void load(File file) throws IOException {
        this.seek(0);
        this.trim();
        FileInputStream fileInputStream = new FileInputStream(file);
        while (fileInputStream.available() != 0) {
            int length = Math.min(16384, fileInputStream.available());
            byte[] data = new byte[length];
            fileInputStream.read(data);
            this.write(data);
        }
        fileInputStream.close();
        this.seek(0);
    }

    public byte[] readData(int length) {
        byte[] data = new byte[length];
        try {
            this.read(data);
        }
        catch (IOException iOException) {
            return null;
        }
        return data;
    }
}

