/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote.vnc;

import de.bsc.bapfinder.plugins.remote.vnc.IVNC;
import de.bsc.bapfinder.plugins.remote.vnc.Options;
import de.bsc.bapfinder.plugins.remote.vnc.tools.DesCipher;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

public class RFBProtocol {
    public static final String versionMsg_3_3 = "RFB 003.003\n";
    public static final String versionMsg_3_7 = "RFB 003.007\n";
    public static final String versionMsg_3_8 = "RFB 003.008\n";
    public static final String StandardVendor = "STDV";
    public static final String TridiaVncVendor = "TRDV";
    public static final String TightVncVendor = "TGHT";
    public static final int SecTypeInvalid = 0;
    public static final int SecTypeNone = 1;
    public static final int SecTypeVncAuth = 2;
    public static final int SecTypeTight = 16;
    public static final int NoTunneling = 0;
    public static final String SigNoTunneling = "NOTUNNEL";
    public static final int AuthNone = 1;
    public static final int AuthVNC = 2;
    public static final int AuthUnixLogin = 129;
    public static final String SigAuthNone = "NOAUTH__";
    public static final String SigAuthVNC = "VNCAUTH_";
    public static final String SigAuthUnixLogin = "ULGNAUTH";
    public static final int VncAuthOK = 0;
    public static final int VncAuthFailed = 1;
    public static final int VncAuthTooMany = 2;
    public static final int FramebufferUpdate = 0;
    public static final int SetColourMapEntries = 1;
    public static final int Bell = 2;
    public static final int ServerCutText = 3;
    public static final int rfbFileTransfer = 7;
    public static final int EndOfContinuousUpdates = 150;
    public static final String SigEndOfContinuousUpdates = "CUS_EOCU";
    public static final int SetPixelFormat = 0;
    public static final int FixColourMapEntries = 1;
    public static final int SetEncodings = 2;
    public static final int FramebufferUpdateRequest = 3;
    public static final int KeyboardEvent = 4;
    public static final int PointerEvent = 5;
    public static final int ClientCutText = 6;
    public static final int EnableContinuousUpdates = 150;
    public static final String SigEnableContinuousUpdates = "CUC_ENCU";
    public static final int EncodingRaw = 0;
    public static final int EncodingCopyRect = 1;
    public static final int EncodingRRE = 2;
    public static final int EncodingCoRRE = 4;
    public static final int EncodingHextile = 5;
    public static final int EncodingZlib = 6;
    public static final int EncodingTight = 7;
    public static final int EncodingZRLE = 16;
    public static final int EncodingCompressLevel0 = -256;
    public static final int EncodingQualityLevel0 = -32;
    public static final int EncodingXCursor = -240;
    public static final int EncodingRichCursor = -239;
    public static final int EncodingPointerPos = -232;
    public static final int EncodingLastRect = -224;
    public static final int EncodingNewFBSize = -223;
    public static final String SigEncodingRaw = "RAW_____";
    public static final String SigEncodingCopyRect = "COPYRECT";
    public static final String SigEncodingRRE = "RRE_____";
    public static final String SigEncodingCoRRE = "CORRE___";
    public static final String SigEncodingHextile = "HEXTILE_";
    public static final String SigEncodingZlib = "ZLIB____";
    public static final String SigEncodingTight = "TIGHT___";
    public static final String SigEncodingZRLE = "ZRLE____";
    public static final String SigEncodingCompressLevel0 = "COMPRLVL";
    public static final String SigEncodingQualityLevel0 = "JPEGQLVL";
    public static final String SigEncodingXCursor = "X11CURSR";
    public static final String SigEncodingRichCursor = "RCHCURSR";
    public static final String SigEncodingPointerPos = "POINTPOS";
    public static final String SigEncodingLastRect = "LASTRECT";
    public static final String SigEncodingNewFBSize = "NEWFBSIZ";
    public static final int MaxNormalEncoding = 255;
    public static final int HextileRaw = 1;
    public static final int HextileBackgroundSpecified = 2;
    public static final int HextileForegroundSpecified = 4;
    public static final int HextileAnySubrects = 8;
    public static final int HextileSubrectsColoured = 16;
    public static final int TightMinToCompress = 12;
    public static final int TightExplicitFilter = 4;
    public static final int TightFill = 8;
    public static final int TightJpeg = 9;
    public static final int TightMaxSubencoding = 9;
    public static final int TightFilterCopy = 0;
    public static final int TightFilterPalette = 1;
    public static final int TightFilterGradient = 2;
    private String host;
    private int port;
    private Socket sock;
    private OutputStream os;
    private boolean inNormalProtocol = false;
    private DataInputStream is;
    private long numBytesRead = 0L;
    private String desktopName;
    private int framebufferWidth;
    private int framebufferHeight;
    private boolean brokenKeyPressed = false;
    private int numUpdatesInSession;
    long readServerDriveListTime = 0L;
    boolean timing;
    private long timeWaitedIn100us;
    private long timedKbits;
    private int serverMajor;
    private int serverMinor;
    private int clientMajor;
    private int clientMinor;
    private boolean fileTransfer = false;
    private boolean closed;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;
    boolean fFTInit = true;
    boolean fFTAllowed = true;
    boolean fAbort = false;
    boolean fFileReceptionError = false;
    boolean fFileReceptionRunning = false;
    boolean inDirectory2;
    FileOutputStream fos;
    FileInputStream fis;
    String sendFileSource;
    String receivePath;
    long fileSize;
    long receiveFileSize;
    long fileChunkCounter;
    static final int sz_rfbFileTransferMsg = 12;
    static final int rfbDirContentRequest = 1;
    static final int rfbDirPacket = 2;
    static final int rfbFileTransferRequest = 3;
    static final int rfbFileHeader = 4;
    static final int rfbFilePacket = 5;
    static final int rfbEndOfFile = 6;
    static final int rfbAbortFileTransfer = 7;
    static final int rfbFileTransferOffer = 8;
    static final int rfbFileAcceptHeader = 9;
    static final int rfbCommand = 10;
    static final int rfbCommandReturn = 11;
    static final int rfbFileChecksums = 12;
    static final int rfbRDirContent = 1;
    static final int rfbRDrivesList = 2;
    static final int rfbADirectory = 1;
    static final int rfbAFile = 2;
    static final int rfbADrivesList = 3;
    static final int rfbADirCreate = 4;
    static final int rfbADirDelete = 5;
    static final int rfbAFileCreate = 6;
    static final int rfbAFileDelete = 7;
    static final int rfbCDirCreate = 1;
    static final int rfbCDirDelete = 2;
    static final int rfbCFileCreate = 3;
    static final int rfbCFileDelete = 4;
    static final int rfbRErrorUnknownCmd = 1;
    static final int rfbRErrorCmd = -1;
    static final int sz_rfbBlockSize = 8192;
    static final int sz_rfbZipDirectoryPrefix = 9;
    String rfbZipDirectoryPrefix = "!UVNCDIR-\u0000";

    public long getNumBytesRead() {
        return this.numBytesRead;
    }

    public RFBProtocol(String h, int p, IVNC vnc) {
        this.host = h;
        this.port = p;
        this.inDirectory2 = false;
        this.sendFileSource = "";
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
    }

    public synchronized void connect() throws IOException {
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    public synchronized void disconnect() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {}
        try {
            this.is.close();
        }
        catch (Exception exception) {}
        try {
            this.os.close();
        }
        catch (Exception exception) {}
        this.closed = true;
        System.out.println("RFB socket closed");
    }

    public synchronized boolean closed() {
        return this.closed;
    }

    public void readVersionMsg() throws Exception {
        byte[] b = new byte[12];
        this.readFully(b);
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.serverMinor = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
        if (this.serverMajor < 3) {
            throw new Exception("RFB server does not support protocol version 3");
        }
        this.fileTransfer = this.serverMinor == 6 || this.serverMinor == 16 || this.serverMinor == 18;
    }

    public void writeVersionMsg() throws IOException {
        this.clientMajor = 3;
        if (this.serverMajor > 3 || this.serverMinor >= 8) {
            this.clientMinor = 8;
            this.os.write(versionMsg_3_8.getBytes());
        } else if (this.serverMinor >= 7) {
            this.clientMinor = 7;
            this.os.write(versionMsg_3_7.getBytes());
        } else {
            this.clientMinor = 3;
            this.os.write(versionMsg_3_3.getBytes());
        }
    }

    public int negotiateSecurity() throws Exception {
        return this.clientMinor >= 7 ? this.selectSecurityType() : this.readSecurityType();
    }

    int readSecurityType() throws Exception {
        int secType = this.readU32();
        switch (secType) {
            case 0: {
                this.readConnFailedReason();
                return 0;
            }
            case 1: 
            case 2: {
                return secType;
            }
        }
        throw new Exception("Unknown security type from RFB server: " + secType);
    }

    int selectSecurityType() throws Exception {
        int secType = 0;
        int nSecTypes = this.readU8();
        if (nSecTypes == 0) {
            this.readConnFailedReason();
            return 0;
        }
        byte[] secTypes = new byte[nSecTypes];
        this.readFully(secTypes);
        int i = 0;
        while (i < nSecTypes) {
            System.out.println("secType" + i + ": " + secTypes[i]);
            ++i;
        }
        i = 0;
        while (i < nSecTypes) {
            if (secTypes[i] == 1 || secTypes[i] == 2) {
                secType = secTypes[i];
                break;
            }
            ++i;
        }
        if (secType == 0) {
            throw new Exception("Server did not offer supported security type");
        }
        this.os.write(secType);
        return secType;
    }

    public void authenticateNone() throws Exception {
        if (this.clientMinor >= 8) {
            this.readSecurityResult("No authentication");
        }
    }

    public void authenticateVNC(String pw) throws Exception {
        int firstZero;
        byte[] challenge = new byte[16];
        this.readFully(challenge);
        if (pw.length() > 8) {
            pw = pw.substring(0, 8);
        }
        if ((firstZero = pw.indexOf(0)) != -1) {
            pw = pw.substring(0, firstZero);
        }
        byte[] key = new byte[8];
        System.arraycopy(pw.getBytes(), 0, key, 0, pw.length());
        DesCipher des = new DesCipher(key);
        des.encrypt(challenge, 0, challenge, 0);
        des.encrypt(challenge, 8, challenge, 8);
        this.os.write(challenge);
        this.readSecurityResult("VNC authentication");
    }

    void readSecurityResult(String authType) throws Exception {
        int securityResult = this.readU32();
        switch (securityResult) {
            case 0: {
                System.out.println(String.valueOf(authType) + ": success");
                break;
            }
            case 1: {
                if (this.clientMinor >= 8) {
                    this.readConnFailedReason();
                }
                throw new Exception(String.valueOf(authType) + ": failed");
            }
            case 2: {
                throw new Exception(String.valueOf(authType) + ": failed, too many tries");
            }
            default: {
                throw new Exception(String.valueOf(authType) + ": unknown result " + securityResult);
            }
        }
    }

    void readConnFailedReason() throws Exception {
        int reasonLen = this.readU32();
        byte[] reason = new byte[reasonLen];
        this.readFully(reason);
        throw new Exception(new String(reason));
    }

    void writeInt(int value) throws IOException {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        this.os.write(b);
    }

    public void writeClientInit() throws IOException {
        this.os.write(0);
    }

    public void readServerInit() throws IOException {
        this.framebufferWidth = this.readU16();
        this.framebufferHeight = this.readU16();
        this.readU8();
        this.readU8();
        this.readU8();
        this.readU8();
        this.readU16();
        this.readU16();
        this.readU16();
        this.readU8();
        this.readU8();
        this.readU8();
        byte[] pad = new byte[3];
        this.readFully(pad);
        int nameLength = this.readU32();
        byte[] name = new byte[nameLength];
        this.readFully(name);
        this.desktopName = new String(name);
        this.inNormalProtocol = true;
    }

    void setFramebufferSize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
    }

    int readServerMessageType() throws IOException {
        int msgType = this.readU8();
        return msgType;
    }

    void readFramebufferUpdate() throws IOException {
        this.skipBytes(1);
        this.updateNRects = this.readU16();
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.readU16();
        this.updateRectY = this.readU16();
        this.updateRectW = this.readU16();
        this.updateRectH = this.readU16();
        this.updateRectEncoding = this.readU32();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 16 || this.updateRectEncoding == 7) {
            // empty if block
        }
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 255) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    public void readCopyRect() throws IOException {
        this.copyRectSrcX = this.readU16();
        this.copyRectSrcY = this.readU16();
    }

    public String readServerCutText() throws IOException {
        this.skipBytes(3);
        int len = this.readU32();
        byte[] text = new byte[len];
        this.readFully(text);
        return new String(text);
    }

    public int readCompactLen() throws IOException {
        int[] portion = new int[3];
        portion[0] = this.readU8();
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.readU8();
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.readU8();
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        return len;
    }

    void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) throws IOException {
        byte[] b = new byte[]{3, (byte)(incremental ? 1 : 0), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(w >> 8 & 0xFF), (byte)(w & 0xFF), (byte)(h >> 8 & 0xFF), (byte)(h & 0xFF)};
        this.os.write(b);
    }

    void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) throws IOException {
        byte[] b = new byte[20];
        b[0] = 0;
        b[4] = (byte)bitsPerPixel;
        b[5] = (byte)depth;
        b[6] = (byte)(bigEndian ? 1 : 0);
        b[7] = (byte)(trueColour ? 1 : 0);
        b[8] = (byte)(redMax >> 8 & 0xFF);
        b[9] = (byte)(redMax & 0xFF);
        b[10] = (byte)(greenMax >> 8 & 0xFF);
        b[11] = (byte)(greenMax & 0xFF);
        b[12] = (byte)(blueMax >> 8 & 0xFF);
        b[13] = (byte)(blueMax & 0xFF);
        b[14] = (byte)redShift;
        b[15] = (byte)greenShift;
        b[16] = (byte)blueShift;
        this.os.write(b);
    }

    void writeFixColourMapEntries(int firstColour, int nColours, int[] red, int[] green, int[] blue) throws IOException {
        byte[] b = new byte[6 + nColours * 6];
        b[0] = 1;
        b[2] = (byte)(firstColour >> 8 & 0xFF);
        b[3] = (byte)(firstColour & 0xFF);
        b[4] = (byte)(nColours >> 8 & 0xFF);
        b[5] = (byte)(nColours & 0xFF);
        int i = 0;
        while (i < nColours) {
            b[6 + i * 6] = (byte)(red[i] >> 8 & 0xFF);
            b[6 + i * 6 + 1] = (byte)(red[i] & 0xFF);
            b[6 + i * 6 + 2] = (byte)(green[i] >> 8 & 0xFF);
            b[6 + i * 6 + 3] = (byte)(green[i] & 0xFF);
            b[6 + i * 6 + 4] = (byte)(blue[i] >> 8 & 0xFF);
            b[6 + i * 6 + 5] = (byte)(blue[i] & 0xFF);
            ++i;
        }
        this.os.write(b);
    }

    public void writeSetEncodings(int[] encs, int len) throws IOException {
        byte[] b = new byte[4 + 4 * len];
        b[0] = 2;
        b[2] = (byte)(len >> 8 & 0xFF);
        b[3] = (byte)(len & 0xFF);
        int i = 0;
        while (i < len) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
            ++i;
        }
        this.os.write(b);
    }

    public void writeClientCutText(String text) throws IOException {
        byte[] b = new byte[8 + text.length()];
        b[0] = 6;
        b[4] = (byte)(text.length() >> 24 & 0xFF);
        b[5] = (byte)(text.length() >> 16 & 0xFF);
        b[6] = (byte)(text.length() >> 8 & 0xFF);
        b[7] = (byte)(text.length() & 0xFF);
        System.arraycopy(text.getBytes(), 0, b, 8, text.length());
        this.os.write(b);
    }

    void writeWheelEvent(MouseWheelEvent evt) throws IOException {
        int ptrmask;
        int clicks;
        this.eventBufLen = 0;
        int x = evt.getX();
        int y = evt.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if ((clicks = evt.getWheelRotation()) > 0) {
            ptrmask = 16;
        } else if (clicks < 0) {
            ptrmask = 8;
        } else {
            return;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)ptrmask;
        this.eventBuf[this.eventBufLen++] = (byte)(x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y & 0xFF);
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writePointerEvent(MouseEvent evt) throws IOException {
        int modifiers = evt.getModifiers();
        int mask2 = 2;
        int mask3 = 4;
        if (Options.reverseMouseButtons2And3) {
            mask2 = 4;
            mask3 = 2;
        }
        if (evt.getID() == 501) {
            if ((modifiers & 8) != 0) {
                this.pointerMask = mask2;
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                this.pointerMask = mask3;
                modifiers &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (evt.getID() == 502) {
            this.pointerMask = 0;
            if ((modifiers & 8) != 0) {
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                modifiers &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(modifiers);
        int x = evt.getX();
        int y = evt.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent evt) throws IOException {
        int key;
        boolean down;
        block44: {
            int keyChar;
            block43: {
                int code;
                keyChar = evt.getKeyChar();
                if (keyChar == 0) {
                    keyChar = 65535;
                }
                if (keyChar == 65535 && ((code = evt.getKeyCode()) == 17 || code == 16 || code == 157 || code == 18)) {
                    return;
                }
                boolean bl = down = evt.getID() == 401;
                if (!evt.isActionKey()) break block43;
                switch (evt.getKeyCode()) {
                    case 36: {
                        key = 65360;
                        break block44;
                    }
                    case 37: {
                        key = 65361;
                        break block44;
                    }
                    case 38: {
                        key = 65362;
                        break block44;
                    }
                    case 39: {
                        key = 65363;
                        break block44;
                    }
                    case 40: {
                        key = 65364;
                        break block44;
                    }
                    case 33: {
                        key = 65365;
                        break block44;
                    }
                    case 34: {
                        key = 65366;
                        break block44;
                    }
                    case 35: {
                        key = 65367;
                        break block44;
                    }
                    case 155: {
                        key = 65379;
                        break block44;
                    }
                    case 112: {
                        key = 65470;
                        break block44;
                    }
                    case 113: {
                        key = 65471;
                        break block44;
                    }
                    case 114: {
                        key = 65472;
                        break block44;
                    }
                    case 115: {
                        key = 65473;
                        break block44;
                    }
                    case 116: {
                        key = 65474;
                        break block44;
                    }
                    case 117: {
                        key = 65475;
                        break block44;
                    }
                    case 118: {
                        key = 65476;
                        break block44;
                    }
                    case 119: {
                        key = 65477;
                        break block44;
                    }
                    case 120: {
                        key = 65478;
                        break block44;
                    }
                    case 121: {
                        key = 65479;
                        break block44;
                    }
                    case 122: {
                        key = 65480;
                        break block44;
                    }
                    case 123: {
                        key = 65481;
                        break block44;
                    }
                    default: {
                        return;
                    }
                }
            }
            key = keyChar;
            if (key < 32) {
                if (evt.isControlDown()) {
                    key += 96;
                } else {
                    switch (key) {
                        case 8: {
                            key = 65288;
                            break;
                        }
                        case 9: {
                            key = 65289;
                            break;
                        }
                        case 10: {
                            key = 65293;
                            break;
                        }
                        case 27: {
                            key = 65307;
                        }
                    }
                }
            } else if (key == 127) {
                key = 65535;
            } else if (!(key <= 255 || key >= 65280 && key <= 65535 || key >= 8352 && key <= 8367)) {
                return;
            }
        }
        if (key == 229 || key == 197 || key == 228 || key == 196 || key == 246 || key == 214 || key == 167 || key == 189 || key == 163) {
            if (down) {
                this.brokenKeyPressed = true;
            }
            if (!down && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(evt.getModifiers());
                this.writeKeyEvent(key, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!down) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(evt.getModifiers());
        this.writeKeyEvent(key, down);
        if (!down) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int keysym, boolean down) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(down ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym & 0xFF);
    }

    void writeModifierKeyEvents(int newModifiers) {
        if ((newModifiers & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (newModifiers & 2) != 0);
        }
        if ((newModifiers & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (newModifiers & 1) != 0);
        }
        if ((newModifiers & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (newModifiers & 4) != 0);
        }
        if ((newModifiers & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (newModifiers & 8) != 0);
        }
        this.oldModifiers = newModifiers;
    }

    public void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public long timeWaited() {
        return this.timeWaitedIn100us;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        long before = 0L;
        if (this.timing) {
            before = System.currentTimeMillis();
        }
        this.is.readFully(b, off, len);
        if (this.timing) {
            int newKbits;
            long after = System.currentTimeMillis();
            long newTimeWaited = (after - before) * 10L;
            if (newTimeWaited > (long)((newKbits = len * 8 / 1000) * 1000)) {
                newTimeWaited = newKbits * 1000;
            }
            if (newTimeWaited < (long)(newKbits / 4)) {
                newTimeWaited = newKbits / 4;
            }
            this.timeWaitedIn100us += newTimeWaited;
            this.timedKbits += (long)newKbits;
        }
        this.numBytesRead += (long)len;
    }

    final int available() throws IOException {
        return this.is.available();
    }

    final int skipBytes(int n) throws IOException {
        int r = this.is.skipBytes(n);
        this.numBytesRead += (long)r;
        return r;
    }

    final int readU8() throws IOException {
        int r = this.is.readUnsignedByte();
        ++this.numBytesRead;
        return r;
    }

    final int readU16() throws IOException {
        int r = this.is.readUnsignedShort();
        this.numBytesRead += 2L;
        return r;
    }

    final int readU32() throws IOException {
        int r = this.is.readInt();
        this.numBytesRead += 4L;
        return r;
    }

    void writeRfbFileTransferMsg(int contentType, int contentParam, long size, long length, String text) throws IOException {
        byte[] byteArray;
        byte[] b = new byte[12];
        b[0] = 7;
        b[1] = (byte)contentType;
        b[2] = (byte)contentParam;
        byte by = 0;
        long c = 0L;
        c = size & 0xFFFFFFFFFF000000L;
        b[4] = by = (byte)(c >>> 24);
        c = size & 0xFF0000L;
        b[5] = by = (byte)(c >>> 16);
        c = size & 0xFF00L;
        b[6] = by = (byte)(c >>> 8);
        c = size & 0xFFL;
        b[7] = by = (byte)c;
        if (text != null) {
            byte[] byteArray0 = text.getBytes();
            int maxc = this.max_char(text);
            if (maxc > 255) {
                System.out.println("writeRfbFileTransferMsg: using getBytes(\"UTF-8\")");
                byteArray0 = text.getBytes("UTF-8");
            } else if (maxc > 127) {
                System.out.println("writeRfbFileTransferMsg: using getBytes(\"ISO-8859-1\")");
                byteArray0 = text.getBytes("ISO-8859-1");
            }
            byteArray = new byte[byteArray0.length + 1];
            int i = 0;
            while (i < byteArray0.length) {
                byteArray[i] = byteArray0[i];
                ++i;
            }
            byteArray[byteArray.length - 1] = 0;
            System.out.println("writeRfbFileTransferMsg: length: " + length + " -> byteArray.length: " + byteArray.length);
            length = byteArray.length;
        } else {
            String moo = "moo";
            byteArray = moo.getBytes();
        }
        c = length & 0xFFFFFFFFFF000000L;
        b[8] = by = (byte)(c >>> 24);
        c = length & 0xFF0000L;
        b[9] = by = (byte)(c >>> 16);
        c = length & 0xFF00L;
        b[10] = by = (byte)(c >>> 8);
        c = length & 0xFFL;
        b[11] = by = (byte)c;
        this.os.write(b);
        if (text != null) {
            this.os.write(byteArray);
        }
    }

    int max_char(String text) {
        char maxc = '\u0000';
        char[] chars = text.toCharArray();
        int n = 0;
        while (n < chars.length) {
            if (chars[n] > maxc) {
                maxc = chars[n];
            }
            ++n;
        }
        return maxc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String guess_encoding(char[] chars) {
        boolean saw_high_char = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\u0000') break;
            if (chars[i] >= '\u0080') {
                saw_high_char = true;
                break;
            }
            ++i;
        }
        if (!saw_high_char) {
            return "ASCII";
        }
        int prev = 1;
        boolean valid_utf8 = true;
        int n = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == '\u0000') break;
            int c = chars[i2];
            if (prev < 128 && c >= 128) {
                if (c >> 5 == 6) {
                    n = 1;
                } else if (c >> 4 == 14) {
                    n = 2;
                } else if (c >> 3 == 30) {
                    n = 3;
                } else {
                    if (c >> 2 != 62) return "ISO-8859-1";
                    n = 4;
                }
            } else if (n > 0) {
                if (c < 128) {
                    return "ISO-8859-1";
                }
                --n;
            }
            prev = c;
            ++i2;
        }
        if (!valid_utf8) return "ISO-8859-1";
        return "UTF-8";
    }

    int zogswap(int n) {
        long l = n;
        if (l < 0L) {
            l += 0x100000000L;
        }
        l &= 0xFFFFFFFFFFFFFFFFL;
        l = l >> 24 | (l & 0xFF0000L) >> 8 | (l & 0xFF00L) << 8 | l << 24;
        return (int)l;
    }

    int windozeToUnix(int L, int H) {
        long L2 = this.zogswap(L);
        long H2 = this.zogswap(H);
        long unix = (H2 << 32) + L2;
        unix -= 116444736000000000L;
        return (int)(unix /= 10000000L);
    }

    String timeStr(int t, int h) {
        t = h == 0 ? this.zogswap(t) : this.windozeToUnix(t, h);
        long tl = t;
        Date date = new Date(tl * 1000L);
        return date.toString();
    }

    String dotPast(double f, int n) {
        String fs = "" + f;
        int i = fs.lastIndexOf(".") + n;
        if (i >= 0) {
            int len = fs.length();
            if (i >= len) {
                i = len - 1;
            }
            fs = fs.substring(0, i);
        }
        return fs;
    }

    String sizeStr(int s) {
        if ((s = this.zogswap(s)) < 0) {
            return String.valueOf(s) + "? B";
        }
        if (s < 1024) {
            return String.valueOf(s) + " B";
        }
        if (s < 0x100000) {
            double k = (double)s / 1024.0;
            String ks = this.dotPast(k, 3);
            return String.valueOf(s) + " (" + ks + " KB)";
        }
        double m = (double)s / 1048576.0;
        String ms = this.dotPast(m, 3);
        return String.valueOf(s) + " (" + ms + " MB)";
    }

    public boolean isInNormalProtocol() {
        return this.inNormalProtocol;
    }

    public String getDesktopName() {
        return this.desktopName;
    }

    public int getFrameBufferWidth() {
        return this.framebufferWidth;
    }

    public int getFrameBufferHeight() {
        return this.framebufferHeight;
    }

    public int getServerMajor() {
        return this.serverMajor;
    }

    public int getServerMinor() {
        return this.serverMinor;
    }

    public int getClientMajor() {
        return this.clientMajor;
    }

    public int getClientMinor() {
        return this.clientMinor;
    }

    public int getUpdatesInSession() {
        return this.numUpdatesInSession;
    }

    public boolean fileTransferAllowed() {
        return this.fileTransfer;
    }
}

