/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.changeid;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.components.ProgressDialog;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.changeid.ChangeID;
import de.bsc.bapfinder.plugins.changeid.localization.Messages;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ChangeIDDialog
extends JDialog
implements ActionListener,
IBAPFinder.IDeviceListener {
    private static final long serialVersionUID = 3124515714752308336L;
    public static final int COMMAND_CHANGE_ID = 2;
    public static final int COMMAND_REBOOT = 4;
    public static final int MESSAGE_COMMAND = 1;
    public static final int MESSAGE_COMMAND_ANSWER = 6;
    private IBAPFinder.IBAP bap;
    private String mac;
    private Window owner;
    private IBAPFinder api;
    private ChangeID plugin;
    private JPanel jContentPane;
    private JWizardHeader wizardHeader;
    private JPanel panelSettings;
    private JPanel panelButtons;
    private JButton buttonCommit;
    private JButton buttonClose;
    private JPanel panelCurrentID = null;
    private JPanel paneNewID = null;
    private JTextField textFieldCurrentID = null;
    private JTextField textFieldNewID = null;

    public ChangeIDDialog(ChangeID plugin) {
        super(plugin.api.getWindow());
        this.plugin = plugin;
        this.api = plugin.api;
        this.owner = this.api.getWindow();
        this.bap = (IBAPFinder.IBAP)this.api.getSelectedDevice();
        this.mac = this.bap.getMac();
        this.initialize();
        this.setLocationRelativeTo(this.owner);
        this.setModal(true);
    }

    private void initialize() {
        this.setSize(444, 353);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
        this.api.addBAPListener((IBAPFinder.IDeviceListener)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                ChangeIDDialog.this.api.removeBAPListener((IBAPFinder.IDeviceListener)ChangeIDDialog.this);
            }
        });
    }

    public void deviceReceived(IBAPFinder.IDevice device) {
        if (!(device instanceof IBAPFinder.IBAP)) {
            return;
        }
        IBAPFinder.IBAP bap = (IBAPFinder.IBAP)device;
        if (this.bap != null || !bap.getMac().equals(this.mac)) {
            return;
        }
        this.bap = bap;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("close")) {
            this.setVisible(false);
            this.dispose();
        } else if (command.equals("commit")) {
            SwingWorker<Void, Integer> task = new SwingWorker<Void, Integer>(){

                @Override
                protected Void doInBackground() {
                    RandomArrayStream stream = new RandomArrayStream();
                    this.firePropertyChange("progressInfo", null, Messages.getString("ChangeIDDialog.4"));
                    this.firePropertyChange("indeterminate", null, true);
                    try {
                        long newID = 0L;
                        try {
                            newID = ChangeIDDialog.getNewID(ChangeIDDialog.this.textFieldNewID.getText());
                            if (newID == 0L) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PluginException(0);
                        }
                        stream.seek(0);
                        stream.trim();
                        stream.writeInt(2);
                        stream.writeLong(ChangeIDDialog.this.bap.getId());
                        stream.writeLong(newID);
                        IBAPFinder.IMessage message = ChangeIDDialog.this.api.sendToConfigPort((IBAPFinder.IDevice)ChangeIDDialog.this.bap, 1, stream, true, 60000);
                        if (message.getMessageType() != 1) {
                            throw new PluginException(1);
                        }
                        if (message.getDataType() != 6) {
                            throw new PluginException(1);
                        }
                        int result = message.getData().readInt();
                        if (result != 0) {
                            throw new PluginException(result);
                        }
                        stream.seek(0);
                        stream.trim();
                        stream.writeInt(4);
                        Tools.sendToConfigPort((IBAPFinder.IDevice)ChangeIDDialog.this.bap, (int)1, (RandomArrayStream)stream);
                        this.firePropertyChange("progressInfo", null, Messages.getString("ChangeIDDialog.7"));
                        this.firePropertyChange("indeterminate", null, true);
                        ChangeIDDialog.this.api.removeDevice(ChangeIDDialog.this.mac);
                        ChangeIDDialog.this.bap = null;
                        long starttime = System.currentTimeMillis();
                        while (ChangeIDDialog.this.bap == null && starttime + 120000L > System.currentTimeMillis()) {
                            Thread.sleep(10L);
                        }
                        if (ChangeIDDialog.this.bap == null) {
                            throw new PluginException(6);
                        }
                    }
                    catch (Exception e) {
                        this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                        ChangeIDDialog.this.processError(e);
                        return null;
                    }
                    this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                    ChangeIDDialog.this.processSuccess();
                    return null;
                }
            };
            ProgressDialog progressDialog = new ProgressDialog((Window)this, Messages.getString("ChangeIDDialog.11"), (SwingWorker)task, false);
            progressDialog.setImage((Image)this.plugin.loadImage("id.png"));
            task.execute();
        }
    }

    private void processSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.13"), Messages.getString("ChangeIDDialog.11"), 1);
            }
        });
    }

    private void processError(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e instanceof PluginException) {
                    PluginException pluginException = (PluginException)e;
                    int errorcode = pluginException.getErrorcode();
                    if (errorcode == 0) {
                        Tools.flash((Component)ChangeIDDialog.this.textFieldNewID, (Color)Color.RED, (int)2);
                    } else if (errorcode == 1) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.15"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else if (errorcode == 6) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.17"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else if (errorcode == 2) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.19"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else if (errorcode == -126) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.21"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else if (errorcode == -112) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.23"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else if (errorcode == -111) {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.25"), Messages.getString("ChangeIDDialog.11"), 0);
                    } else {
                        JOptionPane.showMessageDialog(ChangeIDDialog.this, Messages.getString("ChangeIDDialog.27"), Messages.getString("ChangeIDDialog.11"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(ChangeIDDialog.this, String.valueOf(Messages.getString("ChangeIDDialog.29")) + Tools.getStackTrace((Throwable)e), Messages.getString("ChangeIDDialog.11"), 0);
                }
            }
        });
    }

    private static long getNewID(String text) throws NumberFormatException {
        long value = 0L;
        if (text.toLowerCase().startsWith("0x") ? text.length() > 2 && (value = Long.parseLong(text.substring(2), 16)) > 0xFFFFFFFFL : (value = Long.parseLong(text, 10)) > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        return value;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints constraintsPanelButtons = new GridBagConstraints();
            constraintsPanelButtons.gridx = 0;
            constraintsPanelButtons.fill = 2;
            constraintsPanelButtons.gridy = 2;
            GridBagConstraints constraintsPanelSettings = new GridBagConstraints();
            constraintsPanelSettings.gridx = 0;
            constraintsPanelSettings.fill = 1;
            constraintsPanelSettings.weightx = 1.0;
            constraintsPanelSettings.weighty = 1.0;
            constraintsPanelSettings.gridy = 1;
            GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
            constraintsWizardHeader.gridx = 0;
            constraintsWizardHeader.fill = 2;
            constraintsWizardHeader.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), constraintsWizardHeader);
            this.jContentPane.add((Component)this.getPanelSettings(), constraintsPanelSettings);
            this.jContentPane.add((Component)this.getPanelButtons(), constraintsPanelButtons);
        }
        return this.jContentPane;
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setImage((Image)this.plugin.loadImage("id.png"));
            this.wizardHeader.setTextHeader1(Messages.getString("ChangeIDDialog.33"));
            this.wizardHeader.setTextHeader2(Messages.getString("ChangeIDDialog.34"));
        }
        return this.wizardHeader;
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.anchor = 10;
            gridBagConstraints11.weighty = 0.0;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new GridBagLayout());
            this.panelSettings.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelSettings.add((Component)this.getPanelCurrentID(), gridBagConstraints);
            this.panelSettings.add((Component)this.getPaneNewID(), gridBagConstraints1);
        }
        return this.panelSettings;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 0, 5, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.anchor = 13;
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new GridBagLayout());
            this.panelButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelButtons.add((Component)this.getButtonCommit(), gridBagConstraints3);
            this.panelButtons.add((Component)this.getButtonClose(), gridBagConstraints4);
        }
        return this.panelButtons;
    }

    private JButton getButtonCommit() {
        if (this.buttonCommit == null) {
            this.buttonCommit = new JButton();
            this.buttonCommit.setFont(new Font("Tahoma", 0, 11));
            this.buttonCommit.setText(Messages.getString("ChangeIDDialog.0"));
            this.buttonCommit.setPreferredSize(new Dimension(100, 25));
            this.buttonCommit.setMaximumSize(new Dimension(100, 24));
            this.buttonCommit.setMinimumSize(new Dimension(100, 24));
            this.buttonCommit.setActionCommand("commit");
            this.buttonCommit.addActionListener(this);
        }
        return this.buttonCommit;
    }

    private JButton getButtonClose() {
        if (this.buttonClose == null) {
            this.buttonClose = new JButton();
            this.buttonClose.setFont(new Font("Tahoma", 0, 11));
            this.buttonClose.setText(Messages.getString("ChangeIDDialog.1"));
            this.buttonClose.setPreferredSize(new Dimension(100, 25));
            this.buttonClose.setMaximumSize(new Dimension(100, 24));
            this.buttonClose.setMinimumSize(new Dimension(100, 24));
            this.buttonClose.setActionCommand("close");
            this.buttonClose.addActionListener(this);
        }
        return this.buttonClose;
    }

    private JPanel getPanelCurrentID() {
        if (this.panelCurrentID == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            this.panelCurrentID = new JPanel();
            this.panelCurrentID.setLayout(new GridBagLayout());
            this.panelCurrentID.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("ChangeIDDialog.41"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelCurrentID.add((Component)this.getTextFieldCurrentID(), gridBagConstraints2);
        }
        return this.panelCurrentID;
    }

    private JPanel getPaneNewID() {
        if (this.paneNewID == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridx = 0;
            this.paneNewID = new JPanel();
            this.paneNewID.setLayout(new GridBagLayout());
            this.paneNewID.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("ChangeIDDialog.43"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.paneNewID.add((Component)this.getTextFieldNewID(), gridBagConstraints6);
        }
        return this.paneNewID;
    }

    private JTextField getTextFieldCurrentID() {
        if (this.textFieldCurrentID == null) {
            this.textFieldCurrentID = new JTextField();
            this.textFieldCurrentID.setEditable(false);
            this.textFieldCurrentID.setText(String.format("%d / 0x%s", this.bap.getId(), Tools.toHexString((int)((int)this.bap.getId()))));
        }
        return this.textFieldCurrentID;
    }

    private JTextField getTextFieldNewID() {
        if (this.textFieldNewID == null) {
            this.textFieldNewID = new JTextField();
            this.textFieldNewID.setDocument(new Filter_DEC_HEX(this.textFieldNewID));
        }
        return this.textFieldNewID;
    }

    private static class Filter_DEC_HEX
    extends PlainDocument {
        private static final long serialVersionUID = -975692186695030670L;
        private JTextField textField;

        public Filter_DEC_HEX(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            String newString = str.toLowerCase();
            String text = this.textField.getText().toLowerCase();
            String newText = String.valueOf(text) + newString;
            try {
                ChangeIDDialog.getNewID(newText);
            }
            catch (Exception exception) {
                Tools.flash((Component)this.textField, (Color)Color.RED, (int)2);
                return;
            }
            super.insertString(offset, str, attr);
        }
    }
}

