/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.apple.eio.FileManager;
import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.MacOSXAutoUpdater;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.MacIconEncoder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sun.security.action.GetPropertyAction;

public class MacOSXPlatform
extends Platform {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static String ORACLE_JAVA_DEPLOYMENT = "Oracle" + File.separator + "Java" + File.separator + "Deployment";
    private static final int[] DEFAULT_SIZES = new int[]{512, 256, 128, 32, 16};

    public MacOSXPlatform() {
        this.loadDeployNativeLib();
    }

    public void loadDeployNativeLib() {
        try {
            System.load(Environment.getJavaHome() + File.separator + "lib" + File.separator + "libdeploy.dylib");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new MacOSXAutoUpdater();
        }
        return this.auInstance;
    }

    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new MacIconEncoder();
        }
        return this.ieInstance;
    }

    public String getPlatformIconType() {
        return "icns";
    }

    public void addRemoveProgramsAdd(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
    }

    public void addRemoveProgramsRemove(String string, boolean bl) {
    }

    public boolean canAutoDownloadJRE() {
        return false;
    }

    public boolean canUseAlternateJREs() {
        return false;
    }

    public String getBrowserPath() {
        return null;
    }

    public String getBrowserHomePath() {
        return null;
    }

    public String getDefaultSystemCache() {
        return null;
    }

    public String getFireFoxUserProfileDirectory() {
        return null;
    }

    public boolean canBecomeAdmin() {
        return true;
    }

    public boolean hasAdminPrivileges() {
        return false;
    }

    public Vector getInstalledJREList() {
        Vector<String> vector = new Vector<String>();
        vector.add(System.getProperty("java.version"));
        vector.add(Environment.getJavaHome());
        return vector;
    }

    public void notifyJREInstalled(String string) {
    }

    public String getMozillaUserProfileDirectory() {
        return null;
    }

    public native long getNativePID();

    public String getSessionSpecificString() {
        return "";
    }

    public String getSystemJavawsPath() {
        return Environment.getJavawsCommand();
    }

    public int[] getIconSizes() {
        return DEFAULT_SIZES;
    }

    public int getSystemShortcutIconSize(boolean bl) {
        return 128;
    }

    public int installShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return 0;
    }

    public String getShortcutJnlpName(String string) {
        return null;
    }

    public boolean isBrowserFireFox() {
        return false;
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isNativeModalDialogUp() {
        return false;
    }

    public boolean isPlatformIconType(String string) {
        return string.toLowerCase().endsWith(".icns");
    }

    public boolean isPlatformWindowsVista() {
        return false;
    }

    public void sendJFXPing(String string, String string2, String string3, String string4, String string5, int n, String string6) {
    }

    public void setUserHomeOverride(String string) {
    }

    static boolean doShowDocument(final URL uRL) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    FileManager.openURL((String)uRL.toString());
                    return Boolean.TRUE;
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    return Boolean.FALSE;
                }
            }
        });
        return bl;
    }

    public boolean showDocument(String string) {
        try {
            return MacOSXPlatform.doShowDocument(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return false;
        }
    }

    public boolean getJqsSettings() {
        return false;
    }

    public void setJqsSettings(boolean bl) {
    }

    public boolean getJavaPluginSettings() {
        return true;
    }

    public int setJavaPluginSettings(boolean bl) {
        return 2;
    }

    public void initBrowserSettings() {
    }

    public int applyBrowserSettings() {
        return 0;
    }

    public boolean systemLookAndFeelDefault() {
        return true;
    }

    public String getUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                String string2 = this.nativeGetHome(true);
                string = string2 != null ? string2 : AccessController.doPrivileged(new GetPropertyAction("user.home"));
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + ORACLE_JAVA_DEPLOYMENT;
        }
        return this._userHome;
    }

    public String getUserHomeOverride() {
        return null;
    }

    public String getSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = this.nativeGetHome(false) + File.separator + ORACLE_JAVA_DEPLOYMENT;
        }
        return this._systemHome;
    }

    public String getOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    public String getPlatformSpecificJavaName() {
        return "java";
    }

    public String getPlatformExtension() {
        return "";
    }

    public String getLibraryPrefix() {
        return "lib";
    }

    public String getLibrarySufix() {
        return ".dylib";
    }

    public String getDebugJavaPath(String string) {
        return string;
    }

    public String getLongPathName(String string) {
        return string;
    }

    public boolean samePaths(String string, String string2) {
        try {
            return new File(string).getCanonicalPath().equals(new File(string2).getCanonicalPath());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public native int getPlatformMaxCommandLineLength();

    public boolean useAltFileSystemView() {
        return false;
    }

    public String toExecArg(String string) {
        return string;
    }

    public native void onLoad(Object var1);

    public void onSave(Object object) {
    }

    public boolean shouldPromptForAutoCheck() {
        return false;
    }

    public void handleUserResponse(int n) {
    }

    public void resetJavaHome() {
    }

    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
        defaultConfig.setProperty("deployment.system.tray.icon", "false");
    }

    public native String getLoadedNativeLibPath(String var1);

    public void cacheSecurityBaseline(String string, String string2) {
    }

    private native String nativeGetHome(boolean var1);

    public String getDefaultIconPath() {
        return this.nativeGetIconPath();
    }

    private native String nativeGetIconPath();

    public void cacheCurrentConfig(Properties properties) {
        try {
            Preferences preferences = Preferences.userRoot().node("/com/oracle/javadeployment");
            preferences.clear();
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                preferences.put(string, properties.getProperty(string));
            }
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Trace.ignored(backingStoreException);
        }
    }

    public native boolean getAutoUpdateCheckEnabled();

    public native boolean setAutoUpdateCheckEnabled(boolean var1);

    public Platform.WebJavaSwitch getWebJavaSwitch() {
        return MacOSXWebJavaSwitch.getInstance();
    }

    public static final class MacOSXWebJavaSwitch
    extends Platform.WebJavaSwitch {
        private static final String JAVA_APPLICATION_SUPPORT_INFO_PLIST_SYMLINK = "/Library/Application Support/Oracle/Java/Info.plist";
        private static final String JAVA_PLUGIN_ENABLED_INFO_PLIST = "/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Enabled.plist";
        private static MacOSXWebJavaSwitch _MacOSXWebJavaSwitch = new MacOSXWebJavaSwitch();

        private MacOSXWebJavaSwitch() {
        }

        public static MacOSXWebJavaSwitch getInstance() {
            return _MacOSXWebJavaSwitch;
        }

        protected void setSystemWebJavaEnabled(boolean bl) {
            if (bl != this.isSystemWebJavaEnabled()) {
                this.setNativeSystemWebJavaEnabled(bl);
            }
        }

        protected boolean isSystemWebJavaEnabled() {
            boolean bl = false;
            try {
                Path path;
                Path path2;
                Path path3 = new File(JAVA_APPLICATION_SUPPORT_INFO_PLIST_SYMLINK).toPath();
                if (Files.isSymbolicLink(path3) && Files.isSameFile(path2 = Files.readSymbolicLink(path3), path = new File(JAVA_PLUGIN_ENABLED_INFO_PLIST).toPath())) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }

        private native void setNativeSystemWebJavaEnabled(boolean var1);
    }
}

